// PJ-Chess: "Mate in two."
//
// by Peter R. Jones
// Copyright (C) 1997
//
// Entry #1 for IRTC Jan-Feb 1997; Glass.

// Scene initialisation: includes, lights, camera.

#include "colors.inc"

#declare ChessSet_Texture = 2
#include "ChessSet.inc"

#declare Chess_SquareSize = 30
#declare Chess_BoardBorder = 25
#declare Chess_DividerW = 2
#declare Chess_DividerH = 0.1
#declare Chess_BoardThick = 25
#include "ChessBrd.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 20
  }

camera {
  perspective
  location <700,1500,-1100>
  look_at <80,750,-50>
  angle 21
  }

//light_source { <0,2100,0> color White }

sky_sphere {
  pigment { color SkyBlue }
  }

// Surrounding room as required.

#include "Room.inc"
object { Room }

// Furniture as required

#include "Furnitur.inc"
object { Table }

// The box that the game came in...

#include "ChessBox.inc"
declare EmptyBox = union {
  object { ChessBox }
  object {
    BoxLid
    translate <157.5,-1,0>
    rotate <0,0,11.771>
    rotate <0,-45,0>
    translate <-273.991,0,-196.490>
    }
  }

object { EmptyBox rotate <0,115,0> translate <210,750,-95> }

// Game in progress: Action...

#declare ChessGame = union {
  #declare PieceRot = seed(32)
  object { ChessBoard }
  object { Pawn_White rotate y*rand(PieceRot)*360 translate <48,25,-48> }
  object { Pawn_White rotate y*rand(PieceRot)*360 translate <16,25,-80> }
  object { Rook_White rotate y*rand(PieceRot)*360 translate <48,25,-112> }
  object { Rook_White rotate y*rand(PieceRot)*360 translate <112,25,-80> }
  object { Knight_White rotate y*rand(PieceRot)*360 translate <-48,25,-112> }
  object { Knight_White rotate y*rand(PieceRot)*360 translate <-48,25,80> }
  object { Bishop_White rotate y*rand(PieceRot)*360 translate <80,25,-112> }
  object { Bishop_White rotate y*rand(PieceRot)*360 translate <112,25,80> }
  object { Queen_White rotate y*rand(PieceRot)*360 translate <112,25,16> }
  object { King_White rotate y*rand(PieceRot)*360 translate <80,25,-80> }
  object { Pawn_Black rotate y*rand(PieceRot)*360 translate <-48,25,16> }
  object { Pawn_Black rotate y*rand(PieceRot)*360 translate <-48,25,-16> }
  object { Rook_Black rotate y*rand(PieceRot)*360 translate <16,25,112> }
  object { Rook_Black rotate y*rand(PieceRot)*360 translate <48,25,112> }
  object { Bishop_Black rotate y*rand(PieceRot)*360 translate <80,25,112> }
  object { Bishop_Black rotate y*rand(PieceRot)*360 translate <-16,25,112> }
  object { King_Black rotate y*rand(PieceRot)*360 translate <48,25,-16> }
  }

object { ChessGame rotate y*2 translate <-100,750,20> }

object { Pawn_Black rotate y*rand(PieceRot)*360 translate <140,751,-150> }
object { Pawn_Black rotate y*rand(PieceRot)*360 translate <155,751,-165> }
object { Pawn_Black rotate y*rand(PieceRot)*360 translate <156,751,-139> }
object { Pawn_Black rotate y*rand(PieceRot)*360 translate <169,751,-107> }
object { Pawn_Black rotate y*rand(PieceRot)*360 translate <131,751,-135> }
object { Pawn_Black rotate y*rand(PieceRot)*360 translate <133,751,-167> }
object { Knight_Black rotate y*rand(PieceRot)*360 translate <192.5,751,-81.5> }
object { Knight_Black rotate y*rand(PieceRot)*360 translate <191.5,751,-175.5> }
object { Queen_Black rotate y*rand(PieceRot)*360 translate <155,751,-81> }

#declare LazyPawn = object {
  Pawn_White
  rotate y*rand(PieceRot)*360
  rotate x*96.6557
  translate <0,758.2197,0>
  }

object { LazyPawn rotate y*214.1 translate <-298.5,0.01,117> }
object { LazyPawn rotate y*102.9 translate <-285.5,0.01,135> }
object { LazyPawn rotate y*224.1 translate <-348,0.01,125> }
object { Pawn_White rotate y*rand(PieceRot)*360 translate <-332.5,750.01,155> }
object { Pawn_White rotate y*rand(PieceRot)*360 translate <-300,750.01,155> }
object { Pawn_White rotate y*rand(PieceRot)*360 translate <-322.5,750.01,114.5> }

box {
  <0,0,0>, <210,0.01,297>
  texture {
    pigment {
      image_map {
        gif "A4SHEET.GIF"
        }
      rotate x*90
      scale <210,1,297>
      }
    }
  rotate -81*y
  translate <-200,750,51>
  }
