#include "woods.inc"

#declare FloorTex = texture {
  T_Wood2
  finish {
    specular 0.6
    roughness 0.001
    reflection 0.01
    }
  scale 100
  rotate <3,0,7>
  translate <20,20,20>
  }

#declare WallPaint = texture {
  pigment { color rgb <0.95,0.935,1.0> }
  }

#declare SkirtPaint = texture {
  pigment { color rgb <0.45,0.5,0.8> }
  }

#declare Plank = difference {
  box { <-37.5,-15,-1>, <37.5,0,1> }
  box { <25,0,-2>, <-25,20,2> rotate <0,0,-40> translate <32,0,0> }
  box { <25,0,-2>, <-25,20,2> rotate <0,0,-40> translate <32,0,0> }
  }

#declare Floor = union {
  #declare R1 = seed(500)
  #declare R2 = seed(1234)
  #declare PlankCnt = -2500
  #while (PlankCnt < 2580)
    object {
      Plank
      scale <1,1,2550>
      translate <PlankCnt,0,0>
      texture {
        FloorTex
        rotate <0,3-rand(R1)*6,0>
        translate <rand(R1)*99,rand(R1)*99,rand(R1)*99>
        }
      }
    #declare PlankCnt = PlankCnt + 76 + rand(R2)
    #end
  box {
    <-2550,-20,-2550>, <2550,-15,2550>
    texture { pigment { color rgb <0.1,0.1,0.1> } }
    }
  }

#declare Ceiling = union {
  box { <-2550,2200,-2550>, <2550,2220,2550> texture { WallPaint } }
  light_source { <0,2050,0> color rgb <1,1,1> looks_like { sphere { <0,2050,0>, 45 } } }
  light_source { <2350,2050,-2350> color rgb <0.8,0.8,0.5> looks_like { sphere { <2350,2050,-2350>, 45 } } }
  }

//#declare RemoveDoorWay = box { <-325,0,-325>, <325,1975,325> }
//#declare DoorWay = union {
//  }
//
//#declare RemoveWindow = box { <-350,80,-350>, <350,1800,350> }
//#declare Window = union {
//  }
//
#declare Wall1 = union {
  box {
    <-2500,-20,0>, <2500,2220,100>
    texture { WallPaint }
    }
  box {
    <-2500,0,-15>, <2500,80,0>
    texture { SkirtPaint }
    }
  box {
    <-2500,2200,-15>, <2500,2135,0>
    texture { SkirtPaint }
    }
  translate <0,0,2500>
  }

#declare Room = union {
  object { Floor }
  object { Ceiling }
  object { Wall1 }
  object { Wall1 rotate y*90 }
  object { Wall1 rotate y*180 }
  object { Wall1 rotate y*270 }
  }


