// Entered into the January/February raytracing competition
// by Raymond Ore http://rore@raymation.co.uk

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// Makes a great burled maple, too
#declare ReflectiveSandalWood =
texture {
  pigment
  {
    bozo
    turbulence 0.2
    color_map
    {
      [0.00 color rgb<0.722, 0.659, 0.455>]
      [0.17 color rgb<0.678, 0.545, 0.420>]
      [0.27 color rgb<0.557, 0.451, 0.322>]
      [0.39 color rgb<0.722, 0.659, 0.455>]
      [0.56 color rgb<0.678, 0.545, 0.420>]
      [0.70 color rgb<0.478, 0.388, 0.275>]
      [1.00 color rgb<0.722, 0.659, 0.455>]
    }
    scale <0.2, 0.2, 1.0>
  }
  normal
  {
    bumps 0.1
    scale <10.0, 10.0, 10.0>
  }
  finish {
    ambient 0.2
    diffuse 0.7
    reflection 0.3
  }
  scale <2.0, 2.0, 2.0>
}
texture {
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgbf<0.678, 0.604, 0.376, 1.000>]
      [0.09 color rgbf<0.761, 0.690, 0.600, 0.020>]
      [0.23 color rgbf<0.631, 0.553, 0.322, 1.000>]
      [0.35 color rgbf<0.761, 0.690, 0.600, 0.020>]
      [0.50 color rgbf<0.678, 0.604, 0.376, 1.000>]
      [0.56 color rgbf<0.761, 0.690, 0.600, 0.020>]
      [0.66 color rgbf<0.678, 0.604, 0.376, 1.000>]
      [0.83 color rgbf<0.761, 0.690, 0.600, 0.020>]
      [1.00 color rgbf<0.678, 0.604, 0.376, 1.000>]
    }
  }
  normal
  {
    bumps 0.01
    scale <20.0, 20.0, 20.0>
  }
  finish {
    ambient 0.2
    diffuse 0.7
    specular 0.49
    reflection 0.4
  }
}


#declare MyGlass = texture
{
  pigment
  {
    colour rgbf<1.000,1.000,1.000,0.9>
  }
  normal
  {
    bumps 0.01
  }
  finish {
    ambient 0.0
    diffuse 0.0
    specular 1.0
    reflection 0.1
    refraction 1.0    ior 1.5
    caustics 1
  }
}


#declare Purple_Liquid = texture
{
  pigment
  {
    colour rgbf<1.000,0,0.85,0.5>
  }
  finish {
    diffuse 0.1
    specular 0.8    roughness 0.01
    phong 1.0    phong_size 40
    ambient 0.3
    refraction 1.0    ior 1.329
    caustics 1
  }
}

#declare Yellow_Liquid = texture
{
  pigment
  {
    colour rgbf<0.8,0.5,0.2,0.3>
  }
  finish {
    diffuse 0.1
    specular 0.8    roughness 0.01
    phong 1.0    phong_size 40
    ambient 0.3
    refraction 1.0    ior 1.3
    caustics 1
  }
}

#declare Red_Liquid = texture
{
  pigment
  {
    colour rgbf<1.000,0,0,0.5>
  }
  finish {
    diffuse 0.1
    specular 0.8    roughness 0.01
    phong 1.0    phong_size 40
    ambient 0.3
    refraction 1.0    ior 2
    caustics 1
  }
}

#declare GreenGlow = texture
{
  pigment
  {
    colour rgbf<0.651,0.980,0.122,0.5>
  }
  finish {
    ambient 0.5
    diffuse 0.1
    specular 0.8    roughness 0.01
    phong 1.0    phong_size 400
    reflection 0.1
    refraction 1.0    ior 1.45
  }
}


// I'd like to see the aperture at about 20 and blur_samples at 100

camera
{
  location  <0.0 , 80.0 , -150.0>
  look_at   <0.0 , 40 , 50>
  aperture 8              // 0...N (bigger is narrower depth of field)
  blur_samples 40             // # of rays per pixel
  focal_point <20,40,50>       // x,y,z point that is in focus

}




light_source
{
  0*x
  color Gray30
  translate <-20, 200, -200>
}

light_source
{
  0*x
  color Gray30
  translate <300, 100, -200>
}

light_source
{
  0*x
  color White
  translate <-100, 40, 200>
}

// if your brave replace the light above with the one below

/*
// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  translate <-100, 40, 200>   // <x y z> position of light
}
*/


plane
{
  y,
  -1.0
  texture{ReflectiveSandalWood}
}


#declare Purple_Beaker = union {

  lathe {
    cubic_spline
    17,
    <0, 0>, <17, 0>, <23, 6>, <15, 27>, <7, 45>, <7, 65>, <10, 70>, <11, 70>, <11, 71>,
    <9, 71>, <6, 65>, <6, 45>, <14, 27>, <22, 6>, <17, 0>, <0, 1>, <0, 0>
    texture {MyGlass}
  }

intersection
{
  lathe {
    cubic_spline
    11,
    <9, 71>, <6, 65>, <6, 45>, <14, 27>, <22, 6>, <17, 0>, <0, 1>, <0, 0>, <0, 0>, <0, 71>, <0, 71>
        }
  box{
      <-24, 0, -24>
      < 24, 35, 24>
     }
  texture {Purple_Liquid}
  scale <0.99, 0.99, 0.99>
 }
} //end purple

#declare Yellow_Beaker = union {

  lathe {
    cubic_spline
    17,
    <0, 0>, <17, 0>, <23, 6>, <15, 27>, <7, 45>, <7, 65>, <10, 70>, <11, 70>, <11, 71>,
    <9, 71>, <6, 65>, <6, 45>, <14, 27>, <22, 6>, <17, 0>, <0, 1>, <0, 0>
    texture {MyGlass}
  }

intersection
{
  lathe {
    cubic_spline
    11,
    <9, 71>, <6, 65>, <6, 45>, <14, 27>, <22, 6>, <17, 0>, <0, 1>, <0, 0>, <0, 0>, <0, 71>, <0, 71>
        }
  box{
      <-24, 0, -24>
      < 24, 25, 24>
     }
  texture {Yellow_Liquid}
  scale <0.99, 0.99, 0.99>
 }
} //end Yellow

#declare Tall_Red_Beaker = union {

  lathe {
    cubic_spline
    15,
    <0,0>,<2,0>,<13,4>,<18,18>,<7,35>,<7,90>,<9,92>,<9,93>,<6,90>,<6,35>,<17,18>,<12,5>,<2,1>,<0,1>,<0,0>
    texture {MyGlass}
  }

intersection
{
  lathe {
    cubic_spline
    10,
    <6,90>,<6,35>,<17,18>,<12,5>,<2,1>,<0,1>,<0,0>,<0,0>,<0,90>,<0,90>
        }
  box{
      <-20, 0, -20>
      < 20, 70, 20>
     }
  texture {Red_Liquid}
  scale <0.99, 0.99, 0.99>
}
} //end Tall_Red_Beaker


#declare Petra_Dish = union {
 union {
  cylinder{0*y,  1*y,  35}
  difference {
    torus{35,4 translate 4*y}
    union{
      cylinder{0*y, 10*y, 40}
      cylinder{-5*y, 10*y, 35}
      torus{35,3 }
      translate 4*y
    }
  }
  difference {
    cylinder{4*y,8*y, 39}
    cylinder{3*y,9*y, 38}
  }

  cylinder{8*y, 9*y, 39}
  difference {
    torus{39,1 translate 8*y}
    union{
      cylinder{-2*y, 2*y, 39}
      cylinder{0*y, -2*y, 44}
      translate 8*y
    }
  }
  difference{
    cylinder{5*y, 8*y, 40}
    cylinder{4*y, 9*y, 39}
  }
  texture{MyGlass}
  }
  union {
    torus{35,3 translate 4*y}
    cylinder{1*y, 5*y, 35}
    cylinder{4*y, 5*y, 38}
    texture{GreenGlow}
  }
}// End Petra_dish

union {
  difference {
    box{<-400, 0, 0>< 400, 400, 50>}
    union {
      box{<-360, 20, -1><-220, 190, 51>}
      box{<-180, 20, -1><-20, 190, 51>}
      box{<20, 20, -1><180, 190, 51>}
      box{<220, 20, -1><360, 190, 51>}
      box{<-360, 220, -1><-220, 360, 51>}
      box{<-180, 220, -1><-20, 360, 51>}
      box{<20, 220, -1><180, 360, 51>}
      box{<220, 220, -1><360, 360, 51>}
    }
  pigment {Gray50}
  }
  translate <-400, 0, 1000>
}

union {
  difference {
    box{<-400, 0, 0>< 400, 400, 50>}
    union {
      box{<-360, 20, -1><-220, 190, 51>}
      box{<-180, 20, -1><-20, 190, 51>}
      box{<20, 20, -1><180, 190, 51>}
      box{<220, 20, -1><360, 190, 51>}
      box{<-360, 220, -1><-220, 360, 51>}
      box{<-180, 220, -1><-20, 360, 51>}
      box{<20, 220, -1><180, 360, 51>}
      box{<220, 220, -1><360, 360, 51>}
    }
  pigment {Gray50}
  }
  translate <400, 0, 1000>
}
box{<-1000,0,20><1000,1000, 22>pigment{White} finish {ambient 0.2} translate 1000*z}


object {Purple_Beaker translate <20, 0, 50>}
object {Yellow_Beaker translate <-50, 0, -50> }
object {Tall_Red_Beaker translate <-100, 0, 150> }
object {Purple_Beaker translate <-150, 0, 80> }
object {Yellow_Beaker translate <-70, 0, 30> }
object {Tall_Red_Beaker translate <-45, 0, 140> }
object {Petra_Dish translate <130,0,200>}
object {Petra_Dish translate <125,9,205>}
object {Petra_Dish translate <132,18,210>}
object {Petra_Dish translate <131,27,195>}
object {Petra_Dish translate <133,36,203>}
object {Petra_Dish translate <127,45,208>}
object {Petra_Dish translate <132,54,198>}
object {Petra_Dish translate <134,63,208>}
object {Petra_Dish translate <136,72,204>}
object {Petra_Dish translate <130,81,200>}
object {Petra_Dish translate <130,90,200>}
object {Petra_Dish translate <125,99,205>}
object {Petra_Dish translate <132,108,210>}
object {Petra_Dish translate <131,117,195>}
object {Petra_Dish translate <127,126,208>}
object {Petra_Dish translate <132,135,198>}

object {Petra_Dish translate <130,0,0>}
object {Petra_Dish translate <125,9,5>}
object {Petra_Dish translate <-160,0,300>}
