#declare Use_Font=1      // comment to not use Arial.ttf on EotS

#declare S_Wood =
texture {
      pigment {
              wood
              turbulence 0.1
              color_map {
                         [ 0 0.35 color red 0.7  green 0.4
                                  color red 0.7  green 0.4  ]
                         [ 0.35 1 color red 0.95 green 0.62
                                  color red 0.95 green 0.62 ]
                         }
             scale <0.2 .20 0.2>
             rotate <31 0 0>
             }
             finish { specular 0.6 roughness 0.01 }
}

#declare W_Paper =
texture {
        pigment { crackle
         pigment_map {
                     [ 0.0 Grey ]
                     [ 0.5 White  ]
                     [ 1.0 White*0.5  ]
                     }
         scale < 0.05, 0.05, 0.05 >
         }
}


// Table ---------------------------------------------

#declare Legs = union {
cylinder { < -2.5, 0, 1.5 > < -2.5, 2, 1.5 > 0.1 }
 cylinder { < -2.5, 0, 1.5 > < -2.5, 0.2, 1.5 > 0.12 }
 cylinder { < -2.5, 1.8, 1.5 > < -2.5, 2, 1.5 > 0.12 }
cylinder { < 2.5, 0, 1.5 > < 2.5, 2, 1.5 > 0.1 }
 cylinder { < 2.5, 0, 1.5 > < 2.5, 0.2, 1.5 > 0.12 }
 cylinder { < 2.5, 1.8, 1.5 > < 2.5, 2, 1.5 > 0.12 }
cylinder { < -2.5, 0, -1.5 > < -2.5, 2, -1.5 > 0.1 }
 cylinder { < -2.5, 0, -1.5 > < -2.5, 0.2, -1.5 > 0.12 }
 cylinder { < -2.5, 1.8, -1.5 > < -2.5, 2, -1.5 > 0.12 }
cylinder { < 2.5, 0, -1.5 > < 2.5, 2, -1.5 > 0.1 }
 cylinder { < 2.5, 0, -1.5 > < 2.5, 0.2, -1.5 > 0.12 }
 cylinder { < 2.5, 1.8, -1.5 > < 2.5, 2, -1.5 > 0.12 }
pigment { rgb < 0, 0, 0 > }
finish  { specular 1.0 roughness 0.05 }
}

#declare Cross_Bars = union {
 cylinder { < -2.915, 0, 0 > < 2.915, 0, 0 > 0.05 rotate y*31  translate y*0.6 }
 cylinder { < -2.915, 0, 0 > < 2.915, 0, 0 > 0.05 rotate y*-31 translate y*0.7 }
 cylinder { < -2.915, 0, 0 > < 2.915, 0, 0 > 0.05 rotate y*31  translate y*1.1 }
 cylinder { < -2.915, 0, 0 > < 2.915, 0, 0 > 0.05 rotate y*-31 translate y*1.2 }
 pigment { rgb < 0, 0, 0 > }
 finish { phong 1.0 }
}


#declare Glass_Top =
superellipsoid { < 0.5, 0.1 >
               #ifdef (Quick_Glass)
               texture { pigment { White } }
               #else
               texture {
                       pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
                       finish {
                              ambient 0.1
                              diffuse 0.1
                              reflection .25
                              refraction 1
                              ior 1.5
                              specular 1
                              roughness .001
                              }
                        }
               #end
               translate y*80.51
               scale < 3, 0.025, 2 >
               }

#declare Table = union {
 object { Legs }
 object { Cross_Bars }
 object { Glass_Top }
}




// Eye of the Storm ------------------------------


#declare Main_Box = union {
difference {
box { < -.25,-.25, -.25 > < 0.25, 0.25, 0.25 >
    pigment { White*0.2 }
    finish { phong 0.6 }
    }
    union {
          box { < 0, -0.15, -0.3 > < 0.2, -0.135, -0.2 > }
          box { < 0, -0.2, -0.3 > < 0.2, -0.185, -0.2 > }
          box { < -0.2, -0.2, -0.3 > < -0.15, -0.185, -0.2 > }
          pigment { Clear }
          }
}
difference {
           cylinder { < 0, -.3, 0 > < 0, 0.3, 0 > 0.2 }
           cylinder { < 0, 0, 0 > < 0, 0.31, 0 > 0.18 }
           pigment { White*0.2 }
           finish { phong 0.8 }
           }
}



#declare Switch = difference {
 cylinder  { < 0, 0, 0 > < 0, 0.02, 0 > 0.02 pigment  { White*0.1 } }
 plane { z,0 pigment { Clear } rotate x*180 hollow }
}

#declare Switches = union {
 object { Switch translate < 0.05, -0.15, -0.26 > }
 object { Switch translate < 0.1, -0.2, -0.26 > }
 object { Switch translate < -0.2, -0.2, -0.26 > }
}



#declare Outer_Sphere =
sphere { < 0, 0, 0 > 0.35
       #ifdef (Quick_Glass)
       pigment { rgb < 1, 1, 1 > }
       #else
       pigment { rgbf < 1, 1, 1, 0.9 > }
                   halo {
                        attenuating
                        spherical_mapping
                        linear
                        turbulence 2
                        color_map {
                                  [ 0.0 color rgbt <0, 0, 1,  1> ]
                                  [ 0.2 color rgbt <0, 0, 1,  1> ]
                                  [ 0.5 color rgbt <1, 0, 0, -1> ]
                                  [ 0.8 color rgbt <0, 0, 0,  1> ]
                                  [ 1.0 color rgbt <1, 1, 1,  1> ]
                                  }
                        frequency 2
                        samples 20
                        scale 0.5
                        }
       finish { reflection 0.2 }
       #end
       translate y*0.6
       hollow
       }


// glass around core
#declare Inner_Core =
union {
      merge {
      cylinder { < 0, 0, 0 > < 0, 0.32, 0 > 0.05 translate y*0.25 hollow }
      sphere { < 0, 0, 0 > 0.09 translate y*0.6 hollow }
      pigment { White filter 0.9 }
      finish  { reflection 0.5 }
      }
      merge {
      cylinder { < 0, 0, 0 > < 0, 0.32, 0 > 0.02 translate y*0.25 hollow }
      sphere { < 0, 0, 0 > 0.07 translate y*0.6 hollow }
      pigment { Black }
      }
}


#ifdef (Use_Font)
#declare Text = union {
text { ttf "Arial.ttf" "ON" 0.01 0
     pigment { White }
     scale < 0.015, 0.015, 1 >
     translate < -0.23, -0.2, -0.252 >
     }
text { ttf "Arial.ttf" "AUDIO" 0.01 0
     pigment { White }
     scale < 0.015, 0.015, 1 >
     translate < -0.14, -0.2, -0.252 >
     }
text { ttf "Arial.ttf" "FOCUS" 0.01 0
     pigment { White }
     scale < 0.015, 0.015, 1 >
     translate < -0.06, -0.2, -0.252 >
     }
text { ttf "Arial.ttf" "POWER" 0.01 0
     pigment { White }
     scale < 0.015, 0.015, 1 >
     translate < -0.06, -0.15, -0.252 >
     }
}
#end

#declare Eye_Storm = union {
object { Main_Box }
object { Switches }
object { Inner_Core }
object { Outer_Sphere }
object { Text }
}


#declare Lamp =
union {
      difference {
           sphere { < 0, 0, 0 > 1 scale < 1, 0.5, 1 > translate y* -0.25 }
           plane { y,0 pigment { Clear } }
      }
cylinder { < 0, 0, 0 > < 0, 6, 0 > 0.1 }
cylinder  { < 0, 5.9, 0 > < 0, 6.0, 0 > 1 }
pigment { rgb < 0, 0, 0 > }
finish { specular 0.9 roughness 0.05 metallic }
}


//-------Dart Board
#declare Bristle=normal { ripples 1.0 frequency 20.0 phase 0.0  }



#declare Wires = union {
#declare Rot=9
#while ( Rot < 360 )
 cylinder { < 0, 0.75, 0 > < 0, 6.9, 0 > 0.03 texture { Chrome_Metal } rotate z*Rot }
 cylinder { < 0, 3.85, 0 > < 0, 3.9, 0 > 0.06  texture { Brushed_Aluminum } rotate z*Rot }
 cylinder { < 0, 6.35, 0 > < 0, 6.4, 0 > 0.06  texture { Brushed_Aluminum } rotate z*Rot }
 #declare Rot=Rot+18
#end

torus { 6.75, 0.03 texture { Chrome_Metal } rotate x*90 }
torus { 6.25, 0.03 texture { Chrome_Metal } rotate x*90 }
torus { 4.25, 0.03 texture { Chrome_Metal } rotate x*90 }
torus { 3.75, 0.03 texture { Chrome_Metal } rotate x*90 }
torus { 0.75, 0.03 texture { Chrome_Metal } rotate x*90 }
torus { 0.30, 0.03 texture { Chrome_Metal } rotate x*90 }

cylinder { < -.75, -0.025, 0 > < -.75, 0.025, 0 > 0.06 texture { Brushed_Aluminum } }
cylinder { < .75, -0.025, 0 > < .75, 0.025, 0 > 0.06 texture { Brushed_Aluminum } }
cylinder { < -.3, -0.025, 0 > < -.3, 0.025, 0 > 0.06 texture { Brushed_Aluminum } }
cylinder { < .3, -0.025, 0 > < .3, 0.025, 0 > 0.06 texture { Brushed_Aluminum } }
}


#declare Double =
difference {
           difference {
           cylinder { < 0, 0, 0 > < 0, 0, 2 > 6.75 }
           cylinder { < 0, 0, -0.1 > < 0, 0, 2.1 > 6.25 }
           }
           plane { x,0 rotate z*-9 inverse }
           plane { x,0 rotate z*9  }
           }

#declare Fat_1 =
difference {
           difference {
           cylinder { < 0, 0, 0 > < 0, 0, 2 > 6.25 }
           cylinder { < 0, 0, -0.1 > < 0, 0, 2.1 > 4.25 }
           }
           plane { x,0 rotate z*-9 inverse }
           plane { x,0 rotate z*9  }
           }

#declare Treble =
difference {
           difference {
           cylinder { < 0, 0, 0 > < 0, 0, 2 > 4.25 }
           cylinder { < 0, 0, -0.1 > < 0, 0, 2.1 > 3.75 }
           }
           plane { x,0 rotate z*-9 inverse }
           plane { x,0 rotate z*9  }
           }


#declare Fat_2 =
difference {
           difference {
           cylinder { < 0, 0, 0 > < 0, 0, 2 > 3.75 }
           cylinder { < 0, 0, -0.1 > < 0, 0, 2.1 > 0.75 }
           }
           plane { x,0 rotate z*-9 inverse }
           plane { x,0 rotate z*9  }
           }

#declare Bull =
union {
           difference {
           cylinder { < 0, 0, 0 > < 0, 0, 2 > 0.75 }
           cylinder { < 0, 0, -0.1 > < 0, 0, 2.1 > 0.3 }
           pigment { HuntersGreen } normal { Bristle }
           }
           cylinder { < 0, 0, 0 > < 0, 0, 2 > 0.3 pigment { IndianRed } normal { Bristle } }
}


#declare Red_Pie = union {
object { Double pigment { IndianRed } normal { Bristle } }
object { Fat_1 pigment { White } normal { Bristle } }
object { Treble pigment { IndianRed } normal { Bristle } }
object { Fat_2 pigment { White } normal { Bristle } }
object { Bull }
}

#declare Green_Pie = union {
object { Double pigment { HuntersGreen } normal { Bristle } }
object { Fat_1 pigment { Black } normal { Bristle } }
object { Treble pigment { HuntersGreen } normal { Bristle } }
object { Fat_2 pigment { Black } normal { Bristle } }
object { Bull }
}

#declare Inner_Board = union {
#declare Rot=0
#while ( Rot < 360 )
 object { Red_Pie rotate z*Rot }
 object { Green_Pie rotate z*(Rot+18) }
 #declare Rot=Rot+36
#end

}


#declare Outer_Board = difference {
cylinder { < 0, 0, 0 > < 0, 0, 2 > 9 }
cylinder { < 0, 0, -0.1 > < 0, 0, 2.1 > 6.75 }
pigment { Black } normal { Bristle }
}


// For some strange reason I had to start the count at 1 not 0. ???????
#declare Numbers = union {
#declare Count=1
#declare Rot=0
#while ( Count < 40 )
 text { ttf "timrom.ttf" substr("2005120914110816071903170215100613041801",Count,2) 0.1 0
     translate < -0.6, 7.5, -0.01 >
     rotate z*Rot
     pigment { rgb < 1, 1, 1 > } }
 #declare Count=Count+2
 #declare Rot=Rot+18
#end
}




#declare DBoard = union {
 object { Outer_Board }
 object { Inner_Board }
 object { Wires }
 object { Numbers }
 }





#declare Point = union {
                       cone { < 0.5, 0, 0 > 0.07 < 1, 0, 0 > 0.0 }
                       cylinder { < 0, 0, 0 > < 0.5, 0, 0 > 0.07 }
                       texture { Chrome_Metal }
}

#declare Barrel = union {
cone { < -0.2, 0, 0 > 0.23, < 0, 0, 0 > 0.15 }
cylinder { < -2.05 , 0, 0 > < -0.2, 0, 0 > 0.21 }
cylinder { < -2.00 , 0, 0 > < -1.60, 0, 0 > 0.23  }
cylinder { < -1.55 , 0, 0 > < -1.15, 0, 0 > 0.23 }
cylinder { < -1.10 , 0, 0 > < -0.70, 0, 0 > 0.23 }
cylinder { < -0.65 , 0, 0 > < -0.20, 0, 0 > 0.23 }
cone { < -2.25, 0, 0 > 0.15, < -2.05, 0, 0 > 0.23 }
pigment { rgb < 0.5, 0.5, 0.5 > }
}


#declare Shaft = union {
     union {
           difference {
                      cone { < -2.25, 0, 0 > 0.15, < -2.55, 0, 0 > 0.1 }
                      cylinder { < -2.4, 0, -1 > < -2.4, 0, 1 > 0.08 }
                      }
      cylinder { < -2.55, 0, 0 > < -3.25, 0, 0 > 0.1 pigment { Black } }
      cone { < -3.25, 0, 0 > 0.1, < -3.50, 0, 0 > 0.15 }
      cone { < -3.50, 0, 0 > 0.15, < -3.75, 0, 0 > 0.1 }
      pigment { Black }
      finish { metallic }
      }
     union {
      cylinder { < -2.65, 0, 0 > < -2.60, 0, 0 > 0.101 }
      cylinder { < -2.75, 0, 0 > < -2.70, 0, 0 > 0.101 }
      cylinder { < -2.85, 0, 0 > < -2.80, 0, 0 > 0.101 }
      cylinder { < -2.95, 0, 0 > < -2.90, 0, 0 > 0.101 }
      texture { Chrome_Metal }
      }
}

#declare Flight = intersection {
         box { < -0.75, -0.75, -0.01 > < 0.75, 0.75, 0.01 > }
         sphere { < 0, 0, 0 > 0.75 scale < 1.2,1,1 > translate x*-0.2 }
         pigment { checker pigment { Red*0.8 }, pigment { Black filter 0.7 }
         scale < 0.1, 0.1, 0.1 >}
}


#declare Dart= union {
object { Point }
object { Barrel }
object { Shaft }
object { Flight translate x*-4.2 }
object { Flight translate x*-4.2 rotate x*90}
}


