
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Magnifying Glass
// Date: 02/07/97
// Auth: Benny Wilkie     wilkie@intplsrv.net    AstroKnott@aol.com




#version 3

#include "colors.inc"

#include "metals.inc"


global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <-.6, 0.0, -3.3>
   look_at   <-.3, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

//borrowed from glass.inc...needed to change the incidence or refraction for the lens
// Glass Finishes
#declare F_Glass1 =
finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    refraction 1
    reflection 0.1
    ior 6                ///was 1.5///bigger numbers make higher magnification
}

// Simple clear glass
#declare T_Glass1 =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.7> }
    finish  { F_Glass1 }
}

#declare Bible=

cylinder
{
  y*-1 , y*1, 1
  scale <2, 2, .2>
  texture
  {
    pigment
    {
      image_map
      {
        gif "bible1.gif"
        interpolate 2 // smooth it
        once   // don't tile image, just one copy

      }
      // transform it to unit-size (-1 to +1)
      translate -0.5*(x+y) // center on the origin
      scale 4              // make it unit-sized
    }
    finish {ambient 0.3}
    normal  {crackle 3 turbulence 0.5}
  }

}

////////////////////////magnifying Glass///////////////////////
#declare Mag_Glass=

union{
//////////////////////////lens/////////////////////////
sphere
{
  <0, 0, 0>
  1
clipped_by{
cylinder {1*z, -1*z, .5}

}
 scale <1, 1, .05>
 texture {T_Glass1}

 }
//////////////////////ring around lens/////////////////////////////////////

difference{
cylinder
{
  -.15*z,  .15*z,  .52

}
cylinder
{
  -.16*z,  .16*z,  .5

}

texture {T_Copper_3A}

}//end diff for cylinder

///////////////////////////upper handle////////////////////////////
#declare Upper_Handle=
merge{
cylinder
{
  -.02*x,  .02*x,  .15
translate x*.54
texture {T_Copper_3A}
}

torus
{ .10,  0.051
rotate z*90
translate x*.61
texture {T_Copper_3A}
}
////////////////////////////////////////////////////////
difference{
cylinder
{
  0*x,  .2*x,  .15
translate x*.67
texture {T_Copper_3A}
}

torus
{ .2, .1
rotate z*90
translate x*.78
texture {T_Copper_3A}
}

}//end diff

}//end merge for upper handle


///////////////////////////////Handle/////////////////////////////////

#declare Half_Handle=
union{

#declare Grip_Pattern=
union{


#declare Trnsl = 0
#while ( Trnsl< 4)



sphere
{  <0, .5, 0>   0.1

  translate x*Trnsl

}

#declare Trnsl = Trnsl+.2

#end

}//end union Grip_Pattern

//////////////////////////////////////////////////////////////////

#declare Diamond = 0
#while ( Diamond< 360)


object {Grip_Pattern

   rotate  x*Diamond

}

#declare Diamond = Diamond+20
#end

}//end union Half_Handle

////////////////////////////////////////////////////////////////////

#declare Handle=

union{
object {Half_Handle}

object {Half_Handle
translate x*.1
rotate x*10
}

sphere { <0, 0, 0> .5
translate x*8
scale <.5, 1, 1>

}



}//end union handle

////////////////////////////put handle togeather/////////////////////////////////////

object {Upper_Handle
scale <1, .8, .8>
}

object {Handle
scale <.2, .2, .2>
translate x*.9
texture {T_Copper_3A}
}

}//end union complete object "Mag_Glass"


object {Mag_Glass
rotate z*-40
translate y*.2
translate z*-1.6
translate x*-.9
}
object {Bible
 translate y*-.1
  translate x*.1
}
object {Bible
 translate y*-.1
  translate x*-3.85
}





