// soda worship

//#declare TESTING = 1

#version 3.0
global_settings { assumed_gamma 2.2 }
global_settings { ambient_light color rgb <0.2,0.2,0.2> }
#ifndef (TESTING)
  global_settings { max_trace_level 14 }
#else
  global_settings { max_trace_level 8 }
#end

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

/* Texture declarations for object 'water_glass' */
#declare water_glass_texture = texture {
  pigment { rgbft < 0.9, 0.9, 0.95, 0.9, 0.1 > }
  finish {
    #ifndef (TESTING)
      reflection .1
      refraction 1
      ior 1.5
      specular 1
      roughness .001
    #else
      reflection 0
      refraction 0
    #end
    ambient 0
  }
}

/* Texture declarations for object 'water' */
#declare water_texture = texture {
  pigment { rgbft < 0.9, 0.9, 0.95, 0.9, 0.1 > }
  finish {
    #ifndef (TESTING)
      reflection .1
      refraction 1
      ior 1.33
      specular 1
      roughness .001
    #else
      reflection 0
      refraction 0
    #end
    ambient 0
  }
}

/* Texture declarations for object 'ice' */
#declare ice_texture = texture {
  pigment { rgbft < 0.9, 0.9, 0.95, 0.9, 0.1 > }
  finish {
    #ifndef (TESTING)
      reflection .1
      refraction 1
      ior 1.2
      specular 1
      roughness .001
    #else
      reflection 0
      refraction 0
    #end
    ambient 0
  }
}

#declare water = object {
  difference {
    merge {
      torus { 2.5,0.1 translate y*0.6 }
      torus { 3,0.2 translate y*1.2 }
      cylinder { <0,0.6,0>,<0,1.3,0>,3 }
      cylinder { <0,0.5,0>,<0,0.7,0>,2.5 }
      cylinder { <0,1.2,0>,<0,11,0>,3.2 }
    }
    torus { 3,.4 translate y*0.6 }
  }
}

#declare water_glass = object {
  merge {
    difference {
      merge {
        torus { 2.7,0.1 translate y*.1 }
        cylinder { <0,0,0>, <0,0.2,0>,2.7 }
        cylinder { <0,0.1,0>,<0,0.7,0>,2.8 }
        cylinder { <0,0.6,0>,<0,1,0>,3 }
        torus { 3,0.4 translate y*1.2 }
        cylinder { <0,1.2,0>,<0,12,0>,3.4 }
      }
      object { water }
      cylinder { <0,10,0>,<0,13,0>,3.2 }
      torus { 3,0.2 translate y*0.6 }
    }
    torus { 3.3,0.15 translate y*12 }
  }
}

#declare ice_cube = object {
  superellipsoid { <0.2, 0.2> }
  scale <1,1,1.5>
}

#declare ice_cubes = union {
  object {
    ice_cube
//    rotate <17,108,-8>
    rotate x*17 rotate z*-8 rotate y*108
    translate <0.2,10.6,1.3>
  }
  object {
    ice_cube
//    rotate <80,-1,7>
    rotate x*80 rotate z*7 rotate y*-1
    translate <1.1,8.0,-0.6>
  }
  object {
    ice_cube
//    rotate <73,2,-12>
    rotate x*73 rotate z*-12 rotate y*2
    translate <-1.4,8.0,-0.3>
  }
  object {
    ice_cube
//    rotate <-22,91,1>
    rotate x*-22 rotate z*1 rotate y*91
    translate <-0.1,5.8,1.0>
  }
  texture { ice_texture }
}


#declare soda = object {
  object { water }
  scale <1.001,1,1.001>
  translate y*(-0.001)
}
/*
#declare soda = object {
  difference {
    object { water }
    #include "bubbles.inc"
  }
  scale <1.001,1,1.001>
  translate y*(-0.001)
}
*/

#declare spot_body = cylinder { <0,0,-1>, <0,0.1,-1>, 1 pigment { color Red } }

#declare spot_leg = object {
  union {
    sphere { <0,0.05,-1.866>,0.05 }
    cylinder { <0,0.05,-1.866>, <0,-0.45,-1>, 0.05 }
    sphere { <0,-0.45,-1>, 0.05 }
    cylinder { <0,-0.45,-1>, <0,-0.65,-2>, 0.05 }
    intersection {
      sphere { <0,0,0>,0.1 scale <3,3,4.5> }
      box { <-.5,0,-.5>, <.5,.5,.5> }
      pigment { color White }
      rotate x*90
      translate <0,-0.75,-2.05>
    }
    pigment { color Black  }
  }
}

#declare spot_arm = object {
  union {
    sphere { <0,0.05,-0.134>,0.05 }
    cylinder { <0,0.05,-0.134>, <0,0.7,1>, 0.05 }
    sphere { <0,0.7,1>, 0.2 pigment { color White } }
    pigment { color Black }
  }
}

#declare spot = object {
  union {
    object { spot_body }
    object { spot_leg translate x*-0.5 }
    object { spot_leg translate x*0.5 }
    object { spot_arm translate x*-0.5 }
    object { spot_arm translate x*0.5 }
  }
  rotate x*30
//  finish { Shiny }
}

object { spot translate z*-8 rotate y*-180 }
object { spot translate z*-8 rotate y*-150 }
object { spot translate z*-8 rotate y*-120 }
object { spot translate z*-8 rotate y*-90 }
object { spot translate z*-8 rotate y*-60 }
object { spot translate z*-8 rotate y*-30 }
object { spot translate z*-8 rotate y*0 }
object { spot translate z*-8 rotate y*30 }
object { spot translate z*-8 rotate y*60 }
object { spot translate z*-8 rotate y*90 }
object { spot translate z*-8 rotate y*120 }
object { spot translate z*-8 rotate y*150 }

object { spot translate z*-10 rotate y*-165 }
object { spot translate z*-10 rotate y*-135 }
object { spot translate z*-10 rotate y*-105 }
object { spot translate z*-10 rotate y*-75 }
object { spot translate z*-10 rotate y*-45 }
object { spot translate z*-10 rotate y*-15 }
object { spot translate z*-10 rotate y*15 }
object { spot translate z*-10 rotate y*45 }
object { spot translate z*-10 rotate y*75 }
object { spot translate z*-10 rotate y*105 }
object { spot translate z*-10 rotate y*135 }
object { spot translate z*-10 rotate y*165 }

#ifndef (TESTING)
  object { ice_cubes }
  object { soda texture { water_texture } }
#end

object { water_glass texture { water_glass_texture } }

#declare empty_glass =object {
  water_glass
  scale <1,-1,1>
  translate <0,12,0>
  texture { water_glass_texture }
}

object { empty_glass translate <21,0,16.5> }
object { empty_glass translate <14,0,16.5> }
object { empty_glass translate <-14,0,16.5> }
object { empty_glass translate <-21,0,16.5> }
object { empty_glass translate <-28,0,16.5> }
//object { empty_glass translate <-35,0,16.5> }

cylinder { <-2.3,1.5,-0.5>, <4,15,1>, .3 pigment { White } finish { ambient .5 } }  // straw

#declare tile=object {
  superellipsoid { <0.1, 0.1> }
  pigment {
//    color White
    image_map {
      gif "flowers.gif"
    }
    scale 2.1
    translate <-1,-1,0>
  }
  finish { Shiny }
  scale <5.8,5.8,1>
  translate y*6
}

#declare tile_wall = union {
  #declare a=-3
  #while (a <= 2)
    #declare b=0
    #while (b <= 1)
      object{ tile translate <a*12,b*12,0> }
      #declare b=b+1
    #end
    #declare a=a+1
  #end
}

object { tile_wall translate z*21 }

#declare grout_texture = texture {
  pigment {
    bozo
    color_map {
      [0 color Gray75]
      [0.5 color White]
      [1 color White]
    }
    scale 2.3
  }
}

box { <-42,-1,20.3>, <30,24,22> texture { grout_texture } }

#declare small_tile=object {
  superellipsoid { <0.2, 0.2> }
  pigment { color White }
  finish { Shiny }
  scale 0.9
  translate y*-1
}

#declare small_tile_surface = union {
  #declare a=-16
  #while (a <= 16)
    #declare b=-10
    #while (b <= 10)
      object{ small_tile translate <a*2,0,b*2> }
      #declare b=b+1
    #end
    #declare a=a+1
  #end
}

object { small_tile_surface }
box { <-42,-0.2,22>, <30,-1,-20> texture { grout_texture } }

object { plane { y, -1 } texture { pigment { White } } }
object { plane { -z, -22 } texture { pigment { White } } }



//sphere { <-10,5,20>,5 pigment { rgb <1,1,0> } }
//sphere { <0,5,20>,5 pigment { rgb <1,0,1> } }
//sphere { <10,5,20>,5 pigment { rgb <0,1,1> } }

//object { plane { y, 0 } texture { pigment { Green } } }

camera {
   location <6, 20, -35>
   right x*1.333
   up y
   direction z
   angle 46
   look_at <0, 4, 0>
}

light_source { <0, 100, 0> color Gray85 }
light_source { <90, 30, -20> color Gray80 }
light_source { <-15, 200, -300> color Gray75 }

sky_sphere { pigment { rgb <0.5, 0.5, 0.75> } }
