/*
James Schmitz
spcprk.pov
2/23/97
*/

#include "colors.inc"


global_settings { assumed_gamma 1.0 }

camera{
   location < -42.0, 2.1, 18.0 >
   look_at < -29.5, 1.5, 33.0 >
   angle 18
  }

light_source{ <1000,1000,-1000> White }

// asteroid

height_field {
    tga "scene.tga"
  // smooth
    pigment { rgb < 0.7, 0.5, 0.5 > }
    translate <-.5, -.5, -.5>
    scale <90, 4.0, 90>
    translate < 0.0, 0.0, 40.0 >
    finish { ambient 0.2 }
  }

// pyramid

#declare col_1  = color rgb <0.39, 0.41, 0.43>
#declare col_2  = color rgb <0.65, 0.35, 0.15>

#include "pyramid.inc"

object { Lsystem
         scale < 0.01, 0.01, 0.01 >
         rotate -60*y
         translate < -30.0, 4.28, 33.0 >
         finish { ambient 0.1 }
         }

// base of pyramid

prism {
         linear_sweep
         linear_spline
         0,
         0.5,
         4,
         < 1, 0 >,
         < 0,  1.732050807569 >,
         < -1, 0 >,
         < 1, 0 >
         pigment { rgb < 0.65, 0.5, 0.5 > }
         rotate 30.0*y
         scale < 3.15, 1.8, 3.15 >
         translate < -30.9, -1.5, 31.425 >
         finish { ambient 0.2 }
         }

// form blue glass

#declare pyramid = union {
        triangle {
                 < -33.45, -0.6, 33.00 >, < -28.31, -0.6, 30.0 >, < -30.0, 4.28, 33.0 >
                 }
        triangle {
                 < -28.27, -0.6, 35.98 >, < -28.31, -0.6, 30.0 >, < -30.0, 4.28, 33.0 >
                 }
        triangle {
                 < -28.27, -0.6, 35.98 >, < -33.45, -0.6, 33.00 >, < -30.0, 4.28, 33.0 >
                 }
        }

// blue glass

object { pyramid
       pigment { rgbf < 0.7, 0.7, 1.0, 1.0 > }
       finish { reflection 0.35 }
       }

// stars

sky_sphere {
            pigment {
                    granite
                    color_map {
                    [ 0.0 0.09 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.0, 0.0, 0.0 > ]
                    [ 0.09 0.1 color rgb < 0.5, 0.5, 0.5 > color rgb < 0.5, 0.5, 0.5 > ]
                    [ 0.1 0.225 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.0, 0.0, 0.0 > ]
                    [ 0.225 0.235 color rgb < 0.5, 0.45, 0.45 > color rgb < 0.45, 0.45, 0.45 > ]
                    [ 0.235 0.455 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.0, 0.0, 0.0 > ]
                    [ 0.455 0.465 color rgb < 0.4, 0.45, 0.4 > color rgb < 0.4, 0.4, 0.4 > ]
                    [ 0.465 0.655 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.0, 0.0, 0.0 > ]
                    [ 0.655 0.665 color rgb < 0.5, 0.5, 0.55 > color rgb < 0.5, 0.5, 0.5 > ]
                    [ 0.665 0.875 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.1, 0.1, 0.1 > ]
                    [ 0.875 0.885 color rgb < 0.5, 0.5, 0.5 > color rgb < 0.5, 0.5, 0.5 > ]
                    [ 0.885 1.0 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.0, 0.0, 0.0 > ]
                             }
                    turbulence 10
                    scale 0.4
                    }
            }

// planet

sphere {
       < 30.0, 6.0, 130.0 >, 1.0
       texture {
               pigment {
                       wood
                       color_map {
                       [ 0.0 0.25 color rgb < 0.2, 0.5, 0.5 > color rgb < 0.4, 0.5, 0.5 > ]
                       [ 0.25 0.6 color rgb < 0.4, 0.5, 0.5 > color rgb < 0.8, 0.1, 0.1 > ]
                       [ 0.6 1.0 color rgb < 0.8, 0.1, 0.1 > color rgb < 0.6, 0.2, 0.2 > ]
                                 }
                       frequency 0.8
                       turbulence 0.2
                       }
               }
       texture {
               pigment {
                       agate
                       color_map {
                       [ 0.0 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
                       [ 0.5 color rgb < 0.3, 0.3, 0.3 > ]
                       [ 0.66 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
                                   }
                       }
               }
       finish { ambient 0.3 }
       }

// ufo declaration

#declare ufo = sor {
        5,
        < 0.0, 0.0 >
        < 0.5, 0.2 >
        < 0.8, 0.4 >
        < 0.5, 0.6 >
        < 0.0, 0.8 >
        }

// ufo

object {
       ufo
       texture {
               pigment { color rgb < 0.94, 0.93, 0.89 > }
               finish { metallic phong 0.5 ambient 0.2 }
               }
       rotate 8*x
       rotate 5*z
       translate < 30.0, 2, 85.0 >
       finish { ambient 0.3 }
       }

// comet container

#declare comet_container =
         cone {
              < 0.0, -0.5, 0.0 >, 0.5, < 0.0, 7.0, 0.0 >, 0.0 hollow
              }

// comet

object {
     comet_container
     pigment { color rgbf < 1, 1, 1, 1 > }
     halo {
          emitting
          spherical_mapping
          linear
         // poly exponent 0.1
          //samples 30
          color_map {
         // [0 0.2 color rgbt<1, 1, 1, 0.4> color rgbt<1,1,1,0.0> ]
          [0.0 0.86 color rgbt<1,1,1, 0.1> color rgbt<1,1,1,-0.3> ]
          [0.86 1 color rgbt<1, 1, 1, -0.5> color rgbt<1,1,1,-0.5>]
                    }
           }
      rotate -100*x
      scale < 6,6,6 >
      translate < 930.0, 78, 1080>
     }

// bush ( first one )

#declare col_2  = colour red 0.3 blue 0.6 green 0.8
#declare col_3  = colour red 0.9 green 1.0 blue 0.1
#declare col_4  = colour red 0.1 blue 0.1 green 0.9
#declare col_5  = colour red 0.2 blue 0.9 green 1.0

#include "bush.inc"

object { Lsystem
       scale <0.0006, 0.0006, 0.0006 >
       rotate 3*y
       translate < -29.5, -0.6, 34.6 >
       finish { ambient 0.3 }
       }

object { Lsystem
       scale <0.00061, 0.00061, 0.00061 >
       rotate 62*y
       translate < -28.9, -0.6, 34.4 >
       finish { ambient 0.3 }
       }

// swing

#declare col_2  = color rgb <0.39, 0.41, 0.43>
#declare col_5  = colour red 0.5 blue 0.5 green 0.5
#declare col_7  = colour red 0.7 blue 0.3 green 0.6

#include "swing.inc"

object { Lsystem
       scale < 0.002, 0.002, 0.002 >
       translate < -30.0, -0.6, 34.0 >
       finish { ambient 0.3 }
       }

// bush 2

#declare col_2  = colour red 0.9 blue 0.3 green 0.1
#declare col_4  = colour red 0.2 blue 0.4 green 0.85
#include "bush2.inc"

object { Lsystem
       scale < 0.002, 0.002, 0.002 >
       translate < -29.1, -0.6, 31.7 >
       finish { ambient 0.3 }
       }

// my tree

#declare col_2  = colour red 0.8 blue 0.3 green 0.3
#declare col_4  = colour red 0.2 blue 0.2 green 0.8
#include "mytree.inc"

object { Lsystem
       scale < 0.003, 0.003, 0.003 >
       translate < -31.35, -0.6, 33.0 >
       finish { ambient 0.3 }
       }

// bench

#declare col_3  = colour red 0.6 blue 0.2 green 0.3
#declare col_8  = colour red 0.4 green 0.4 blue 0.4
#include "bench.inc"

object { Lsystem
       scale < 0.004, 0.004, 0.004 >
       rotate -60*y
       translate < -30.2, -0.6, 31.8 >
       finish { ambient 0.3 }
       }

// grass

triangle {
         < -28.31, -0.599, 30.0 >, < -33.45, -0.6, 33.0 >, < -28.27, -0.6, 35.98 >
         pigment { color rgb < 0.2, 0.8, 0.3 > }
         finish { ambient 0.2 crand 0.1 }
         }

