// Valentine '97 -- By Roy Mitchell Harper

// This should have come with a few other files. Notably, VAL97.INC and
//   TWISTS.POV are required for the render. To play with the MORAY
//   models, you should also have VAL97A.MDL and HEARTGEM.MDL as well
//   (I called the MORAY model VAL97A.MDL so MORAY wouldn't accidently
//   overwrite the modified VAL97.POV and VAL97.INC files).

// All of the objects in this render can be found in the .MDL files, so
//   as to make it easier for MORAY users to play with the crystals and
//   such.

// The "magic" of this particular image can be found in the TWISTS.POV
//   file. I tried to add sufficient comments into the file to allow
//   those with limited 3D graphics experience to understand (at least
//   partly) how I created this image.

// Also, this file is designed to be animated. Just add "+KFF12 +KC"
//   to the render options to produce a nice cyclical animation. I
//   recommend 12 frames or more for the animation.

// Enjoy!


#include "twists.pov"


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
}

background { color <0.048,0.133,0.238> }

camera {  //  Camera StdCam
  location  <5.200, -19.250, 0.000>
  direction <0.0,     0.0,  1.0893>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-4.224, -5.541, 2.014>
}

// *******  L I G H T S *******
light_source {   // Light2
  <25.000, -12.000, 15.000>
  color rgb <0.307, 0.307, 0.307>
}

light_source {   // Light1
  <15.000, -25.000, 15.000>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "val97.inc"



// ********  REFERENCED OBJECTS  *******

#declare CSG005 = union {
  plane { // Plane007
    z,0
    rotate -65.0*x
    translate  2.0*y
  }
}
#declare CSG008 = union {
  plane { // Plane008
    z,0
    rotate -75.0*x
    translate  <0.0, 1.0674, 2.0>
  }
}
#declare CSG010 = union {
  plane { // Plane009
    z,0
    rotate -85.0*x
    translate  <0.0, 0.5315, 4.0>
  }
}
#declare CSG012 = union {
  plane { // Plane010
    z,0
    rotate -95.0*x
    translate  <0.0, 0.3565, 6.0>
  }
}
#declare CSG014 = union {
  plane { // Plane16
    z,0
    rotate -105.0*x
    translate  <0.0, 0.5315, 8.0>
  }
}
#declare CSG007 = intersection {
  object { CSG005 }
  object { // CSG33->CSG005
    CSG005
    rotate -30.0*z
  }
  object { // CSG34->CSG005
    CSG005
    rotate -60.0*z
  }
  object { // CSG35->CSG005
    CSG005
    rotate -90.0*z
  }
  object { // CSG36->CSG005
    CSG005
    rotate -120.0*z
  }
  object { // CSG37->CSG005
    CSG005
    rotate -150.0*z
  }
  object { // CSG43->CSG005
    CSG005
    rotate 180.0*z
  }
  object { // CSG44->CSG005
    CSG005
    rotate 150.0*z
  }
  object { // CSG45->CSG005
    CSG005
    rotate 120.0*z
  }
  object { // CSG46->CSG005
    CSG005
    rotate 90.0*z
  }
  object { // CSG47->CSG005
    CSG005
    rotate 60.0*z
  }
  object { // CSG54->CSG005
    CSG005
    rotate 30.0*z
  }
}
#declare CSG009 = intersection {
  object { CSG008 }
  object { // CSG55->CSG008
    CSG008
    rotate -30.0*z
  }
  object { // CSG56->CSG008
    CSG008
    rotate -60.0*z
  }
  object { // CSG57->CSG008
    CSG008
    rotate -90.0*z
  }
  object { // CSG58->CSG008
    CSG008
    rotate -120.0*z
  }
  object { // CSG59->CSG008
    CSG008
    rotate -150.0*z
  }
  object { // CSG60->CSG008
    CSG008
    rotate 180.0*z
  }
  object { // CSG61->CSG008
    CSG008
    rotate 150.0*z
  }
  object { // CSG62->CSG008
    CSG008
    rotate 120.0*z
  }
  object { // CSG63->CSG008
    CSG008
    rotate 90.0*z
  }
  object { // CSG64->CSG008
    CSG008
    rotate 60.0*z
  }
  object { // CSG65->CSG008
    CSG008
    rotate 30.0*z
  }
  rotate -15.0*z
}
#declare CSG011 = intersection {
  object { CSG010 }
  object { // CSG66->CSG010
    CSG010
    rotate -30.0*z
  }
  object { // CSG67->CSG010
    CSG010
    rotate -60.0*z
  }
  object { // CSG68->CSG010
    CSG010
    rotate -90.0*z
  }
  object { // CSG77->CSG010
    CSG010
    rotate -120.0*z
  }
  object { // CSG78->CSG010
    CSG010
    rotate -150.0*z
  }
  object { // CSG79->CSG010
    CSG010
    rotate 180.0*z
  }
  object { // CSG80->CSG010
    CSG010
    rotate 150.0*z
  }
  object { // CSG81->CSG010
    CSG010
    rotate 120.0*z
  }
  object { // CSG82->CSG010
    CSG010
    rotate 90.0*z
  }
  object { // CSG83->CSG010
    CSG010
    rotate 60.0*z
  }
  object { // CSG84->CSG010
    CSG010
    rotate 30.0*z
  }
}
#declare CSG013 = intersection {
  object { CSG012 }
  object { // CSG85->CSG012
    CSG012
    rotate -30.0*z
  }
  object { // CSG86->CSG012
    CSG012
    rotate -60.0*z
  }
  object { // CSG87->CSG012
    CSG012
    rotate -90.0*z
  }
  object { // CSG88->CSG012
    CSG012
    rotate -120.0*z
  }
  object { // CSG89->CSG012
    CSG012
    rotate -150.0*z
  }
  object { // CSG90->CSG012
    CSG012
    rotate 180.0*z
  }
  object { // CSG91->CSG012
    CSG012
    rotate 150.0*z
  }
  object { // CSG92->CSG012
    CSG012
    rotate 120.0*z
  }
  object { // CSG93->CSG012
    CSG012
    rotate 90.0*z
  }
  object { // CSG94->CSG012
    CSG012
    rotate 60.0*z
  }
  object { // CSG95->CSG012
    CSG012
    rotate 30.0*z
  }
  rotate -15.0*z
}
#declare CSG015 = intersection {
  object { CSG014 }
  object { // CSG96->CSG014
    CSG014
    rotate -30.0*z
  }
  object { // CSG97->CSG014
    CSG014
    rotate -60.0*z
  }
  object { // CSG98->CSG014
    CSG014
    rotate -90.0*z
  }
  object { // CSG99->CSG014
    CSG014
    rotate -120.0*z
  }
  object { // CSG100->CSG014
    CSG014
    rotate -150.0*z
  }
  object { // CSG101->CSG014
    CSG014
    rotate 180.0*z
  }
  object { // CSG102->CSG014
    CSG014
    rotate 150.0*z
  }
  object { // CSG103->CSG014
    CSG014
    rotate 120.0*z
  }
  object { // CSG104->CSG014
    CSG014
    rotate 90.0*z
  }
  object { // CSG105->CSG014
    CSG014
    rotate 60.0*z
  }
  object { // CSG106->CSG014
    CSG014
    rotate 30.0*z
  }
}
#declare TowerCenter = merge {
  object { CSG007 }
  object { CSG009 }
  object { CSG011 }
  object { CSG013 }
  object { CSG015 }
}
#declare Tower = difference {
  object { TowerCenter }
  plane { // Plane012
    z,0
    texture {
      TowerEndTexture
    }
    no_shadow
    rotate -180.0*x
    translate  10.0*z
  }
  plane { // Plane011
    z,0
    no_shadow
  }
  texture {
    TowerTexture
  }
  bounded_by { // Bound00003
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <3.0, 3.0, 5.0>
      translate  5.0*z
    }
  }
  scale <1.0, 1.0, 1.15>
  translate  <0.0, 2.0, -2.999>
}
#declare CSG001 = merge {
  object { Tower }
  no_shadow
}
#declare OddFace1 = intersection {
  plane { // Plane17
    z,0
    scale <1.0, 0.2, 0.1>
    rotate -220.0*y
    translate  0.75*x
  }
  plane { // Plane18
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -310.0*y
    translate  <1.210344, 0.0, 0.849>
  }
}
#declare EvenFace1 = intersection {
  plane { // Plane37
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -290.0*y
    translate  <1.334647, 0.0, 0.673893>
  }
  plane { // Plane38
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -335.0*y
    translate  <1.021438, 0.0, 0.967213>
  }
}




// ********  OBJECTS  *******



#declare FloorCSG = difference {
  plane { // FloorPlane
    z,0
    translate  5.0*z
  }
  torus { // Torus001
    16.0, 5.0  rotate -x*90
    sturm
    translate  2.0*z
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <16.0, 16.0, 11.0>
    translate  -3.0*z
  }
  texture {
    FloorTexture
  }
  no_shadow
}
#declare FloorLaquerCSG1 = difference {
  plane { // FloorPlane1
    z,0
    translate  5.0*z
  }
  torus { // Torus2
    16.0, 5.0  rotate -x*90
    sturm
    translate  2.0*z
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <16.0, 16.0, 11.0>
    translate  -3.0*z
  }
  texture {
    FloorLaquerTexture
  }
  scale 0.999
}
union { // Floor
  object { FloorCSG }
  object { FloorLaquerCSG1 }
}


#declare OddFaces = intersection {
  object { OddFace1 }
  object { // OddFace2->OddFace1
    OddFace1
    rotate -36.0*z
  }
  object { // OddFace3->OddFace1
    OddFace1
    rotate -72.0*z
  }
  object { // OddFace4->OddFace1
    OddFace1
    rotate -108.0*z
  }
  object { // OddFace5->OddFace1
    OddFace1
    rotate -144.0*z
  }
  object { // OddFace6->OddFace1
    OddFace1
    rotate 180.0*z
  }
  object { // OddFace7->OddFace1
    OddFace1
    rotate 144.0*z
  }
  object { // OddFace8->OddFace1
    OddFace1
    rotate 108.0*z
  }
  object { // OddFace9->OddFace1
    OddFace1
    rotate 72.0*z
  }
  object { // OddFace10->OddFace1
    OddFace1
    rotate 36.0*z
  }
  rotate -18.0*z
}
#declare EvenFaces = intersection {
  object { EvenFace1 }
  object { // EvenFace2->EvenFace1
    EvenFace1
    rotate -36.0*z
  }
  object { // EvenFace3->EvenFace1
    EvenFace1
    rotate -72.0*z
  }
  object { // EvenFace4->EvenFace1
    EvenFace1
    rotate -108.0*z
  }
  object { // EvenFace5->EvenFace1
    EvenFace1
    rotate -144.0*z
  }
  object { // EvenFace6->EvenFace1
    EvenFace1
    rotate 180.0*z
  }
  object { // EvenFace7->EvenFace1
    EvenFace1
    rotate 144.0*z
  }
  object { // EvenFace8->EvenFace1
    EvenFace1
    rotate 108.0*z
  }
  object { // EvenFace9->EvenFace1
    EvenFace1
    rotate 72.0*z
  }
  object { // EvenFace10->EvenFace1
    EvenFace1
    rotate 36.0*z
  }
}
#declare Diamond1 = intersection {
  plane { // Plane41
    z,0
    scale <1.0, 1.0, 0.1>
    rotate -0.1*z
    translate  1.005045*z
  }
  object { OddFaces }
  object { EvenFaces }
  texture {
    Diamond1Texture
  }
  bounded_by { // Bound2
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.555562, 1.567959, 0.925831>
      translate  <0.0, 0.0, 0.231129>
    }
  }
  rotate <0, 0, -clock * (360 / 10)>
  scale 1.5
  translate  <0.0, 2.0, 9.5>
}
#declare CSG002 = union {
  object { Diamond1 }
}
#declare OddFace11 = intersection {
  plane { // Plane19
    z,0
    scale <1.0, 0.2, 0.1>
    rotate -220.0*y
    translate  0.75*x
  }
  plane { // Plane20
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -310.0*y
    translate  <1.210344, 0.0, 0.849>
  }
}
#declare OddFaces1 = intersection {
  object { OddFace11 }
  object { // OddFace12->OddFace1
    OddFace1
    rotate -36.0*z
  }
  object { // OddFace13->OddFace1
    OddFace1
    rotate -72.0*z
  }
  object { // OddFace14->OddFace1
    OddFace1
    rotate -108.0*z
  }
  object { // OddFace15->OddFace1
    OddFace1
    rotate -144.0*z
  }
  object { // OddFace16->OddFace1
    OddFace1
    rotate 180.0*z
  }
  object { // OddFace17->OddFace1
    OddFace1
    rotate 144.0*z
  }
  object { // OddFace18->OddFace1
    OddFace1
    rotate 108.0*z
  }
  object { // OddFace19->OddFace1
    OddFace1
    rotate 72.0*z
  }
  object { // OddFace20->OddFace1
    OddFace1
    rotate 36.0*z
  }
  rotate -18.0*z
}
#declare EvenFace11 = intersection {
  plane { // Plane39
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -290.0*y
    translate  <1.334647, 0.0, 0.673893>
  }
  plane { // Plane40
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -335.0*y
    translate  <1.021438, 0.0, 0.967213>
  }
}
#declare EvenFaces1 = intersection {
  object { EvenFace11 }
  object { // EvenFace12->EvenFace1
    EvenFace1
    rotate -36.0*z
  }
  object { // EvenFace13->EvenFace1
    EvenFace1
    rotate -72.0*z
  }
  object { // EvenFace14->EvenFace1
    EvenFace1
    rotate -108.0*z
  }
  object { // EvenFace15->EvenFace1
    EvenFace1
    rotate -144.0*z
  }
  object { // EvenFace16->EvenFace1
    EvenFace1
    rotate 180.0*z
  }
  object { // EvenFace17->EvenFace1
    EvenFace1
    rotate 144.0*z
  }
  object { // EvenFace18->EvenFace1
    EvenFace1
    rotate 108.0*z
  }
  object { // EvenFace19->EvenFace1
    EvenFace1
    rotate 72.0*z
  }
  object { // EvenFace20->EvenFace1
    EvenFace1
    rotate 36.0*z
  }
}
#declare Diamond2 = intersection {
  plane { // Plane42
    z,0
    scale <1.0, 1.0, 0.1>
    rotate -0.1*z
    translate  1.005045*z
  }
  object { OddFaces1 }
  object { EvenFaces1 }
  texture {
    Diamond2Texture
  }
  bounded_by { // Bound3
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.555562, 1.567959, 0.925831>
      translate  <0.0, 0.0, 0.231129>
    }
  }
  rotate <0, 0, -clock * (360 / 10)>
  scale 1.5
  translate  <0.0, 2.0, 11.1>
}
#declare CSG4 = union {
  object { Diamond2 }
  rotate -120.0*z
  translate  -4.5*z
}
#declare OddFace21 = intersection {
  plane { // Plane21
    z,0
    scale <1.0, 0.2, 0.1>
    rotate -220.0*y
    translate  0.75*x
  }
  plane { // Plane22
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -310.0*y
    translate  <1.210344, 0.0, 0.849>
  }
}
#declare OddFaces2 = intersection {
  object { OddFace21 }
  object { // OddFace22->OddFace1
    OddFace1
    rotate -36.0*z
  }
  object { // OddFace23->OddFace1
    OddFace1
    rotate -72.0*z
  }
  object { // OddFace24->OddFace1
    OddFace1
    rotate -108.0*z
  }
  object { // OddFace25->OddFace1
    OddFace1
    rotate -144.0*z
  }
  object { // OddFace26->OddFace1
    OddFace1
    rotate 180.0*z
  }
  object { // OddFace27->OddFace1
    OddFace1
    rotate 144.0*z
  }
  object { // OddFace28->OddFace1
    OddFace1
    rotate 108.0*z
  }
  object { // OddFace29->OddFace1
    OddFace1
    rotate 72.0*z
  }
  object { // OddFace30->OddFace1
    OddFace1
    rotate 36.0*z
  }
  rotate -18.0*z
}
#declare EvenFace21 = intersection {
  plane { // Plane44
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -290.0*y
    translate  <1.334647, 0.0, 0.673893>
  }
  plane { // Plane45
    z,0
    scale <0.15, 0.2, 0.1>
    rotate -335.0*y
    translate  <1.021438, 0.0, 0.967213>
  }
}
#declare EvenFaces2 = intersection {
  object { EvenFace21 }
  object { // EvenFace22->EvenFace1
    EvenFace1
    rotate -36.0*z
  }
  object { // EvenFace23->EvenFace1
    EvenFace1
    rotate -72.0*z
  }
  object { // EvenFace24->EvenFace1
    EvenFace1
    rotate -108.0*z
  }
  object { // EvenFace25->EvenFace1
    EvenFace1
    rotate -144.0*z
  }
  object { // EvenFace26->EvenFace1
    EvenFace1
    rotate 180.0*z
  }
  object { // EvenFace27->EvenFace1
    EvenFace1
    rotate 144.0*z
  }
  object { // EvenFace28->EvenFace1
    EvenFace1
    rotate 108.0*z
  }
  object { // EvenFace29->EvenFace1
    EvenFace1
    rotate 72.0*z
  }
  object { // EvenFace30->EvenFace1
    EvenFace1
    rotate 36.0*z
  }
}
#declare Diamond3 = intersection {
  plane { // Plane43
    z,0
    scale <1.0, 1.0, 0.1>
    rotate -0.1*z
    translate  1.005045*z
  }
  object { OddFaces2 }
  object { EvenFaces2 }
  texture {
    Diamond3Texture
  }
  bounded_by { // Bound4
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.555562, 1.567959, 0.925831>
      translate  <0.0, 0.0, 0.231129>
    }
  }
  rotate <0, 0, -clock * (360 / 10)>
  scale 1.5
  translate  <0.0, 2.0, 10.45>
}
#declare CSG5 = union {
  object { Diamond3 }
  rotate -240.0*z
  translate  -6.74*z
}
union { // Towers
  object { CSG001 }
  object { // CSG2->CSG001
    CSG001
    scale <1.0, 1.0, 0.75>
    rotate -120.0*z
    translate  -0.75*z
  }
  object { // CSG3->CSG001
    CSG001
    scale <1.0, 1.0, 0.5>
    rotate 120.0*z
    translate  -1.5*z
  }
  object { CSG002 }
  object { CSG4 }
  object { CSG5 }
  no_shadow
  rotate 60.0*z
}


plane { // CloudPlane
  z,0
  texture {
    CloudTexture
  }
  no_shadow
  rotate <-180.0, 0.0, 22.5>
  translate  50.0*z
}


sphere { // SkySphere001
  <0,0,0>,1
  texture {
    SkyTexture01
  }
  no_shadow
  hollow
  scale 1000.0
  rotate <7.0, 0.0, 33.0>
}




