#declare SIMPLE=0 // Change to 1 for quick render
#declare VIRTUAL=0 // Change to 1 to use `wireframe' effect on bottle neck
#declare BEERBOTTLE=1
#declare ONLYBUBBLES=0
#declare PILSNER=1
#declare BACKGROUND=1

#include "consts.inc"
#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "shapesq.inc"
#include "textures.inc"
#include "glass.inc"
#include "woods.inc"

#declare Ground =
	sphere {
		<0, -1000, 0>, 1000  // Small World

		texture {
			pigment {
				P_WoodGrain4A
				scale 8
				rotate <70,30,20>
			}
			finish { Dull }
		}
	}

#declare Sky =
	sphere {
		<0, -10000, 0>, 10400 // 400 above the ground
		texture {
			pigment {
				Blue_Sky2
				scale 2500
				quick_colour Blue
			}
			finish {ambient 0.8 diffuse 0 }
		}
		inverse
	}



#declare VB_Label =
	cylinder {
		<0,0,0>
		<0,3.2,0>
		1

		texture {
			pigment {
				image_map {
					gif "vb.gif"
					map_type 2
					filter 204, 1
					transmit all 0.15
					transmit 204 0
					once
				}
				rotate y*180
				scale <1,3.1415*.7,1>
			}
			normal {
				bumps 0.05
			}
			finish {
				ambient 0.1
				diffuse 0.4
				specular 0.5
			}
		}

		scale 8.01/3.14*2

		translate <0,2,0>
	}

#declare BotScale=8/3.14*2

#declare TopOfBottle =
	<0,4.32,0>*BotScale

#declare BottleShape =
	merge {
		// Base
		difference {
			sphere {
				<0,0,0>,1 scale <1,0.5,1>
				translate <0,0.2,0>
			}
			plane { y,0 }
		}

		// Body
		cylinder {
			<0,0.2,0>, <0,2.74,0>, 1
		}

		// Shoulders
		sphere {
			<0,0,0>,1 scale <1,0.7,1>
			translate <0,2.74,0>
		}

		// Neck
		cone {
			<0,2.9,0>,0.95 <0,4.0,0>,0.35
		}

		// Mouth
		cylinder {
			<0,4.0,0>,
			<0,4.32,0>,
			0.35
		}

		// Collar
		sphere {
			<0,0,0>,0.41 scale <1,0.2,1>
			translate <0,4.1,0>
		}

		scale BotScale
	}

#declare BeerCap =
	union {
		difference {
			union {
				intersection {
					sphere {
						<0,0,0>,1
						translate y*1
					}
					cylinder {
						<0,1,0>
						<0,1.4,0>
						1
					}
				}
				cylinder {
					<0,0,0>
					<0,1,0>
					1
				}
			}
			#declare NSCALLOP=21
			#declare SCALLOP=NSCALLOP
			#while (SCALLOP>0)
				cone {
					<1.05,1,0>,0.04
					<1.05,-0.01,0>,0.13
					rotate y*360*SCALLOP/NSCALLOP
				}
				cone {
					<0.80,1,0>,0.04
					<0.80,-0.01,0>,0.11
					rotate y*360*(SCALLOP+0.5)/NSCALLOP
				}
				#declare SCALLOP=SCALLOP-1
			#end
			cylinder { <0,-0.01,0> <0,1.35,0> 0.82 }
		}
		intersection {
			torus {
				0.7
				0.08
				scale <1,0.4,1>
			}
			plane { y,0 }
			translate <0,1.30,0>
			texture {
				pigment { rgb<1,1,0.6> }
				finish { Shiny }
			}
		}

		scale <2,0.6,2>

		// Flip it over
		rotate x*180 translate <0,1.4,0>

		texture { Gold_Metal }
	}

#declare TH=0.05

#declare Virtuality =
		texture {
			pigment {
				radial
				frequency 16
				colour_map {
				 [ 0.0 color Green ]
				 [ TH  color Green ]
				 [ TH  color Clear ]
				 [ 1.0-TH color Clear ]
				 [ 1.0-TH color Green ]
				 [ 1.0 color Green ]
				}
				quick_colour Green
			}
			//finish { Luminous }
		}
		texture {
			pigment {
				gradient y
				colour_map {
				 [ 0.0 color Green ]
				 [ TH  color Green ]
				 [ TH  color Clear ]
				 [ 1.0-TH color Clear ]
				 [ 1.0-TH color Green ]
				 [ 1.0 color Green ]
				}
				scale 1
				translate <0,0.1,0>
				quick_colour White
			}
			//finish { Luminous }
		}

#declare MyGlass =
	texture {
#if (SIMPLE>2)
		pigment { color rgb <0.98, 0.98, 0.98> }
#else
		pigment {
			color rgbf <0.95, 0.95, 0.95, 0.96>
			quick_colour rgb <0.98, 0.98, 0.98>
		}
		finish  {
		    caustics 0.2
		    ambient 0.05
		    diffuse 0.05
		    reflection 0.1
		    refraction 1
		    ior 1.45
		    specular 0.80
		    roughness 0.003
		    //phong 1
		    //phong_size 400
		}
		normal {
			bumps 0.02
		}
#end
	}


#declare VirtualBottle =
	difference {
		#declare S=25

		object {
			BottleShape

			texture {
#if (VIRTUAL)
				gradient <0,-1,0>
				texture_map {
				 [0.000 MyGlass ]
				 [0.650 MyGlass ]
				 [0.700 Virtuality scale <1,1/S,1> ]
				 [1.000 Virtuality scale <1,1/S,1> ]
				}
				scale <S/4,S,S/4>
#else
				MyGlass
#end
			}
		}
		merge {
			object { BottleShape scale <0.921,0.981,0.921> translate <0,0.395,0> }
			sphere { // Open the mouth
				<0,0,0>,0.35 scale <1,1,1>
				translate <0,4.1,0>
				scale 8/3.14*2
			}

			texture {
#if (VIRTUAL)
				gradient <0,-1,0>
				texture_map {
				 [0.000 MyGlass ]
				 [0.650 MyGlass ]
				 [0.700 pigment{ Clear } ]
				 [1.000 pigment{ Clear } ]
				}
				scale <1,S,1>
#else
				MyGlass
#end
			}
		}
	}

#declare AmberFluid =
	texture {
#if (SIMPLE>2)
		pigment {
			color rgb<1.0,0.8,0.0>
		}
#else
		pigment {
			color rgbf<1.0,0.8,0.0,0.9>
			quick_colour rgb<1.0,0.8,0.0>
		}
		finish {
			caustics 0.2
			ambient 0.05
			diffuse 0.1
			reflection 0.1
			specular 0.7
			refraction 1
			ior Water_Ior
			roughness 0.001
		}
#end
	}

#declare Beer =
	object {
		BottleShape scale <0.92,0.98,0.92> translate <0,0.4,0>
		texture { AmberFluid }
	}


global_settings {
	adc_bailout 8/255
	max_trace_level 10
}

#declare R=seed(123)

#declare TBUB=0
#declare BeerBubbles =
#if (SIMPLE>1)
	sphere { <0,9999999,0> 1 }
#else
	union {
 //box { <-0.5,0,-0.5> <0.5,1,0.5> texture { pigment { colour Magenta } } }

		#declare BubbleStart=220

		#while (BubbleStart > 0)
			#declare BubbleStart=BubbleStart-1
			#declare X=rand(R)-0.5
			#declare Y=rand(R)+0.03
			#declare Z=rand(R)-0.5
			#declare Radius=0.003

			#declare mX=X
			#declare mY=Y
			#declare mZ=Z
			#declare MX=X
			#declare MY=Y
			#declare MZ=Z
			#declare MRadius=Radius

			union {
			#while ((Y<1) & (rand(R)<0.93))
				#declare TBUB=TBUB+1
				sphere { <X,Y,Z>,Radius }
				#declare BubbleUp=0.01+Y/50*(1+rand(R)/100)
				#declare X=X+rand(R)/25-0.02
				#declare Z=Z+rand(R)/25-0.02
				#declare Y=Y+BubbleUp
				#declare Radius=Radius*(1.03+BubbleUp/25)
				#if (Radius>MRadius)
					#declare MRadius=Radius
				#end
				#if (X>MX)
					#declare MX=X
				#end
				#if (Y>MY)
					#declare MY=Y
				#end
				#if (Z>MZ)
					#declare MZ=Z
				#end
				#if (X<mX)
					#declare mX=X
				#end
				#if (Y<mY)
					#declare mY=Y
				#end
				#if (Z<mZ)
					#declare mZ=Z
				#end
			#end
				bounded_by { box { <mX-MRadius,mY-MRadius,mZ-MRadius> <MX+MRadius,MY+MRadius,MZ+MRadius> } }
			}
		#end

		texture {
#if (ONLYBUBBLES)
			pigment { White }
#else
			pigment { Clear }
			finish { 
				caustics 0.2
				ambient 0.1
				diffuse 0.2
				reflection 0.25
				refraction 1
				ior Air_Ior
				specular 1
				roughness 0.001
			}
#end
		}
	}
#end
#debug concat("[",str(TBUB,0,0)," bubbles]")

#declare BottleAngleBack=25
#declare BottleRise=20

#declare BottleMovement=
	transform {
		translate y*-8
		rotate z*100
		rotate y*-BottleAngleBack
		translate y*+BottleRise
	}
#declare MovedTopOfBottle = // ***** SAME AS BottleMovement ABOVE *****
	vaxis_rotate(vaxis_rotate((TopOfBottle+<0,-8,0>),z,100),y,-BottleAngleBack)+<0,BottleRise,0>
#declare AlongBottleFluid = 
	vaxis_rotate(x,y,-BottleAngleBack)


#declare BottlePouringBeer =
	union {
#if (BEERBOTTLE)
		union {
			object { VirtualBottle }
			object { VB_Label }
			transform BottleMovement
		}
#end

#if (ONLYBUBBLES)
		intersection {
#else
		difference {
#end
			merge {
				intersection {
					difference {
						object { Beer }
						cone {
							<1,3.0,0>, 0
							<-0.3,4.8,0>, 0.6
							scale BotScale
						}
						transform BottleMovement
					}
					plane {
						y,BottleRise-1.7
					}
				}
				blob {
					threshold 1
					sphere { <0.3,-0.3,0> 1 1.4 scale <2.4,1.60,2.4> rotate z*30 translate y*-0.8 }
					sphere { <0.6,-1.1,0> 0.7 1.2 scale <2.4,1.60,2.4> }
					sphere { <1.1,0,0> 1 3 scale <2.4,0.85,2.2> rotate z*00 translate y*-0.1 }
					sphere { <2.3,0,0> 1 2.6 scale <2.4,0.35,2.2> }
					cylinder { <-0.2,-2.0,0> <-1,-6,0> 1.6 2 }
					//scale <1.5,0.35,1.5>
					rotate y*-BottleAngleBack
					translate <0,0.65,0>+MovedTopOfBottle
				}
				texture {
					AmberFluid
					normal { ripples }
				}
			}
			object { BeerBubbles scale <20,BottleRise,20> translate <-1,0,-3> }
		}
	}

#declare PilsnerShape =
	lathe {
		cubic_spline
		14
		#declare N=2600
		<     0,4800> <N-2175,4800> <N-1875,4650> /*<N-1875,4425>*/
		<N-1725,2475> <N-1275,375 > <N-1275,300 > <N-1200,300>
		<N-1200,375 > <N-1650,2475> <N-1875,4725> <N-1350,5400>
			<N-1875,5400> <N-2400,5400> <     0,4800>
		sturm
		translate <0,-5400,0>
		scale <0.004,-0.004,0.004>
	}
#declare PilsnerContentsShape =
	lathe {
		cubic_spline
		8
		#declare N=2600
		<     0,4800> <N-2175,4800> <N-1875,4650> /*<N-1875,4425>*/
		<N-1725,2475> <N-1275,375 > <N-1275,300 > <     0,300>
		<     0,4800>
		sturm
		translate <0,-5450,0>
		scale <0.004,-0.004,0.004>
	}

#declare BeerFoam =
	texture {
		pigment {
			leopard
			turbulence 5
			colour_map {
			 [0.00  White ]
			 [0.40  White ]
			 [0.55  rgb<1.0,0.8,0.0> ]
			 [1.00  rgb<1.0,0.8,0.0> ]
			}
			quick_colour White
		}
/*
		pigment {
			crackle
			turbulence 0.5
			colour_map {
			 [0.00  White ]
			 [0.96  White ]
			 [0.98  rgb<1.0,0.8,0.0> ]
			 [1.00  rgb<1.0,0.8,0.0> ]
			}
			quick_colour White
		}
*/
		finish { Shiny }
/*
		normal {
			crackle 0.2
			turbulence 0.5
			sine_wave
		}
*/
		normal {
			granite 0.1
			turbulence 0.5
			sine_wave
		}
		scale 0.003
	}

#declare Pilsner =
	union {
#if (ONLYBUBBLES)
		intersection {
#else
		difference {
#end
			object{
				PilsnerContentsShape
				texture {
					gradient y
					texture_map {
					 [ 0.00 AmberFluid ]
					 [ 0.75 AmberFluid ]
					 [ 0.80 BeerFoam ]
					 [ 1.00 BeerFoam ]
					}
					scale 22
				}
			}
			object { BeerBubbles scale <20,15,20> translate <0,0,0> }
		}
#if (!ONLYBUBBLES)
		object{ PilsnerShape texture { MyGlass } }
#end
		scale 1.0 // 0.8
	}

#declare BeerMatThickness = 1

#declare BeerMat =
	box {
		<-50,0,0> <50,BeerMatThickness,25>
		texture {
			pigment {
				image_map {
					tga "beermat.tga"
				}
				rotate x*90
				scale <100,1,25>
			}
			normal {
				granite 0.3
				scale 20
			}
		}
	}

#declare BarBench =
	superellipsoid {
		<0.1,0.1>
		scale <100,1,20>
		texture {
			T_Wood4
			rotate y*91
			scale 50
		}
		translate <0,-1,15>
	}


// Window - Unit=meter

#declare Cream = pigment { colour rgb <255,216,138>/255 }

#declare WallPaint =
	finish { ambient 0.1 diffuse 0.5 specular 0.3 roughness 0.01 }

#declare VJ =
	normal {
		gradient x
		slope_map {
			[ 0.000 <0.5,0> ]
			[ 0.420 <0.5,0> ]
			[ 0.420 <0.5,-1> ]
			[ 0.450 <0.0,-1> ]
			[ 0.450 <0.0,1> ]
			[ 0.470 <0.5,1> ]
			[ 0.470 <0.5,0> ]
			[ 1.000 <0.5,0> ]
		}
		translate <10.5,0,0>
		scale 0.1*8/11
	}

#declare Ceiling =
	box {
		<-10,0,0> <10,10,0.1>
		texture {
			pigment { White }
			normal { VJ rotate z*90 }
			finish { WallPaint }
		}
		rotate x*-71
		translate <0,1.130,0>
	}

#declare Wall =
	box {
		<-10,-10,0> <10,10,0.1>
		texture {
			// VJ panelling (in theory!)
			pigment { Cream }
			normal { VJ }
			finish { WallPaint }
		}
	}

#declare HeritageRed =
	texture {
		pigment { colour rgb <0.5,0,0> }
		finish { WallPaint }
	}

#declare BottomSill =
	union {
		union {
			box {
				<-.16,-0.015,-0.040>
				<1.0,0.015,0>
			}
			box {
				<0.015,0,0>
				<0.825,0.015,0.035>
			}
			texture { HeritageRed }
		}
		box {
			<-0.060,-0.070,-0.0150>
			<-0.060,-0.070,0>
			pigment { Cream }
		}
	}

#declare Curtain_and_side_strip =
	union {
		box {
			<-0.070,0.960,-0.015>
			<0.910,1.040,0>
		}
		box { <0,0,0> <0.015,0.98,0.035> }
		box { <0.8250,0,0> <0.840,0.98,0.035> }
		texture { HeritageRed }
	}

#declare AntiqueGlassBumps =
	normal {
		bumps 1
		scale 0.01
	}

// Window
#declare Window =
	union {
		// Glass
		union {
			box {
				<0.040,0.040,0.043>
				<0.410,0.200,0.049>
			}
			box {
				<0.040,0.780,0.043>
				<0.410,0.935,0.049>
			}
			texture {
				pigment { rgbft <0,1,0,0.4,0.4> }
				//pigment { rgb <0,1,0> }
				normal { AntiqueGlassBumps }
			}
		}

		union {
			box {
				<0.040,0.200,0.043>
				<0.410,0.780,0.049>
			}
			texture {
				pigment { rgbft <1,1,1,0.4,0.4> }
				normal { AntiqueGlassBumps }
			}
		}

		// Frame
		difference {
			box {
				<0.001,0.001,0.036>
				<0.419,0.979,0.066>
			}

			box {
				<0.050,0.215,0>
				<0.370,0.765,0.1>
			}

			box {
				<0.050,0.050,0>
				<0.195,0.195,0.1>
			}
			box {
				<0.215,0.785,0>
				<0.370,0.930,0.1>
			}

			box {
				<0.050,0.785,0>
				<0.195,0.930,0.1>
			}
			box {
				<0.215,0.050,0>
				<0.370,0.195,0.1>
			}
		}
	}


#declare WindowPair =
	union {
		object { Window }
		object { Window translate <0.420,0,0>}
		texture {
			//pigment { Cream }
			pigment { White }
			finish { WallPaint }
		}
	}

#declare WindowPair1Open =
	union {
		object { Window }
		object {
			Window

			translate <-0.420,0,-0.066>
			rotate y*100
			translate <0.420,0,0>

			translate <0.420,0,0>
		}
		texture {
			//pigment { Cream }
			pigment { White }
			finish { WallPaint }
		}
	}

#declare WindowHole =
	box {
		<0,0,-0.1> <0.84,0.98,0.15>
		texture {
			pigment { Cream }
			finish { WallPaint }
		}
	}

#if (BACKGROUND)
union {
	union {
		object { WindowPair }

		object { BottomSill }
		object { Curtain_and_side_strip }

		translate <-0.5,0,0>
	}

	union {
		object { WindowPair1Open }

		object { BottomSill }
		object { Curtain_and_side_strip }

		translate <+1,0,0>
	}

	difference {
		object { Wall }
		object { WindowHole translate <-0.5,0,0> }
		object { WindowHole translate <+1,0,0> }
	}

	scale 100
	translate <-50,-30,150>
}
#end

union {
	object {
		BottlePouringBeer
		translate <7,8,10>
	}
	#if (PILSNER)
	object {
		Pilsner 
		translate <-6,BeerMatThickness,4>
	}
	#end

	object {
		BeerCap
		translate <4,BeerMatThickness,3>
	}

	translate <0,0,3>
}

#if (BACKGROUND)
object { BeerMat }
#end

#if (BACKGROUND)
object { BarBench }
#end


#declare Far =
	camera {
		location <0,15,-100>
		right x*4/3
		look_at <0,10,0>
	}

#declare Above =
	camera {
		location <0,50,0>
		right x*4/3
		look_at <0,10,0>
	}

#declare FarAbove =
	camera {
		location <0,250,0>
		right x*4/3
		look_at <0,10,0>
	}

#declare Aesthetic =
	camera {
		location <0,BottleRise*1.2,-BottleRise*1.7>
		right x*4/3
		look_at <2,BottleRise*0.85,2>
	}

#declare AtUnit =
	camera {
		location <0,0.5,-3>
		direction z*2
		right x*4/3
		look_at <0,0.5,0>
	}

#declare AtHeadOfBeer =
	camera {
		location <-7,23,-4>
		right x*4/3
		look_at <-7,20,3>
	}
#declare AtMouthOfBottle =
	camera {
		location <-7,BottleRise+4,-10>
		right x*4/3
		look_at <-5,BottleRise,3>
	}
#declare AtBeerCap =
	camera {
		location <-2,3,-4>
		right x*4/3
		look_at <2,0,0>
	}

//camera { Far }
//camera { Above }
//camera { FarAbove }
//camera { AtUnit }
//camera { AtMouthOfBottle }
//camera { AtHeadOfBeer }
//camera { AtBeerCap }
camera { Aesthetic }

light_source {
	<-40,250,-300>
	colour rgb <1.2,1.2,1.2>
}

#if (BACKGROUND)
object { Sky }
#end
