
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// "p4_main.inc" - Create one object called "One_Person".
//
// "Paul's Primitive POV People", or "P4".
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// Version 0.3 - February 28, 1997
//
// Note: You MUST include a "P4DEF_??.INC" file before this file,
//       to set all of the variables for one "person". That DEF file
//       will automatically call this file.
//
// Note: The person is facing you.
//       "Left" is on the left side of your screen.
//       "Right" is on the right side of your screen.
//
// Note: This file is *VERY* jumbled. It works, but it's part of a
//       last minute rush for the IRTC. Good luck figuring it out!
//
// Note: Your main program must include these POV3 files:
//       "colors.inc" "textures.inc" "golds.inc" "stones.inc"
//
// Note: Please send me any improvements and/or changes that you make
//       to this file, and I'll put them into the [frequent?] updates.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// There is no shirt type #1. For now, everyone gets shirt type #2.


//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make the pieces of the uni-gender <G> shirt.

        #declare P4_Arm_Height = P4_Shirt_Height - 3

        #if ( P4_Shirt_Type = 2 )

        #declare Shirt_Body = union {

                // Most of the shirt.
                cone { <0,0,0>,    14    <0,P4_Arm_Height, 0>,8
                scale < 0.8, 1, 0.5 > }

                // Round off the top of the cone.
                sphere{ 0, 8 scale < 1, 0.5, 0.5 >
                        translate y * P4_Arm_Height }

                // Top side-to-side tube.
                cylinder { <-8,P4_Arm_Height,0><8,P4_Arm_Height,0>,3 }

                // Round off attachments to sleeves.
                sphere { < -8,P4_Arm_Height,0>,3 }
                sphere { <  8,P4_Arm_Height,0>,3 }

                } // End of union.
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make the sleeves, at the correct angles.

        #declare Left_Sleeve = cylinder {<0,0,0><-6,0,0>,3
                rotate P4_Left_Shoulder_Rotate
                translate < -8, P4_Arm_Height, 0 >
                } // End of cylinder.

        #declare Right_Sleeve = cylinder {<0,0,0><6,0,0>,3
                rotate P4_Right_Shoulder_Rotate
                translate < 8, P4_Arm_Height, 0 >
                } // End of cylinder.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now put the shirt together.

        #declare Shirt = union {
                object { Shirt_Body }
                object { Left_Sleeve }
                object { Right_Sleeve }

                texture { P4_Shirt_Texture }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make the hands (add to forearms in next section). The left hand points
// to the left of your screen (negative x). Right hand points to right.
// Then they get rotated according to the hand rotation variables.

// Type #1 is a "fist".

        #if ( P4_Hand_Type = 1 )
                
                #declare P4_Left_Hand = sphere { 0, 3 scale < 0.6, 1, 1 > }
                #declare P4_Right_Hand = sphere { 0, 3 scale < 0.6, 1, 1 > }
                
        #end

// Type #2 has fingers pointing straight out.

        #if ( P4_Hand_Type = 2 )

                #declare P4_Left_Hand = union {
                        sphere{0,2.5 scale <1,0.5,1> }

                        #declare P4_TEMP = -2
                        #while(P4_TEMP<=2)

                                #declare TEMP2=-7
                                #if(P4_TEMP=-2)#declare TEMP2=-5 #end
                                
                                cone{<0,0,0>, 0.75 <TEMP2,0,0>, 0.25
                                rotate y * (P4_TEMP*20) }

                        #declare P4_TEMP = P4_TEMP + 1
                        #end

                        } // End of union.

                #declare P4_Right_Hand = union {
                        sphere{0,2.5 scale <1,0.5,1> }

                        #declare P4_TEMP = -2
                        #while(P4_TEMP<=2)
                                
                                #declare TEMP2=7
                                #if(P4_TEMP=2)#declare TEMP2=5 #end

                                cone{<0,0,0>, 0.75 <TEMP2,0,0>, 0.25
                                rotate y * (P4_TEMP*20) }

                        #declare P4_TEMP = P4_TEMP + 1
                        #end

                        } // End of union.

        #end

// If a "holding" object was defined, put it in LEFT hand right now.

        #if ( P4_Holding_Flag = true )

                #declare P4_Temp_Left_Hand = union {

                        object { P4_Left_Hand }
                        object { P4_Holding_Object }

                        } // End of union.

                #declare P4_Left_Hand = object { P4_Temp_Left_Hand }

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Add some arms.

        // The left arm *might* get a bracelet!

        #declare Left_Fore_Arm = union {

                object { P4_Left_Hand
                        rotate P4_Left_Hand_Rotate
                        translate x*-14 }
                cylinder { < 0, 0, 0 > < -14, 0, 0 >, 2 }
                sphere { 0, 2 }

                #if ( P4_Bracelet_Flag = true )
                        object { P4_Bracelet_Object
                                rotate z * 90
                                translate x * -9 }
                #end

                rotate P4_Left_Elbow_Rotate

                } // End of cylinder.

        #declare Right_Fore_Arm = union {

                object { P4_Right_Hand
                        rotate P4_Right_Hand_Rotate
                        translate x*14 }
                cylinder { < 0, 0, 0 > < 14, 0, 0 >, 2 }
                sphere { 0, 2 }

                rotate P4_Right_Elbow_Rotate

                } // End of cylinder.


        #declare Left_Arm = union {
                cylinder {<0,0,0><-14,0,0>,2  }
                object{Left_Fore_Arm translate x*-14}

                rotate P4_Left_Shoulder_Rotate
                translate < -8, P4_Arm_Height, 0 >

                texture { P4_Skin_Texture }

                } // End of union.

        #declare Right_Arm = union {
                cylinder {<0,0,0><14,0,0>,2 }
                object{Right_Fore_Arm translate x*14}

                rotate P4_Right_Shoulder_Rotate
                translate < 8, P4_Arm_Height, 0 >

                texture { P4_Skin_Texture }

                } // End of cylinder.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build the parts for the head. It starts on the floor (y=0).

        // Make neck a little higher than necessary, to fill in
        // the gap where chin is differenced from head.

        #declare Neck= union {

                cone { <0,0,0>,3 <0, P4_Neck_Height+3, 0>,1.7 }
                sphere { <0,0,0>,3 }

                texture { P4_Skin_Texture }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Put the head together. It's just one big sphere, with a lot of
// little pieces differenced from it.

        #declare Head = difference {

                sphere{0,5 scale <1,1.5,1> }

                // Left eye cutout.
                cone { <0,0,0>, 1.6 <0,0,-11>, 3.6
                        scale < 1.2, 0.7, 1 >
                        translate < -1.7, 1, -3.8 > }

                // Right eye cutout.
                cone { <0,0,0>, 1.6 <0,0,-11>, 3.6
                        scale < 1.2, 0.7, 1 >
                        translate <  1.7, 1, -3.8 > }

                // Chin. This box is angled downwards (so-so).
                        box { < -9, -9, -9 > < 9, 0, 0 >
                                rotate x * 15
                                translate y * -6.15 }

                // Diagonal cutout around mouth/cheeks.
                box{ < -3.0, -3.0, -10 > < 3.0, 3.0, -3.8 >
                        rotate z*45
                        scale < 1, 1.2, 1 >
                        translate y * -4 }

                // Slice off a tiny bit of rounded front surface.
                box{ < -9, -9, -9 > < 9, 1.4, -3.85 > }

                texture { P4_Skin_Texture }

        } // End of difference.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make some noses.

// Regular size nose.

        #if ( P4_Nose_Type = 1 )

                #declare P4_Nose = difference {

                        sphere { 0, 2.8 scale < 0.25, 1, 0.25 > }

                        box { < -5, -5, -5 > < 5, 0, 5 > }

                        translate <0, (3+P4_Neck_Height), -3.8>

                        texture { P4_Skin_Texture }

                        } // End of difference.

        #end

// Slightly larger nose.

        #if ( P4_Nose_Type = 2 )

                #declare P4_Nose = difference {

                        sphere { 0, 2.8 scale < 0.35, 1, 0.35 > }

                        box { < -5, -5, -5 > < 5, 0, 5 > }

                        translate <0, (3+P4_Neck_Height), -3.8>

                        texture { P4_Skin_Texture }

                        } // End of difference.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now make some ears.

        #declare P4_Left_Ear = union {

                sphere { 0, 1.5 scale < 1, 0.1, 1 > }

                torus { 1.3, 0.3 }

                rotate x * 90
                rotate y * 30

                translate x * -5

                texture { P4_Skin_Texture }

        } // End of union.

        #declare P4_Right_Ear = union {

                sphere { 0, 1.5 scale < 1, 0.1, 1 > }

                torus { 1.3, 0.3 }

                rotate x * 90
                rotate y * -30

                translate x * 5

                texture { P4_Skin_Texture }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The eyes are not realistic, but they sure are *complicated* !!!

        #declare Two_Eyes = union {

                // White part.
                sphere{0,1  scale < 1, 0.6, 0.2 >
                pigment{White} translate x*-2}

                sphere{0,1  scale < 1, 0.6, 0.2 >
                pigment{White} translate x* 2}

                // Color part.
                sphere{0,0.4 scale < 1, 1, 0.3 >
                texture{P4_Eye_Texture} translate <-2,0,-0.1>}

                sphere{0,0.4 scale < 1, 1, 0.3 >
                texture{P4_Eye_Texture} translate < 2,0,-0.1>}

                // Black part.
                sphere{0,0.2 scale <1,1,0.7>
                pigment{Gray10} translate <-2,0, -0.1>}

                sphere{0,0.2 scale <1,1,0.7>
                pigment{Gray10} translate < 2,0, -0.1>}

                // Left eyelid.
                difference {
                        sphere{ 0, 1.3 }
                        box { <-2,-2,-2> <2,2,0> }
                        texture { P4_Skin_Texture }
                        rotate x * P4_Left_Eyelid_Rotate
                        scale < 1, 0.6, 0.2 >
                        translate x * -2
                } // End of difference.

                // Right eyelid.
                difference {
                        sphere { 0,1.3 }
                        box { <-2,-2,-2> <2,2,0> }
                        texture { P4_Skin_Texture }
                        rotate x * P4_Right_Eyelid_Rotate
                        scale < 1, 0.6, 0.2 >
                        translate x * 2
                } // End of difference.

                // Cover bottom of left eye.
                difference {
                        sphere{ 0, 1.3 }
                        box { <-2,-2,-2> <2,2,0> }
                        texture { P4_Skin_Texture }
                        rotate x * 30
                        scale < 1, 0.6, 0.2 >
                        translate x * -2
                } // End of difference.

                // Cover bottom of right eye.
                difference {
                        sphere{ 0, 1.3 }
                        box { <-2,-2,-2> <2,2,0> }
                        texture { P4_Skin_Texture }
                        rotate x * 30
                        scale < 1, 0.6, 0.2 >
                        translate x * 2
                } // End of difference.

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Maybe make some glasses.

        #if ( P4_Glasses_Type = 1 )

                #declare P4_Glasses = union {

                        // Glass.
                        sphere { 0, 2 scale < 1, 0.7, 0.01 >
                                texture { P4_Glasses_Texture }
                                translate x * -2.2 }

                        sphere { 0, 2 scale < 1, 0.7, 0.01 >
                                texture { P4_Glasses_Texture }
                                translate x * 2.2 }

                        // Rims.
                        torus { 2, 0.1 rotate x * 90
                                scale < 1, 0.7, 1 >
                                pigment { SteelBlue }
                                translate x * -2.2 }

                        torus { 2, 0.1 rotate x * 90
                                scale < 1, 0.7, 1 >
                                pigment { SteelBlue }
                                translate x * 2.2 }

                        // Center connector.
                        cylinder { < -0.2, 0, 0 > < 0.2, 0, 0 >, 0.1
                                pigment { SteelBlue } }

                        // Back to ears.
                        cylinder { < -4.2, 0, 0 > < -5.4, 0, 4.6 >, 0.1
                                pigment { SteelBlue } }

                        cylinder { < 4.2, 0, 0 > < 5.4, 0, 4.6 >, 0.1
                                pigment { SteelBlue } }

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Choose a mouth type. These are all very NON-artistic, sorry!

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Straight across mouth.

        #if (P4_Mouth_Type=1)
        #declare P4_Mouth = union {

                sphere{0,2 scale<1,0.2,0.2> translate <0, 0.1,0>}
                sphere{0,2 scale<1,0.2,0.2> translate <0,-0.1,0>}

                texture { P4_Lip_Texture }

                } // End of union.
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Sort-of-smiling-mouth.

        #if (P4_Mouth_Type=2)
        #declare P4_Mouth = union {
                torus{1.5,0.2 texture { P4_Lip_Texture } }
                sphere{0,1.6 scale<1,0.1,1>pigment{White}}

                rotate x*-90
                scale <1,0.5,1>

                } // End of union.
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Slightly different smile.

        #if ( P4_Mouth_Type = 3 )
        #declare P4_Mouth = union {

                difference {

                        union {
                                torus{ 2, 0.4 texture { P4_Lip_Texture }}
                                sphere{0,2 scale<1,0.1,1>pigment{White}}
                                rotate x*-90
                        } // End of union.

                        box{<-5,0,-5><5,5,5> texture { P4_Lip_Texture } }

                        } // End of difference.

                cylinder{<-2,0,0><2,0,0>,0.4 texture { P4_Lip_Texture } }

                scale <1,0.5,1>

                translate y * 0.5

                } // End of union.
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Upside-down smile (more of a growl).

        #if ( P4_Mouth_Type = 4 )
        #declare P4_Mouth = union {

                difference {

                        union {
                                torus{1.5,0.2 texture { P4_Lip_Texture }}
                                sphere{0,1.6 scale<1,0.1,1>pigment{White}}
                                rotate x*-90
                        } // End of union.

                        box{<-5,-5,-5><5,0,5> texture { P4_Lip_Texture } }

                        } // End of difference.

                cylinder{<-1.5,0,0><1.5,0,0>,0.2 texture { P4_Lip_Texture } }

                scale <1,0.5,1>

                translate y * -0.25

                } // End of union.
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Straight and narrow mouth.

        #if ( P4_Mouth_Type = 5 )
        #declare P4_Mouth = union {

                sphere{0,2 scale<0.5,0.2,0.2> translate <0, 0.1,0>}
                sphere{0,2 scale<0.5,0.2,0.2> translate <0,-0.1,0>}

                texture { P4_Lip_Texture }

                } // End of union.
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Choose one of the hair styles.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Very simple, sort of a [sloppy] crew-cut.

        #if(P4_Hair_Type=1)

                #declare P4_Hair = difference{

                        sphere{0,5.5 scale <1,1.5,1>}

                        // Clip around front of face.
                        box { < -10, -20, -10 > < 10, 4, 0 >
                                rotate x*-10 }

                        // Clip along collar line.
                        box { < -10, -20, -10 > < 10, -3, 10 > }

                        texture{P4_Hair_Texture}

                        } // End of difference.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Wild frizzy mess.

        #if ( P4_Hair_Type = 2 )

                #declare P4_Hair = difference{

                        // Normal hair to fill in gaps.
                        union {
                        sphere{0,5.5 scale <1,1.5,1>}

                        // This is the [memory gobbling] frizzy stuff.
                        #declare A=0 #while(A<100)
                                sphere{0,14 scale < 0.1, 1, 0.1 >
                                rotate<rand(P4_RAND)*360,
                                       rand(P4_RAND)*360,
                                       rand(P4_RAND)*360 > }
                        #declare A=A+1 #end

                        } // End of union.

                        // Clip around front of face.
                        box { < -30, -30, -30 > < 30, 4, 0 >
                                rotate x*-10 }

                        // Clip along collar line.
                        //box { < -10, -20, -10 > < 10, -3, 10 > }

                        texture{P4_Hair_Texture}

                        } // End of difference.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Long hair.

        #if ( P4_Hair_Type = 3 )

                #declare P4_Hair = difference {

                        // Normal hair to fill in gaps.
                        union {
                        sphere{0,5.5 scale <1,1.5,1> }

                        // This is the long hair.
                        #declare A=0 #while(A<100)

                                torus { 20, 0.3
                                        // Flip it up.
                                        rotate z*90
                                        // Narrow it.
                                        scale < 0.4, 1, 0.4 >
                                        // Spin it around.
                                        rotate y*(rand(P4_RAND)*360)
                                        // Move it down a little.
                                        translate y * -11
                                        } // End of torus.

                        #declare A=A+1 #end

                        } // End of union.

                        // Clip around front of face.
                        box { < -30, -30, -30 > < 30, 3, 0 >
                                rotate x*-10 }

                        // Clip along bottom in back.
                        box { < -10, -40, -10 > < 10, -20, 10 > }

                        texture{P4_Hair_Texture}

                        } // End of difference.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now for the hats.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Type 1 is a painters hat.

        #if ( P4_Hat_Type = 1 )

        #declare Hat = union {

                // Tall part.
                        cylinder { < 0, 0, 0 > < 0, 5, 0 >, 6 }
                // Square bill.
                        box { < -6, 0, 0 > < 6, 0.5, -8 > }
                // Rounded front of bill.
                        cylinder { < 0, 0, -8 > < 0, 0.5, -8 >, 6 }

                texture { P4_Hat_Texture }

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Type 2 is a propellor beanie.

        #if ( P4_Hat_Type = 2 )

        #declare Hat = union {

                // Beanie part.
                        difference {
                        sphere { 0, 7 scale < 1, 0.8, 1> }
                        box { <-10,-10,-10> <10,0,10> }
                        texture {P4_Hat_Texture}
                        } // End of difference.
                // Brim.
                        difference {
                        cone { <0,0,  0>,7.5 <0,1.5,0>, 8.5 }
                        cone { <0,0.1,0>,7.4 <0,1.6,0>, 8.4 }
                        texture { P4_Hat_Texture rotate y*90 }
                        } // End of difference.
                // Propellor.
                        sphere{0,5 scale<1,0.1,0.2>pigment{Red}
                        translate y * 7 }
                // Connector.
                        cylinder{<0,3,0><0,7,0>,0.5 pigment{Blue}}
                // Fastener on top of propellor.
                        sphere { 0, 0.5 translate y * 7.5
                                pigment { Yellow } }

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Type 3 is a mailman's helmet.

        #if ( P4_Hat_Type = 3 )

        #declare Hat = union {

                // Beanie part.
                        difference {
                        sphere { 0, 6 scale < 1, 1.2, 1 > }
                        box { <-10,-10,-10> <10,0,10> }

                        } // End of difference.
                // Brim.
                        sphere { 0, 10 scale < 1, 0.1, 1 > }

                texture { P4_Hat_Texture }

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Type 4 is D. P. Gumby - handkerchief with knotted corners.

        #if ( P4_Hat_Type = 4 )

        #declare Hat = union {

                // Beanie part.
                difference {
                        sphere { 0, 7 scale < 1, 0.7, 1 > }
                        box { <-10,-10,-10> <10,0,10> }
                } // End of difference.

                // Four knots.
                #declare P4_TEMP = 1
                #while ( P4_TEMP <= 4 )

                        sphere { 0, 1.5 translate x * 6
                                rotate y * ((P4_TEMP*90)+45)
                                } // End of sphere.

                        cone { <0,0,0>, 1.0 <0,-4,0>, 0.5
                                rotate z * 30
                                translate x * 6
                                rotate y * ((P4_TEMP*90)+45)
                                } // End of cone.

                #declare P4_TEMP = P4_TEMP + 1
                #end

                texture { P4_Hat_Texture }

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Type 5 is a baseball hat.

        #if ( P4_Hat_Type = 5 )

        #declare Hat = union {

                // Beanie part.
                        difference {
                        sphere { 0, 7 scale < 1, 0.8, 1> }
                        box { <-10,-10,-10> <10,0,10> }

                        } // End of difference.

                // Square bill.
                        box { < -7, 0, 0 > < 7, 0.5, -8 > }
                // Rounded front of bill.
                        cylinder { < 0, 0, -8 > < 0, 0.5, -8 >, 7 }

                texture { P4_Hat_Texture }

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Assemble head and move to correct height.

        #declare Entire_Head = union {

                object { Neck }
                object { Head translate y* (4.5+P4_Neck_Height) }

                #if ( P4_Hat_Type != 0 )
                        object { Hat
                                rotate P4_Hat_Rotate
                                translate y * (9+P4_Neck_Height) }
                #end

                #if ( P4_Glasses_Type != 0 )
                        object { P4_Glasses
                        translate < 0, (5.5+P4_Neck_Height), -4.6> }
                #end

                object{Two_Eyes translate <0,(5.5+P4_Neck_Height),-3.8>}
                object{P4_Mouth translate <0, (1.5+P4_Neck_Height) ,-3.9 > }

                object { P4_Nose }
                object { P4_Left_Ear  translate y * (5+P4_Neck_Height) }
                object { P4_Right_Ear translate y * (5+P4_Neck_Height) }

                object{P4_Hair translate y* (4.5+P4_Neck_Height) }

                // Bottom of neck is at <0,0,0>, so rotate it all.
                        rotate P4_Neck_Rotate

                // Now raise to proper height.
                        translate y * P4_Shirt_Height

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build some shorts.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Type 1 is baggy.

        #if ( P4_Shorts_Type = 1 )

        #declare Hollow_Piece = difference {

                cone { <0,0,0>,6      <0, (P4_Shorts_Height*-1), 0>,8 }
                cone { <0,0.01,0>,5.5 <0, (P4_Shorts_Height*-1)-0.01, 0>,7.5 }

                } // End of difference.

        #declare Shorts = union {

                // Eveners.
                sphere {<-3,0,0>,6  }
                sphere {< 3,0,0>,6  }

                object { Hollow_Piece
                        rotate P4_Left_Leg_Rotate
                        translate x * -3 }

                object { Hollow_Piece
                        rotate P4_Right_Leg_Rotate
                        translate x * 3 }

                texture{P4_Shorts_Texture}

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Type 2 is tight.

        #if ( P4_Shorts_Type = 2 )

        #declare Hollow_Piece =

                cone { <0,0,0>,5.1 <0, (P4_Shorts_Height*-1), 0>,5.0 }

        #declare Shorts = union {

                // Eveners.
                sphere {<-2.1,0,1>,5.5  }
                sphere {< 2.1,0,1>,5.5  }

                object { Hollow_Piece
                        rotate P4_Left_Leg_Rotate
                        translate x * -3 }

                object { Hollow_Piece
                        rotate P4_Right_Leg_Rotate
                        translate x * 3 }

                texture{P4_Shorts_Texture}

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Type 3 is medium baggy.

        #if ( P4_Shorts_Type = 3 )

        #declare Hollow_Piece = difference {

                cone { <0,0,0>,5.5      <0, (P4_Shorts_Height*-1), 0>,6.5 }
                cone { <0,0.01,0>,5.4 <0, (P4_Shorts_Height*-1)-0.01, 0>,6.4 }

                } // End of difference.

        #declare Shorts = union {

                // Eveners.
                sphere {<-3,0,0>,5.5  }
                sphere {< 3,0,0>,5.5  }

                object { Hollow_Piece
                        rotate P4_Left_Leg_Rotate
                        translate x * -3 }

                object { Hollow_Piece
                        rotate P4_Right_Leg_Rotate
                        translate x * 3 }

                texture{P4_Shorts_Texture}

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now make some shoes.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build some hi-top sneakers.

        #if ( P4_Shoe_Type = 1 )

        #declare One_Shoe = union {

                cylinder { < 0, 0, 0 > < 0, -8, 0 >, 3 }

                cylinder { < 0, -4, 0 > < 0, -8, 0 >, 2.5
                        scale < 1, 1, 2 >
                        translate z * -2 }

                texture { P4_Shoe_Texture }

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build some in-line-skates.

        #if ( P4_Shoe_Type = 2 )

        #declare One_Shoe = union {

                // Top of boot.
                cylinder { < 0, 0, 0 > < 0, -8, 0 >, 3
                texture { P4_Shoe_Texture } }

                // Bottom of boot - ends up at (z=3 to z=-9).
                cylinder { < 0, -4, 0 > < 0, -8, 0 >, 3
                        scale < 1, 1, 2 >
                        translate z * -3
                        texture { P4_Shoe_Texture } }

                // Top part - Latch thingies.
                sphere{0,3 scale<1,0.2,1>translate <0,-1,-1>pigment{NeonBlue}}
                sphere{0,3 scale<1,0.2,1>translate <0,-2,-1>pigment{NeonBlue}}
                sphere{0,3 scale<1,0.2,1>translate <0,-3,-1>pigment{NeonBlue}}

                // Bottom part - Latch thingies.
                sphere{0,2 scale<1,0.5,0.2>translate <0,-4,-5>pigment{NeonBlue}}
                sphere{0,2 scale<1,0.5,0.2>translate <0,-4,-6>pigment{NeonBlue}}
                sphere{0,2 scale<1,0.5,0.2>translate <0,-4,-7>pigment{NeonBlue}}

                // Wheels.
                torus{1.0,0.5 pigment{Red} rotate z*90 translate<0,-10,  1>}
                torus{1.0,0.5 pigment{Red} rotate z*90 translate<0,-10, -3>}
                torus{1.0,0.5 pigment{Red} rotate z*90 translate<0,-10, -7>}

                // Vertical holders for the wheels.
                box{<-1.0,-5,  1-0.5> <1.0,-10.5,  1+0.5> pigment{SteelBlue} }
                box{<-1.0,-5, -3-0.5> <1.0,-10.5, -3+0.5> pigment{SteelBlue} }
                box{<-1.0,-5, -7-0.5> <1.0,-10.5, -7+0.5> pigment{SteelBlue} }

                // Long connector for all wheels (and brake pad).
                        box{<-1.0,-9.75, 4.5 > <1.0,-10.25,-7+0.5 >
                                pigment { SteelBlue } }

                // Brake pad.
                union {
                        box { < -1, -5, -0.5 > < 1, -5.5, 0.5 >
                                pigment { Gray20 } }

                        box { < -1, 0, -0.5 > < 1, -5.0, 0.5 >
                                pigment { SteelBlue } }

                        rotate x * -35
                        translate < 0, -6, 2 >
                        } // End of union.

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build some lo-top sneakers.

        #if ( P4_Shoe_Type = 3 )

        #declare One_Shoe = union {
        
                difference {

                union {

                        cylinder { < 0, 0, 0 > < 0, -4, 0 >, 3 }

                        cylinder { < 0, -1, 0 > < 0, -4, 0 >, 2.5
                                scale < 1, 1, 2 >
                                translate z * -2 }

                        } // End of union.

                // Slice off top at an angle.
                        box { < -4, -1.5, -12 > < 4, 6, 12 >
                                rotate x * -10 }

                } // End of difference.

                // Add laces.
                box { <-1,-1.5,-2><1,-1.3,-6> rotate x*-10
                        pigment { checker Black, White
                        scale < 10, 10, 0.5 > translate x*3 } }

                texture { P4_Shoe_Texture }

                translate y * 2

                } // End of union.

        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now add some legs.

        #declare P4_Half_Leg_Length = P4_Leg_Length / 2


        #declare Left_Shin = union {

                sphere { 0, 3 texture{P4_Skin_Texture} }

                cone { <0,0,0>,3 <0,(-1*P4_Half_Leg_Length),0>,2
                texture{P4_Skin_Texture} }

                object { One_Shoe translate y * (-1*P4_Half_Leg_Length) }

                rotate P4_Left_Knee_Rotate

                } // End of union.

        #declare Right_Shin = union {

                sphere { 0, 3 texture{P4_Skin_Texture} }

                cone { <0,0,0>,3 <0,(-1*P4_Half_Leg_Length),0>,2
                texture{P4_Skin_Texture} }

                object { One_Shoe translate y*(-1*P4_Half_Leg_Length) }

                rotate P4_Right_Knee_Rotate

                } // End of union.

        #declare Left_Leg = union {

                object{Left_Shin translate y*(-1*P4_Half_Leg_Length)}

                cone { <0,0,0>,5 <0,(-1*P4_Half_Leg_Length),0>,3
                        texture{P4_Skin_Texture}
                        } // End of cone.

                rotate P4_Left_Leg_Rotate
                translate x * -3

                } // End of union.


        #declare Right_Leg = union {

                object{Right_Shin translate y*(-1*P4_Half_Leg_Length)}

                cone { <0,0,0>,5 <0,(-1*P4_Half_Leg_Length),0>,3
                        texture{P4_Skin_Texture}
                } // End of cone.

                rotate P4_Right_Leg_Rotate
                translate x * 3
                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Put everything together.

        #declare One_Person = union {

                union {
                        object { Shirt }
                        object { Left_Arm }
                        object { Right_Arm }
                        object { Entire_Head }
                        rotate P4_Waist_Rotate
                        } // End of union.

                object { Shorts }
                object { Left_Leg  }
                object { Right_Leg }

                // Enlarge or shrink the entire person!

                        scale P4_Total_Scale

                // Move it all up so the feet are on the floor.
                // Test your person with P4_TEST.POV until you
                // guess the correct value!

                        translate y * P4_Y_Adjust

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

