#include "colors.inc"
#include "skies.inc"

#declare Whale_sign = on
#declare Ocean = on
#declare Glory = on

camera {
	location <0, 0,-4>
	look_at <0, 0, 0>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> atmosphere off}

#if (Glory = on)

#declare Sunbeam =
light_source
{
  <0, 0, 0>                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  point_at <0, -30, 0>      // direction of spotlight
  radius 0.01                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 0.5               // intensity falloff radius (outer, in degrees)
}

#declare Sunburst =
union {
      object {Sunbeam translate <0,40,0>}
      object {Sunbeam rotate <1,5,0> translate <0,40,0>}
      object {Sunbeam rotate <1,85,0> translate <0,40,0>}
      object {Sunbeam rotate <1,130,0> translate <0,40,0>}
      object {Sunbeam rotate <1,260,0> translate <0,40,0>}
//      object {Sunbeam rotate <2.5,-5,0> translate <0,40,0>}  ; delete this light
      object {Sunbeam rotate <2.5,90,0> translate <0,40,0>}
      object {Sunbeam rotate <2.5,200,0> translate <0,40,0>}
      object {Sunbeam rotate <2.5,280,0> translate <0,40,0>}
//      object {Sunbeam rotate <4,14,0> translate <0,40,0>}  ; delete this light
      object {Sunbeam rotate <4,100,0> translate <0,40,0>}
      object {Sunbeam rotate <4,210,0> translate <0,40,0>}
      object {Sunbeam rotate <4,245,0> translate <0,40,0>}
}

object {Sunburst}

atmosphere
{
  type 1
  samples 20
  distance 80  // old = 20
  scattering 0.5
  aa_level 8
  aa_threshold 0.1
  jitter 0.5
  color rgbft <.5,.6,.7,.5,.5>
}

#end

#if (Whale_sign = on)
#include "Whale3.inc"

object {Whale rotate <-10,45,-20> translate <0,-1,0>}
object {Whale rotate <-10,-15,40> translate <0.2,0.5,0.2>}
object {Whale rotate <-90,0,130> rotate <0,20,0> translate <-2,-0.5,1>}
object {Whale rotate <30,-45,-20> translate <1,0,1.2>}
object {Whale rotate <30,-45,-20> translate <2,-2,3>}
object {Whale rotate <-10,45,-20> translate <-5,-1,5>}

#end

#if (Ocean = on)

box {<50000,1.29,50000><-50000,1.3,-5000> pigment{red .7 green .8 blue 1 filter .75}
	normal{bumps 1 scale .1 }
	finish {specular 3 caustics 0.05 reflection 0.5}

	}


//FIXME
// set global atmospheric fog effect in the scene.
// at the fog distance, there will be 63% visibility
  fog {
    fog_type 1 // 1=constant, 2=ground_fog
    distance 12
    color MidnightBlue
// turbulence <TURBULENCE>
// turb_depth TURB_DEPTH
// omega OMEGA
// lambda LAMBDA
// octaves OCTAVES
// fog_offset FOG_OFFSET
// fog_alt FOG_ALT
  }

box {<5000,1.3,10><-5000,-5000,10.01>pigment{red 1 green 1 blue 1 filter .9}}

sky_sphere {S_Cloud1}

#declare Bubbles = 3000
#declare Count = 0
#declare Apple = seed(1313)
#while (Count < Bubbles)
	#declare Xdir = rand(Apple)
	#declare Ydir = rand(Apple)
	#declare Zdir = rand(Apple)

	#if (Xdir < 0.5) #declare Xdir = -1 #else #declare Xdir = 1 #end
	#if (Ydir < 0.5) #declare Ydir = -1 #else #declare Ydir = 1 #end
	#if (Zdir < 0.5) #declare Zdir = -1 #else #declare Zdir = 1 #end

	sphere {<(rand(Apple) * 2 * Xdir),(rand(Apple) * 2 * Ydir),(rand(Apple) * 2 * Zdir)>,
		(rand(Apple) * 0.01 )
	pigment{rgbft <.75,1,.75,.5,.25>}
	finish{phong 1 reflection .5 ior 1.5 refraction 1}
	}

	#declare Count = (Count + 1)
#end

#end


// create a TrueType text shape
text
{
  ttf          // font type (only TrueType format for now)
  "wildstyl.ttf",  // Microsoft Windows-format TrueType font file name
  "13",   // the string to create
  1,           // the extrusion depth
  0            // offset
  scale 0.4
    pigment{MidnightBlue}
    finish {ambient 0.75 phong 1}
    rotate <30,30,0>
    translate <2,-1.75,0>
}
