
// Glenn's Motion Blur POV-Ray Object File
// This file does not render.  #include "MoBlurFilt.inc" in another .pov file
// created 18-Apr-97  last update 25-Apr-97
// copyright 1997 Glenn McCarter

// Creates a "filter" for simulating motion blur
// the filter is simply an invisible box which distorts light rays
// Intended scale is English system (inches)
// Filter lies in +X+Y plane, origin at ground level
// Motion is blurred in the X-direction

// Declarations ---------------------------------------
// #declare these in your file to set the sizes:
//
// #declare BFX = 3        //height of blurred area
// #declare BFY = 3        //width of blurred area
// #declare BStrength = .8  //amount of blur (range 0 to 1)
//
// The +X and -X ends of the box are not blurred,
// only the center section, from top edge to bottom edge,
// are blurred.
// the entire blur is scaled in the X-direction according
// to the dimensions of the box, but always extends up and
// down to the full Y-dimension

#declare BlurFilterX =
		box { //motion blur filter
			<0,0,0>,<BFX,BFY,0.01>
			no_shadow
		  texture {
				pigment { color rgbf<1,1,1,1> } //final render
//				pigment { color rgbf<1,.8,1,.91> } //makes it visible for positioning
				normal {
					gradient x
					normal_map {
						[0.0 granite .001 ] //no blur
						[0.1 granite .001 ] //begin blur here
						[0.5 granite BStrength*.1	turbulence 1.3 scale <12,.8,.8> ] //this is the max blurred area
						[0.9 granite .001 ] //end blur here
						[1.0 granite .001 ] //no blur
						}
					scale <BFX,1,1>
				}
				finish { refraction 1 ior 1.33 }
			}
		}

// motion blur filter, circular with radius = BFX
#declare BlurFilterO =
		cylinder {
			<0,0,0>,<0,0,0.01>,BFX
			no_shadow
		  texture {
				pigment { color rgbf<1,1,1,1> } //final render
//				pigment { color rgbf<1,.8,1,.91> } //makes it visible for positioning
				normal {
					onion
			    slope_map { //sine wave
/*
						[0    <BStrength/2, BStrength> ]
						[0.25 <BStrength, 0> ]
						[0.5  <BStrength/2,-BStrength> ]
						[0.75 <0.0, 0> ]
						[1    <BStrength/2, BStrength> ]
*/
						[0    <.5, BStrength> ]
						[0.25 <1, 0> ]
						[0.5  <.5,-BStrength> ]
						[0.75 <0.0, 0> ]
						[1    <.5, BStrength> ]
					}
						scale <.25,.25,.25>
				}
				finish { refraction 1 ior 1.03 }
			}
		}

