// Glenn's POV-Ray Pencil Object File
// created 21-June-96 updated 5-Apr-97
// copyright Glenn McCarter

// A Dixon-Ticonderoga No.2 Pencil

#declare PencilLength = 6
#declare PencilFlatHeight = .3     // this parameter can be varied
#declare PFHR = PencilFlatHeight/2
#declare PencilFilletRadius = 1/4*PFHR  // creates the rounded corners
#declare PFR = PencilFilletRadius

#declare PencilShape =
  union { // this is the painted barrel
       box { <.1,-PFHR,-(PFHR-PFR)/1.732>,<PencilLength,PFHR,(PFHR-PFR)/1.732> rotate x*0 }
       box { <.1,-PFHR,-(PFHR-PFR)/1.732>,<PencilLength,PFHR,(PFHR-PFR)/1.732> rotate x*120 }
       box { <.1,-PFHR,-(PFHR-PFR)/1.732>,<PencilLength,PFHR,(PFHR-PFR)/1.732> rotate x*-120 }
       cylinder { <.1,(PFHR-PFR),(PFHR-PFR)/1.732>, <PencilLength,(PFHR-PFR),(PFHR-PFR)/1.732>, PFR }
       cylinder { <.1,-(PFHR-PFR),(PFHR-PFR)/1.732>, <PencilLength,-(PFHR-PFR),(PFHR-PFR)/1.732>, PFR }
       cylinder { <.1,(PFHR-PFR),-(PFHR-PFR)/1.732>, <PencilLength,(PFHR-PFR),-(PFHR-PFR)/1.732>, PFR }
       cylinder { <.1,-(PFHR-PFR),-(PFHR-PFR)/1.732>, <PencilLength,-(PFHR-PFR),-(PFHR-PFR)/1.732>, PFR }
       cylinder { <.1,0,(PFHR-PFR)/.866>, <PencilLength,0,(PFHR-PFR)/.866>, PFR }
       cylinder { <.1,0,-(PFHR-PFR)/.866>, <PencilLength,0,-(PFHR-PFR)/.866>, PFR }
       texture {
         pigment { color rgb<.94,.86,.28>} //Yellow }
         finish {ambient .35 specular 0.8  roughness 0.06 }
       }
       translate y*PFHR // move it up to ground level
  }
#declare PencilBarrelLettering =
  text {
    ttf "c:\Windows\Fonts\ARIAL.TTF",
    "DIXON  TICONDEROGA    No. 2",
    .2, 0
    scale <.15,.1,1> rotate x*90 translate <PencilLength-2.3,PFHR+.01,-.05>
    texture { pigment { color <0,0,0> } }
  }
#declare PencilMetal =
   difference {
     union {
       cylinder {<PencilLength,0,0>,<PencilLength+.5,0,0>, PFHR }
       torus {PFHR,PFHR/5 rotate z*90 translate <PencilLength+.06,0,0> }
       torus {PFHR,PFHR/5 rotate z*90 translate <PencilLength+.13,0,0> }
       torus {PFHR,PFHR/5 rotate z*90 translate <PencilLength+.2,0,0> }
       torus {PFHR,PFHR/5 rotate z*90 translate <PencilLength+.3,0,0> }
       torus {PFHR,PFHR/5 rotate z*90 translate <PencilLength+.37,0,0> }
       torus {PFHR,PFHR/5 rotate z*90 translate <PencilLength+.44,0,0> }
       texture {
			 	pigment { color rgb <0.95, 0.95, 0.95> }
			 	finish { ambient 0.1 brilliance 5 diffuse 0.6 metallic
					specular 0.80 roughness .01 reflection 0.6 }
			 }
		 }
     cylinder { <PencilLength+.1,-PFHR-.2,0>,<PencilLength+.1,PFHR+.2,0>,PFHR/6 texture { pigment { color <0,0,0> }}}
     cylinder { <PencilLength+.1,0,-PFHR-.2>,<PencilLength+.1,0,PFHR+.2>,PFHR/6 texture { pigment { color <0,0,0> }}}
     cylinder { <PencilLength+.4,-PFHR-.2,0>,<PencilLength+.4,PFHR+.2,0>,PFHR/6 texture { pigment { color <0,0,0> }}}
     cylinder { <PencilLength+.4,0,-PFHR-.2>,<PencilLength+.4,0,PFHR+.2>,PFHR/6 texture { pigment { color <0,0,0> }}}
   }
#declare PencilEraser =
   union {
     cylinder {<PencilLength+.5,0,0>,<PencilLength+.75,0,0>, PFHR }
     sphere { <0,0,0>, PFHR scale <.2,1,1> translate <PencilLength+.75,0,0>}
     texture {
         pigment { color rgb <.2, 0.8, 0.5> }
         finish {ambient .1 specular 0.2  roughness 0.8}
     }
   }
#declare Pencil =
 union { // add together all this stuff
   difference { // take away the wood cone from the barrel
     object { PencilShape }
     cone { // wood point
       <.3,0,0>,.12/3,<PencilLength+2,0,0>, 1.2
       translate y*PFHR // move it up to ground level
       texture { pigment { color rgb <1.0, 0.72, 0.25> }
       //Pine_Wood scale .1 rotate y*4
       }
       inverse
     }
   }
   cone { // graphite point
     <.1,0,0>,.12/10,<.3,0,0>, .12/3
     translate y*PFHR // move it up to ground level
     texture {
       pigment { color <.3,.3,.3> }
       finish {ambient .1 phong .99 phong_size 280 }
     }
   }
   object { PencilBarrelLettering translate y*PFHR } // move it up to ground level
   object { PencilMetal translate y*PFHR } // move it up to ground level
   object { PencilEraser translate y*PFHR } // move it up to ground level
 }
