#declare book_side= 
box { <-.05,-1,0> <.05,2,2> 
}
  
#declare leather_part =
union {
   object { book_side 
      rotate <0,-45,0>
      translate <-.43,0,.09>
   }
   object { book_side 
      rotate <0,45,0>
      translate <.43,0,.09> 
   } 
   difference {
      cylinder { <0,-1,0> <0,2,0> .5 }
      union {
         box { <-2,-3,.2> <2,3,2> }
         cylinder { <0,-2,0> <0,2,0> .4 }
      }
      scale <1,1,.3>
   }
   texture { 
      pigment{Brown}
      normal{
         bumps 1
         scale 0.25
      }
   }
}

// Pentagram stuff
//		p1
//	     p5    p2
//            p4 p3
// r1= radius of pentagram r2= radius of lines.
#declare r1=1
#declare r2=.025
// 360/5= 72
#declare p1=<0,r1,0>
#declare p2=vrotate(p1,<0,0,72>)
#declare p3=vrotate(p1,<0,0,144>)
#declare p4=<-1*p3.x,p3.y,p3.z>
#declare p5=<-1*p2.x,p2.y,p2.z>

#declare pgram = 
union {
   torus { r1,r2 
      rotate <90,0,0>
   }
   cylinder { p4 p1 r2 }
   cylinder { p1 p3 r2 }
   cylinder { p3 p5 r2 }
   cylinder { p5 p2 r2 }
   cylinder { p2 p4 r2 }
   texture { T_Gold_3C }
   translate <0,0,.9>
   scale .9
}

#declare shiny_spine = 
difference {
   union {
      torus {.5,.05 translate <0,1.8,0> }
      torus {.5,.05 translate <0,1.7,0> }
      torus {.5,.05 translate <0,-.7,0> }
      scale <1,1,.3>
   }
   box { <-2,-3,.2> <2,3,2> }
   texture { T_Gold_3C }

}

#declare words =
text {
   ttf "timrom.ttf" "My First Spell" 1, 0
   texture { T_Gold_3C }

   finish { reflection.25 specular 1 }
   rotate <0,0,-90>
   scale <.8,.3,.5>
   translate <-.2,1.5,-.2>
}

// #declare book =
union { 
   object { shiny_spine }
   object { words }
   object { pgram 
      rotate <0,-45,0>
      translate <1.7,0.5,.09>
   }
   object { leather_part }
   rotate <-20,0,0>
   scale .75
   translate <-1.9,2.3,-1.8>
}
