#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "glass.inc"

light_source {
   <2,8,-10>
   color White  // Light Color
}

background {
   color red 0 green 0 blue 1
}

camera {
    location <-2.5,1.25,-11.5>
//    location <0,40,0>
   direction <0, 0, 2>          // Which way we are looking <X Y Z>
   up <0, 1, 0>                 // Which direction is   +up <X Y X>
   right <4/3, 0, 0>            // Which way is      +right <X Y Z>
   look_at <0, 1.5, 10>  // Point camera at this point(center of view)
}

#declare moon = 
difference {
   sphere { <0,0,0> 1 }
   cylinder { <-2,0,-2> <-2,0,2> 2 
//     scale <.45,1,1>
      scale <2,1,1>
   }
}

#declare saturn =
union {
   sphere { <0,0,0> 1 }
   difference {
      cylinder { <0,-.01,0> <0,.01,0> 1.5 }
      cylinder { <0,-1,0> <0,1,0> 1.2 }
      rotate <0,0,23>
   }
}

#declare tine =
mesh { 
   // insert Diamond shape here.
   triangle { <0,0,0> <-.2,.2,0> <0,.2,-.2> }
   triangle { <0,0,0> <.2,.2,0> <0,.2,-.2> }
   triangle { <0,.2,-.2> <-.2,.2,0> <0,1,0> }
   triangle { <0,.2,-.2> <.2,.2,0> <0,1,0> }
}

#declare star =
union {
   object {tine}
   object {tine rotate <0,0,72>}
   object {tine rotate <0,0,144>}
   object {tine rotate <0,0,216>}
   object {tine rotate <0,0,288>}
   scale 1.5
}

#declare flame = cone { <0,1.1,0> .2 <0,1.5,0> .01 }

#declare sun =
union {
   sphere { <0,0,0> 1 }
   #declare X=0
   #while (X<360) 
      object { flame rotate <0,0,X> }
      #declare X=X+30
   #end // while
}

// #declare view =
union {
   object { moon translate <-3,3,0> }
   object { saturn translate <0,3,0> }
   object { star translate <-3,0,0> }
   object { sun }
   texture { Silver_Texture }
}
