#declare STEP_HEIGHT= .25
#declare STEP_WIDTH = 1.4 

#declare WALL_BRICK =
texture{
   pigment {Gray05}
   normal{
      crackle 0.6
      scale 0.6
   }
   finish{Dull}
}
// texture {T_Crack4}


#declare FLOOR_BRICK = texture{
   pigment {brick Gray05, Gray30}
   normal{
       brick 0.6
   }
   scale 0.14
//   finish{phong 0.8 phong_size 200}
   rotate <90,0,0>
   finish{Dull}
}


#declare steps = 
difference {
   union {
      #declare C=7
      #while (C>-1)
         box { <-12,-2,7> < 8-C,C,1> }
         #declare C=C-1
      #end
   }
   difference {
      sphere { <0,0,0> 1}
      box { <-2,-2,-1> <2,0,3> }
      scale <1.3,2.3,1.3>
      translate <-6,3.5,.5>
   }
}

// #declare stone_steps =
union {
   #declare C=6
   #while (C>-1)
      box { <8.2-C-STEP_WIDTH,C-.2,7> <8.2-C,C+STEP_HEIGHT-.2,.8> }
      #declare C=C-1
   #end
   box { <-12,7-.2,7> <8.2-7,+STEP_HEIGHT+7-.2,.8> }
   box { <-7.2,3.5,7> <-4.8,STEP_HEIGHT+3.5,.8>}
   texture {T_Grnt16}
}

#declare door_board = 
box { <0,0,0> <1,18,1> 
   texture { pigment { P_WoodGrain2A color_map { M_Wood1A }}
      rotate <90,0,0>
   }
   texture { pigment { P_WoodGrain2B color_map { M_Wood1B }}
      rotate <90,0,0>
   }
}

#declare door = 
union {
   object { door_board }
   object { door_board translate <1.03,0,0> }
   object { door_board translate <2.06,0,0> }
   object { door_board translate <3.09,0,0> }
   object { door_board translate <4.12,0,0> }
   translate <-9,2,6.9>
}

#declare Bump_Value = 1
#declare Pattern_Scale = .75

// #declare room = 
union {
   // floor
   plane {y, -1  
      texture { FLOOR_BRICK }
   }
   // left wall
   plane {x, -11 
     texture { WALL_BRICK }
   }
   // back wall
   difference {
      plane {z, 7 }
      object { door scale <1,1,2> }
      texture { WALL_BRICK }
   }
   object { steps 
      texture{ WALL_BRICK }
   }
   object { door }
}

// #declare water_spill =
blob {
   threshold .65
   sphere { <0,0,0> 3 1 }
   sphere { <0,0,-1.5> .8 1 }
   sphere { <-1,0,-1.5> .3 1 }
   sphere { <.8,0,-1.3> .7 1 }
   sphere { <.3,0,-2> .3 1 }
   sphere { <.3,0,-3> .3 1 }
   texture {
      pigment {color rgbt <0.2,0.2,0.4,.8>}
      normal {bumps 0.5 scale .8}
      finish {phong 1 reflection .5 ambient 0.1 diffuse 0.2}
   }
   scale <1,.1,1>
   translate <-4.5,-1,-2>
}
