#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
}
plane  {  y, -1.0  texture{ pigment { color Wheat }}}
background { color SeaGreen }
light_source{ <0, 60, -20> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#end

#debug "Fish1.pov.\n"


#declare fish1 =

 texture {
     pigment {
       spotted
       color_map {
         [ 0.000  color rgb<0.000, 0.000, 0.000> ]
         [ 1.000  color rgb<1.000, 1.000, 1.000> ]
       }
       scale .2
     }
   }

   texture {
     pigment {
       gradient y
       color_map {
         [ 0.000  color rgb<0.850, 0.850, 0.100> ]
         [ 0.200  color rgb<0.850, 0.850, 0.100> ]
         [ 0.625  color rgbf<0.925, 0.925, 1.000, 1.000> ]
         [ 0.750  color rgbf<0.925, 0.925, 1.000, 1.000> ]
         [ 0.875  color rgbf<0.925, 0.925, 1.000, 1.000> ]
         [ 1.000  color rgbf<0.925, 0.925, 1.000, 1.000> ]
       }
     }

   }

#declare FishBody =
union{
// Eye section
sphere { <0,0,0>,.5 scale < 1, .8, 1.35 >  translate <-.43, .35, 0 >  texture { pigment {color Mica}}  }
// Main Body
sphere { <0,0,0>,1  texture {    fish1 rotate < 90, 0, 0 >  }}
// Top Fin
cone { <0, 0, 0>,.25 < 0, .5, 0>.0 rotate < 150,45,180> translate <-.3, .75, 0 >texture { pigment {color Mica}}  }
// Top Back Fin
cone { <0, 0, 0>,.25 < 0, .55, 0>.2 rotate < 150,45,130> translate <.5, .5, 0 >texture { pigment {color Gray90 }}  }
// Middle Back Fin
cone { <0, 0, 0>,.25 < .55, 0, 0>.2 rotate < 0,0,0> translate <.6, 0, 0 >texture { pigment {color Gray90 }}  }
// Bottom Back Fin
cone { <0, 0, 0>,.25 < 0, .55, 0>.2 rotate < 140,45,20> translate <.6, -.4, 0 >texture { pigment {color Gray90 }}  }
 texture {    fish1 rotate < 90, 0, 0 >  }
     finish { diffuse 0.800  ambient 0.800  specular 0.0400  roughness 0.0100 phong 0.9 phong_size 60 metallic  }

scale <2.0, 1.0, 0.2>
}

#declare Fish1 =
object { FishBody
scale .5
// rotate < -45, 0, 0>
translate < 0,0,250>
}

#declare R1 = seed(10)
#declare SFish1 =
union{
 #declare X = -125  #while (X<= 250)
   #declare Z = -50 #while (Z<=50)
      #declare X2 = X/5 - ( (rand(R1) * 20))
      #declare Y2 = 5 + ( (rand(R1) ))
      #declare Z2 = Z/4 - ( (rand(R1) * 10 ) )
       object {Fish1 translate <X2, Y2, Z2>   }
   #declare Z=Z+50 #end
   #declare X=X+60 #end
}

object { SFish1 translate < 0, -3, -200>}
