#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
}
plane  {  y, -1.0  texture{ pigment { color Wheat }}}
background { color SeaGreen }
light_source{ <0, 60, -20> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#end

#debug "Fish3.pov.\n"


#declare fish3Tex =
   texture {
     pigment {
       waves turbulence 2
       color_map {
         [ 0.000  color rgb<0.350, 0.450, 0.400> ]
         [ 0.200  color rgb<0.550, 0.450, 0.400> ]
         [ 0.625  color rgb<0.2525, 0.1525, 0.4300> ]
         [ 0.750  color rgb<0.125, 0.025, 0.200> ]
         [ 0.875  color rgb<0.525, 0.525, 0.200> ]
         [ 1.000  color rgb<0.525, 0.425, 0.300> ]
       }
     }
   normal { dents .75 turbulence .75 scale <2,50,2> }
scale .55
   }

#declare Fish3 =
blob
{
  threshold 0.6
  sphere { < .3, 0, 0>, .25, 1 // nose
    scale < 1, .75, .25>
  }
  sphere { < 0, 0, 0>, 1, 1  // body center
    scale < 1, .75, .25>
  }
  sphere { < 0, .25, 0>, 1, 1  // body top
    scale < .5, .75, .25>
  }
  sphere { < 0, 0, 0>, 1, 1  // body bottom
    scale < .5, .75, .25>
  }
  #declare X=165 #while ( X <=195 )
    cylinder { <.25,0,0>, <.75,0,0>, .01, 1
      rotate < 0, 0, X >
    }
  #declare X=X+2 #end

  #declare X=25 #while ( X <=90 )
    cylinder { <0,.28,0>, <.7,.3,0>, .01, 1
      rotate < 0, 0, X >
      rotate < 0,200,0 >
      translate < -.2, 0, 0>
    }//top fin
    cylinder { <0,.28,0>, <.7,.3,0>, .01, 1
      rotate < 0, 0, X >
      rotate < 180, 0, 0 >
      rotate < 0,180,-10 >
      translate < -.1, .2, 0>
    }// bottom fin
  #declare X=X+3 #end
  texture { fish3Tex }
  finish { diffuse 0.800  ambient 0.8  specular 0.0100  roughness 0.0400   }
  scale < .5, .35, .5>
}

#declare SFish3=
union {
	#declare CNT=0
	#declare SF3=seed(3)
	#while (CNT< 15)
		#declare X2=(rand(SF3)*6)
		object {
			Fish3
			rotate <0,-X2,0>
			translate <(0-X2),(rand(SF3)*3),(rand(SF3)*3)>
			rotate <0,(-3*X2),0>
		}
		#declare CNT=CNT+1
	#end
}

object { SFish3  rotate <0, 180, 0 > scale .4 translate < -2, 0, -1 >}

//object { Fish3 scale 3 translate < 0, 3, -1>}
