#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
}
plane  {  y, -1.0  texture{ pigment { color Wheat }}}
background { color SeaGreen }
light_source{ <0, 60, -20> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#end

#debug "Fish4.pov.\n"

#declare fish4Tex =
   texture {
     pigment {
       gradient x turbulence .25
       color_map {
         [ 0.0  color OrangeRed ]
         [ 0.05  color Orange ]
         [ 0.1  color Mica ]
         [ 0.15  color Orange ]
         [ 0.2  color OrangeRed ]
         [ 0.25  color Orange ]
         [ 0.3  color Mica ]
         [ 0.35  color Orange ]
         [ 0.4  color OrangeRed ]
         [ 0.45  color Orange ]
         [ 0.5  color Mica ]
         [ 0.55  color Orange ]
         [ 0.6  color OrangeRed ]
         [ 0.65  color Orange ]
         [ 0.7  color Mica ]
         [ 0.75  color Orange ]
         [ 0.8  color OrangeRed ]
         [ 0.85  color Orange ]
         [ 0.9  color Mica ]
         [ 0.95  color Orange ]
         [ 1.0  color OrangeRed ]
       }
     }
}

#declare Fish4 =
blob
{
  threshold 0.6
  sphere { < .35, .2, 0>, .1, 1  // eye
    scale < 1, .75, 3>
    texture { pigment { color Mica }}
  }
  sphere { < .3, 0, 0>, .25, 1 // nose
    scale < 1, .75, .25>
  }
  sphere { < 0, 0, 0>, 1, 1  // body center
    scale < 1, .75, .25>
    texture { pigment { color Mica }}
  }
  sphere { < 0, .25, 0>, 1, 1  // body top
    scale < .5, .75, .25>
  }
  sphere { < 0, 0, 0>, 1, 1  // body bottom
    scale < .5, .75, .25>
  }
  #declare X=150 #while ( X <=219 )
    cylinder { <.25,0,0>, <.75,0,0>, .01, 1
    texture { pigment { color Silver }}
      rotate < 0, 0, X >
    }
  #declare X=X+2 #end

  #declare X=25 #while ( X <=90 )
    cylinder { <.7,1,0>, <0,0,0>, .01, 1
    texture { pigment { color Mica }}
      rotate < 0, 0, X * -.5>
      rotate < 0,0,-61 >
      translate < -.95, .95, 0>
    }//top fin
    cylinder { <.7,.88,0>, < 0,0,0>, .01, 1
    texture { pigment { color Mica }}
      rotate < 0, 0, X * -.5 >
      rotate < 180, 0, 0 >
      rotate < 0,0, 70 >
      translate < -.68, -.97, 0>
    }// bottom fin
  #declare X=X+5 #end

  texture { fish4Tex }
  finish { diffuse 0.8500  ambient 0.600  specular 0.0100  roughness 0.100 crand .1  }
  scale < 1, .75, 1 >
  scale .5
}

#declare SFish4=
union {
	#declare CNT=0
	#declare SF4=seed(4)
	#while (CNT< 20)
		#declare X2=(rand(SF4)*8)
		object {
			Fish4
			rotate <0,-X2,0>
			translate <(0-X2),(rand(SF4)*3),(rand(SF4)*4)>
			rotate <0,(-3*X2),0>
		}
		#declare CNT=CNT+1
	#end
}

object { SFish4 rotate <0, -120, 0 > scale .35 translate < -.5, 1, -1 >}

//object { Fish4 rotate < 0, 0, 0 > scale 4 translate < 0, 3, 0>}
