#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
}
plane  {  y, -1.0  texture{ pigment { color Wheat }}}
background { color SeaGreen }
light_source{ <0, 60, -20> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#end

#debug "Fish7.pov.\n"


#declare fish7Tex =
texture {  pigment  {    agate
    color_map    {
      [0.00 color rgb<0.886, 0.0847, 0.0345>]
      [1.00 color rgb<0.682, 0.853, 0.559>]
    }  }
  finish { ambient 0.4 diffuse 0.99  }
}
texture {  pigment  {    bozo    turbulence 1.03
    color_map   {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.61 color rgbf<0.969, 1.000, 1.000, 1.000>]
      [0.51 color rgbf<0.300, 0.000, 0.000, 0.627>]
      [1.00 color rgbf<0.000, 0.000, 0.000, 0.247>]
    } scale <0.1, 0.1, 0.1>  }
  finish {    ambient 0.4    diffuse 0.99    crand 0.1  }
}

#declare Fish7 =
blob
{
  threshold 0.6
  sphere { < .3, 0, 0>, .25, 1
    scale < 1, .75, .25>
  }
  sphere { < 0, 0, 0>, 1, 1
    scale < 1, .75, .25>
  }
  #declare X=165 #while ( X <=195 )
    cylinder { <.25,0,0>, <.75,0,0>, .01, 1
      rotate < 0, 0, X >
    }
  #declare X=X+2 #end

  #declare X=165 #while ( X <=195 )
    cylinder { <0,.28,0>, <.7,.43,0>, .01, 1
      rotate < 0, 0, X >
      translate < .25, 0, 0>
    }
    cylinder { <0,.28,0>, <.7,.43,0>, .01, 1
      rotate < 0, 0, X >
      translate < .25, 0, 0>
      rotate < 180, 0, 0 >
    }
  #declare X=X+2 #end
  texture { fish7Tex }
  finish { diffuse 0.900  ambient 0.800 phong 0.9 phong_size 60 metallic }
  scale <.25, .125, .25 >
  scale .4
}

/*
#declare SFish7=
union {
	#declare CNT=0
	#declare SF5=seed(5)
	#while (CNT< 35)
		#declare X2=(rand(SF5)*3)
		object {
			Fish7
			rotate <0,-X2,0>
			translate <(0-X2),(rand(SF5)*1.25),(rand(SF5)*2)>
			rotate <0,(-3*X2),0>
		}
		#declare CNT=CNT+1
	#end
}

object { SFish7 rotate < 0, -80, 0 > scale .4 translate < 1.7, -1, -2 >}
*/
//object { Fish7 rotate < 0, 0, 0 > scale 4 translate < 0, 4, 0>}
