#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
}
background { color SeaGreen }
plane  {  y, -1.0  texture{ pigment { color Wheat }}}
light_source{ <0, 60, -20> color White}
camera{ location <0.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#include "kelp.pov"
#include "kelp2.pov"
#include "anim.pov"
#include "fish1.pov"
#include "fish6.pov"


#end

#debug "shells.pov.\n"


#declare ShellPart =
        sphere { <0,0,0> 1
                 scale <1.15,1,1>
                 rotate <0, 90, 0>
               }

#declare Shell1 =
union {
 #declare X=0 #while (X<=1)
   object { ShellPart scale <(1-X)*2,(1-X)*2,(1-X)*2>
            translate <(1-X)*2, X*1.5, 0.0>
            rotate <0, 720*X, 0>
          }
 #declare X=X+.00139 #end
 scale .05
}
#declare Shell2 =
union {
 #declare X=0 #while (X<=1)
   object { ShellPart scale <(1-X)*2,(1-X)*2,(1-X)*2>
            translate <(1-X)*2, X*5, 0.0>
            rotate <0, 1440*X, 0>
          }
 #declare X=X+.00625 #end
scale .05
}

#declare SH1 = object { Shell1
                        texture { pigment { color GreenCopper }}
                        finish { ambient .4 diffuse .4 specular 0.09 roughness 0.5 crand .4 }
                      }
#declare SH2 = object { Shell1
                        texture { pigment { color Sienna  }}
                        finish { ambient .4 diffuse .4 specular 0.09 roughness 0.5 crand .4 }
                      }
#declare SH3 = object { Shell2
                        texture { pigment { color Wheat }}
                        finish { ambient .3 diffuse .4 specular 0.09 roughness 0.7 crand .6 }
                      }
#declare SH4 = object { Shell2
                        texture { pigment { color Tan }}
                        finish { ambient .4 diffuse .4 specular 0.09 roughness 0.5 crand .4 }
                      }

#declare ShellField=
union {
	#declare X=0
	#declare SF1=seed(60)
	#while (X < 7)
		object { SH1 translate <X,0,(rand(SF1)*8)>	}
		object { SH2 translate <X,0,(rand(SF1)*8)>	}
		object { SH3 translate <X,0,(rand(SF1)*8)>	}
		object { SH4 translate <X,0,(rand(SF1)*8)>	}
		#declare X=X+1
	#end
    scale .4
}

#declare BubTex =
texture {    pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
 finish {    ambient 0.2 diffuse 0.6 reflection .5 refraction 1 ior 1.33 specular 1 roughness 0.001}
}


#declare BubSpiral =
union {
#declare BS4=seed(14)
#declare X = 0 #while (X <= 70)
  object{
    sphere { <0,-2,0> .01 }
    translate < rand(BS4)/5, X/4, 0>
    rotate < 0, X * 30, 0>
    }
#declare X = X + 1 #end
texture { BubTex  }
}



object { BubSpiral translate < -2.5, 0, 0 > }
object { BubSpiral translate < -2.4, -1, 1 > }
object { BubSpiral translate < -2.3, 1, 3 > }

object { BubSpiral translate < 6, -2, 1 > }
object { BubSpiral translate < 6, -1, 0 > }

object { BubSpiral translate < 3.1, -5, -1 > }
object { BubSpiral translate < 3.2, -4, -2 > }
object { BubSpiral translate < 3.3, -3, -3 > }

object { BubSpiral translate < .4, -5, -.5 > }
object { BubSpiral translate < .3, -4, -.6 > }

object { ShellField translate < -.6, -1, -2.5 >}
object { ShellField translate < -.4, -1, -3 > }
object { ShellField translate < -2.5, -1, -.7 >}
object { ShellField translate < .5, -1, -.7 > }
object { ShellField translate < 2.5, -1, -.7 > }
