#ifndef (ABCDE)
#declare ABCDE = 0
// ==== Standard POV-Ray Includes ==== atmosphere
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

global_settings {
  adc_bailout 0.008922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            800
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.5
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    9
    recursion_limit  2
  }
}
background { color SeaGreen }
light_source{ <1, 50, 10> color White}
camera{ location <.5 , 0 ,-5>  normal { waves 0.9 } look_at <0.5 , .5 , 0.0>}
#include "kelp2.pov"
#include "fish1.pov"
#include "fish5.pov"

#end

#debug "Water.pov.\n"


#declare Sand =
plane  {  y, -1.0
 texture { pigment { bozo color_map {
                  [ 0.0 colour rgb <0.8,0.7,0.7> ]
                  [ 0.2 colour rgb <0.6,0.6,0.6> ]
                  [ 0.25 colour rgb <0.6,0.6,0.6> ]
                  [ 0.25 colour rgb <0.2,0.2,0.2> ]
                  [ 0.275 colour rgb <0.8,0.2,0.2> ]
                  [ 0.275 colour rgb <0.6,0.4,0.2> ]
                  [ 0.4 colour rgb <0.6,0.4,0.2> ]
                  [ 0.6 colour rgb <0.95,0.75,0.55> ]
                  [ 0.8 colour rgb <0.7,0.5,0.3> ] } scale 0.0001 }
                  normal { crackle 4.75 turbulence 1.75 scale <2,50,2> }
          scale <1,10,1> }
finish { ambient .3 diffuse .45 crand .5}
}

#declare SeaSurface =
plane  {  y, 40.0
 texture { pigment { ripples frequency 2
                  color_map {
                  [ 0.0   colour rgbf <0.0778,0.918,0.918,.5> ]
                  [ 0.2   colour rgbf <0.578,0.908,0.918,.7> ]
                  [ 0.25  colour rgbf <0.0678,0.918,0.918,.7> ]
                  [ 0.25  colour rgbf <0.0678,0.918,0.918,.8> ]
                  [ 0.265 colour rgbf <0.478,0.918,0.918,.8> ]
                  [ 0.275 colour rgbf <0.578,0.918,0.918,.7> ]
                  [ 0.4   colour rgbf <0.478,0.818,0.918,.6> ]
                  [ 0.6   colour rgbf <0.578,0.918,0.918,.8> ]
                  }}
      normal { ripples 2.75 turbulence 1.75  }
      scale <12,3,3>
    }
 finish{ specular .25 roughness .75 ambient .2 diffuse .5 crand .005 reflection .025 refraction 1.0}
hollow
}

sky_sphere{pigment {gradient y color_map { [0.0 color DarkTurquoise ] [.5 color Turquoise ] }}}

 atmosphere {
    type 4
    samples 20
    distance 40
    scattering 0.08
    aa_level 4
    aa_threshold 0.1
    jitter 0.2
  }

object { Sand }
object { SeaSurface }
