/*
  BLOODY SCHOOL   (bloody.pov)
  Copyright 1997 Martin Vilcans (marvil@algonet.se)
  For the Internet Raytracing Competition
*/

#version 3.0

#declare do_door     = 1
#declare do_doorknob = 1
#declare do_text     = 1
#declare do_person   = 1
#declare do_floortex = 1
#declare do_glasses  = 1
#declare do_lockers  = 1
#declare do_puddle   = 1
#declare do_moonhalo = 1

// I don't use the following...
#declare do_doorhalo = 0
#declare do_dust     = 0
#declare do_arealight= 0

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"

#include "Door.inc"
#include "glasses.inc"
#include "LockerDoor.inc"
#include "Puddle.inc"

global_settings {
  max_trace_level 30
  assumed_gamma 2.2
}

// camera selection
#declare cam = 6

#if(cam=1)
camera {                 // perspective view
  location < -1500, 1000, -2500>
  angle 70
  look_at <2000, 1000, 0>
}
#end
#if(cam=2)
camera {              // look at the door knob
  location < 100, 700, -200>
  angle 35
  look_at <370, 1000, -20>
}
#end
#if(cam=3)
camera {                // look at the lockers
  location < 3000, 1700, -4300>
  angle 60
  look_at <3000, 1400, 0>
}
#end
#if(cam=4)
camera {
  direction z
  rotate x*20
  rotate y*60
  rotate x*-30
  rotate z*20
  location < -1200, 70, -2100>
  angle degrees(atan2(18,24)*2)         // similar to a 24 mm wide angle
/*  focal_point <-900,0,-1750>
  blur_samples 8
  aperture 1*/
}
#end
#if(cam=5)
camera {
  location < 6000, 1200, -2100>
  look_at < 7000, 1200, 0 >
  angle degrees(atan2(18,24)*2)         // similar to a 24 mm wide angle
}
#end
#if(cam=6)
camera {
  direction z
  rotate x*21
  rotate y*58.5
  rotate x*-30
  rotate z*15
  location < -1150, 70, -2100>
  angle degrees(atan2(18,24)*2)         // similar to a 24 mm wide angle
/*  focal_point <-900,0,-1750>
  blur_samples 8
  aperture 1*/
}
#end

//************************************************************//
#declare T_Wall = texture {
//  pigment { color < 0.5 0.2 0.0 > }
  pigment { color < 0.5 0.3 0.1 > }
  normal { bumps 0.1 scale 1 }
  finish {
//    reflection 0.2
//    phong 0.9 phong_size 60
    specular 0.9 roughness 0.05
  }
}

#declare T_FarWall = texture {
  pigment { color White }
  normal { bumps 0.1 scale < 1000, 1000, 1 > }
  finish {
    specular 0.6 roughness 0.05
  }
}

#declare LeftWall = intersection {
  union {
    difference {
/*      intersection {
        plane {  z,   0 }      // inside part of wall
        plane { -z, 100 }
        plane {  x,6000 }
      }*/
      box { <-10000, 0, -100> <6000, 3000, 0> }
      box {           // cut a hole for the door
        <-500,-1,-101> < 500, 2100, 100>
      }
      texture { T_Wall }
    }
#if (do_door)
    object { Door translate y*10 }
#end
    plane { -x, -1990 pigment { White } }
  }
  plane { x,6000 }
  plane {-z, 100 }
}

#declare Window = intersection {
  box { <   0,   0,  50> < 800,1000, 100> }
  box { <  50,  50,   0> < 750, 950, 105> inverse }
  texture {
    pigment { color White }
    finish {
      reflection 0.1
      specular 0.3
      roughness 0.05
    }
  }
}

#declare FarWall = union {
  intersection {
    box { < 0,0,-10000 > < 100,3000,100000 > }
/*    plane { -x   0 }
    plane {  x 100 }*/
    box { < -5, 1000, -200> < 105, 2000, -1000 > inverse }
    box { < -5, 1000,-1200> < 105, 2000, -2000 > inverse }
    texture { T_FarWall }
    pigment { color White }
  }
  object { Window rotate y*90 translate <  0, 1000, -200 >}
  object { Window rotate y*90 translate <  0, 1000,-1200 >}
  translate x*8000
}

#declare T_Floor = texture {
#if (do_floortex)
  pigment {
    granite
    turbulence 0.8
    color_map {
      [0.0, 0.5  color White*0.5 color White*0.5]
      [0.5, 0.6  color White*0.6 color White*0.0]
      [0.6, 1.0  color White*0.6 color White*0.9]
    }
    scale 200
  }
  finish {
    //diffuse 0.5
    ambient 0.0
    reflection 0.2
  }
  normal {
    bumps 0.2 scale 2000
  }
#else
  pigment {
    checker color Blue color Blue*0.5
    scale 500
  }
#end
}

#declare T_Ceiling1 = texture {
  pigment { color White }
  finish { brilliance 1.5 }
}

#declare T_Ceiling2 = texture {
  pigment { color rgb < 1.0, 1.0, 0.85 >}
  normal {bumps 0.1 scale 4 }
}

#declare BigTriangle = triangle {
  <     0, 0,     0>
  <100000, 0,     0>
  <     0, 0,100000>
}

object {                // The floor
  BigTriangle
  rotate y*-90
  translate < 8100, 0, -5000 >
  texture { T_Floor }
}

object {            // Ceiling
  BigTriangle
  rotate y*-90
  translate < 8100, 2600, -5000 >
  texture {
    brick texture {T_Ceiling1}, texture {T_Ceiling2}
    brick_size < 500, 700, 1800 >
    rotate z*90
    mortar 20
  }
}

object {            // Ceiling in the principal's office
  BigTriangle
  rotate y*-90
  translate < 5995, 2500, 5 >
  pigment { color White }
}

/////////////////////////////////////////////////////


// the sky
box {
  <0,0,-1> <1,1,1>
  pigment {
    gradient y
    color_map {
      [ 0.0 color rgb < 0.0, 0.0, 0.25 > ]
      [ 0.3 color rgb < 0.0, 0.0, 0.18 > ]
      [ 1.0 color rgb < 0.0, 0.0, 0.00 > ]
    }
  }
  finish {
    ambient 1.0
    diffuse 0.0
  }

  scale < 1,10000,100000 >
  translate x*20000
}

#declare Shadow = box {
  < 0,0,0 > < 900,1800,5>
  pigment {
      image_map {
      png "shadow.png"
      filter all 1.0
      once
    }
//    color White
    scale <900,1801,1>
  }
}

#if (do_person)
object {
  Shadow
  translate <-500,0,600>
}
#end //do_person

object { Shadow translate < 7000,0,500 > }

object {
  LeftWall
}

object {
  FarWall
}

#if (do_glasses)
object {
  Glasses
  rotate x*180
  translate y*glasses_yoffs
  rotate x*-glasses_angle
  scale 2
  rotate y*-80
  translate < -1000, 0, -1950 >
}
#render concat("angle=", str(glasses_angle,10,4))
#end // do_glasses

#if (do_puddle)
object {
  Puddle
  translate < -850, 0, -1750 >
}
#end //do_puddle

// the lockers...
#declare LockerColumn = union {
  object { LockerDoor translate < 0, 200        , -500 > }
  object { LockerDoor translate < 0, 200 + 710*1, -500 > }
  object { LockerDoor translate < 0, 200 + 710*2, -500 > }
}

  difference {
    box {
      <    0,    0, -500 > < 5*440, 2350,    0 >
    }
    box {
      <   -1,   -1, -501 > < 5*440+1, 100, -440 >
    }
    texture { T_LockerDoor }
    translate x*1000
  }

#if (do_lockers)
union {
  object { LockerColumn                  translate x*(220 + 0*440) }
  object { LockerColumn scale < -1,1,1 > translate x*(220 + 1*440) }
  object { LockerColumn                  translate x*(220 + 2*440) }
  object { LockerColumn scale < -1,1,1 > translate x*(220 + 3*440) }
  object { LockerColumn                  translate x*(220 + 4*440) }
  translate x*1000
}
#end


/////////////////////////
// Let there be light...
#if (1)
light_source {
//    <-1500,2500,-1800>
//    <2500,2000,-1800>
    <-1500,1500,-2000>
    color White
    fade_distance 1500
    fade_power 3
}
#end
#if (0)
light_source {
    <-1000,2500,-1800>
    color White
    spotlight
    point_at < -1000,0,-1800>
    radius 10
    falloff 20
    tightness 10
//    fade_distance 1000
//    fade_power 1
}
#end

// light behind the corner...
light_source {
    <6100,400,4500>
    color White
    fade_distance 1000
    fade_power 1.3
}

// the moon
light_source {
    < 20000*6, 3600*6, -1000*6 >
    color < 1.00 1.00 1.00 > * 1
}
sphere {
    < 20000, 3000, -600 > 400
    texture {
      pigment { color < 1.00 0.95 0.80 > }
      finish {
        ambient 1.0
      }
    }
    no_shadow
}

#if (do_moonhalo)
  sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      poly
      exponent 2.0
      color_map {
        [ 0 color rgbt <1.0, 1.0, 1.0, 1> ]
        [ 1 color rgbt <1.0, 1.0, 0.0, 0> ]
      }
      samples 10
    }
    hollow
    scale < 3000,3000,3000 >
//    translate <1000,1000,-500>
    translate <20000,3000,-600>
  }
#end //do_moonhalo

#if (do_dust)
  box {
    < 0,0,0> <1,1,1>
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      dust
      dust_type 1
      spherical_mapping
      constant
      color_map {
        [ 0 color rgbt <1.0, 1.0, 1.0, 0.7 > ]
        [ 1 color rgbt <1.0, 1.0, 1.0, 0.7 > ]
      }
      aa_level 3
      aa_threshold 0.2
      jitter 0.1
      samples 10        //50
    }
    hollow
    scale <16000,2000,5000 >
    translate <-8000,0,-5000 >
  }
#end // do_dust

#if (do_doorhalo)
  sphere {
    < 0,0,0> 1
    pigment { color rgbt <1, 1, 1, 1.0> }
    halo {
      attenuating   //dust
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <0.9, 1.0, 1.0, 1.0 > ]
        [ 1 color rgbt <0.9, 1.0, 1.0, 0.0 > ]
      }
//      aa_level 3
 //     aa_threshold 0.2
   //   jitter 0.1
      samples 10        //50
    }
    hollow
    scale <1500,1500,500 >
//    translate <-750,1000,-500 >
    translate <0,1500,0 >
  }
#end // do_doorhalo

// light behind the door
#if (do_arealight)
light_source {
  <-1500,1000,2000>
  color < 0.9 1.0 1.0 >*1
  area_light x*1500 y*1, 8, 1
  adaptive 1
  fade_distance 3000
  fade_power 1
}
#else
light_source {
    <0,1500,2000>
    color < 0.9 1.0 1.0 >
}
#end
