// Door.inc

#declare DoorKnob = difference {
  union {
    union {
      cylinder { <  0,  0,  0 > <  0, 45, 0 > 10 }
      sphere {   <  0, 45,  0 > 25 }
      intersection {
        cone {     <  0,  0,  0 > 25 <  0, 20, 0 > 5 }
        plane { y*1 5 }
      }
      texture { T_Chrome_3B }
    }
    cylinder {
      <  0, 45,  0 > <  0, 70, 0 > 8
      finish { F_MetalB }
      pigment { color rgb < 1.00 1.00 0.40 > }
    }
  }
  box { < -0.5, 60, -3 > <  0.5, 71, 3 > }  // key hole
}

#declare Door = union {
  difference {
    box {                         // door
      < -500,  0,  0 > < 500, 2100, 50 >
      texture {
        T_Wood32
        rotate x*90
        scale 100
        finish {
          reflection 0.2
          phong 0.4 phong_size 60
        }
      }
    }
    box {                         // cut a hole for the window
      < -400,  1100, -5 > < 400, 1900, 55 >
    }
  }

#if (do_doorknob)
  object { DoorKnob scale 1.5 rotate x*-90 translate < 370, 1000, 0 > }
#end

  box {                         // window
    <-400,1100,22.5> <400,1900,27.5>
    texture {
      pigment { color rgbft < 1.0, 1.0, 1.0, 0.0, 0.5 > }
      finish {
        phong 0.7 phong_size 60
        reflection 0.2
      }
      normal { bumps 0.9 scale 500 }
    }
  }

#if (do_text)
  text {
    ttf "c:\windows\fonts\Verdana.ttf",
    "PRINCIPAL",
    0.5, 0
    scale < 120,120,1>
    translate < -300, 1500, 22>
    pigment { color Black }
    bounded_by { box { < -400,1500,21> < 400,1620,23 > } }
  }
#end    // do_text
}
