// Glasses.inc

#declare r1 = 0.5       // radius for metallic parts
#declare r2 = 1.0       // radius for plastic parts
#declare r3 = 0.7       // minor radius for eyes

#declare offs = sin(radians(45)) * 20
#declare glasses_yoffs = 20 + r3
#declare glasses_angle = degrees(atan2(glasses_yoffs-offs-r2,90))
#declare front_r =  70   // radius for the front side of the lens
#declare back_r  = 100   // radius for the back side of the lens
#declare bend_r  = 2.0   //


#declare T_EyeGlass = texture {
  pigment { color rgbf<1.0, 1.0, 1.0, 0.9 > }
  finish {
    specular 0.5
    roughness 0.02
    ambient 0
    diffuse 0
    refraction on
    reflection 0.1
    ior 1.5
  }
}

#declare T_GlassesMetal = texture {
  pigment { color White }
  finish { F_MetalD }
}

#declare T_GlassesPlastic = texture {
  pigment { color rgbt < 0.1 0.9 0.3 0.6 > }
  finish {
    ior 1.5
  }
}

#declare rot = 20
#declare Half1 =
  union {
    torus { 20 r3 rotate x*90 }         // eye
    union {
      intersection {
        torus { bend_r r1 }
        plane {  x 0 }
        plane {  z 0 }
        translate x*bend_r
      }
      union {
        cylinder {
          <0 0 0> <0 0 90> r1
        }
        cylinder {
          <0, -r1, 0> <0, r1, 0> 1      //gngjrn
        }
        intersection {            // the ear
          torus { 20 r1 rotate < 90 90 0> }
          plane { -z 0 }
          translate z*90
          translate y*-20
        }
        intersection {            // plastic coating for the ear
          torus { 20 r2 rotate < 90 90 0> }
          plane { -z 0 }
          translate z*90
          translate y*-20
          texture { T_GlassesPlastic }
        }
        rotate y*rot
      }
      translate < -offs-bend_r, offs, bend_r >
    }
    intersection {          // the lens
      sphere {
        <0,0,0> front_r
        translate z*(sqrt((front_r*front_r) - (20*20)) - 1)
      }
      sphere {
        <0,0,0> back_r
        translate z*(sqrt((back_r*back_r) - (20*20)) + 1)
        inverse
      }
      sphere { < 0,0,0 > 20 }
      texture { T_EyeGlass }
    }
    texture { T_GlassesMetal }
  }

#declare rot = 0
#declare Half2 =                // copy of Half1 with different rot
  union {
    torus { 20 r3 rotate x*90 }         // eye
    union {
      intersection {
        torus { bend_r r1 }
        plane {  x 0 }
        plane {  z 0 }
        translate x*bend_r
      }
      union {
        cylinder {
          <0 0 0> <0 0 90> r1
        }
        cylinder {
          <0, -r1, 0> <0, r1, 0> 1      //gngjrn
        }
        intersection {            // the ear
          torus { 20 r1 rotate < 90 90 0> }
          plane { -z 0 }
          translate z*90
          translate y*-20
        }
        intersection {            // plastic coating for the ear
          torus { 20 r2 rotate < 90 90 0> }
          plane { -z 0 }
          translate z*90
          translate y*-20
          texture { T_GlassesPlastic }
        }
        rotate y*rot
      }
      translate < -offs-bend_r, offs, bend_r >
    }
    intersection {          // the lens
      sphere {
        <0,0,0> front_r
        translate z*(sqrt((front_r*front_r) - (20*20)) - 1)
      }
      sphere {
        <0,0,0> back_r
        translate z*(sqrt((back_r*back_r) - (20*20)) + 1)
        inverse
      }
      sphere { < 0,0,0 > 20 }
      texture { T_EyeGlass }
    }
    texture { T_GlassesMetal }
  }


#declare Glasses = union {
  intersection {
    object { Half1 }
    box {               // the crack
      < 0,-20-r3,-10 > < 0.1,20-r3,10 >
      rotate z*100
      inverse
      texture {
        T_EyeGlass
        pigment { color rgbf<1.0, 1.0, 1.0, 0.3 > }
        finish {
          ior 1.0
          roughness 0.3
        }
      }
    }
    scale < -1,1,1 >
    translate x*25
  }
  object { Half2 translate x*-25 }

  intersection {        // the nose part
    union {
      torus { 5 r1 texture { T_GlassesMetal } }
      intersection {
        torus { 5 r2 texture { T_GlassesPlastic } }
        plane { x 0 rotate y*-45 }
        plane {-x 0 rotate y*45 }
      }
      rotate x*90
    }
    plane { -y 0 }
    rotate x*-30
    translate y*2
  }
}
