/* export objects :
      Brain
      Eye
      BrainCritter, union of the above

   dimensions :
      Eye, < 2.6 radius sphere, looking +x
      Brain, front at +x, box <-1.35,-.5,1.45> <2.15,1,1.45>
      Critter, <-13.5,-10,14.5> <21.5,10,14.5>

   Critter and eye dimensions in centimeters (Brain scale 10 too)
*/

#declare BrainTexture = texture
{
   pigment
   {
      agate
      color_map
      {
         [0 color rgb<0.7,0.65,0.5>]
         [0.92 color rgb<0.7,0.65,0.5>]
         [1.0 color rgb<0.85,0.45,0.45>]
      }
      scale 0.45
   }
   normal
   {
      bumps 0.7
      scale 0.07
   }
   finish
   {
      brilliance 0.6
      phong 0.75
      ambient 0.3
      diffuse 0.75
   }
}

#declare Brain = object
{
   union
   {
      // ---------------- linker hersenhelft ---------------------
      #declare posx = 2.15
      #declare negx = 1.35
      #declare posy = 1
      #declare negy = 0.5
      #declare posz = 1.25
      #declare negz = 0.4
      object
      {
         #include "octelips.inc"
         texture {BrainTexture}
         translate <0,0,0.2>   
      }
      // ---------------- rechter hersenhelft ---------------------
      #declare posx = 2.15
      #declare negx = 1.35
      #declare posy = 1
      #declare negy = 0.5
      #declare posz = 0.4
      #declare negz = 1.25

      object
      {
         #include "octelips.inc"
         texture {BrainTexture}
         translate <0,0,-.2>   
      }
      // ---------------- hypothalimus ? -----------------------

      #declare posx = 1
      #declare negx = 0.6
      #declare posy = 0.5
      #declare negy = 0.75
      #declare posz = 1
      #declare negz = 1
      object
      {
         #include "octelips.inc"
         texture {BrainTexture}
         translate <-0.5,-0.2,0>   
      }
   }
}

// -------------------- oogjes eronder -------------------

#declare EyeWhite = texture
{
   pigment {color White}
   finish {phong 1 ambient 0.3}
}

#declare EyeVeins = texture
{
   pigment {
      radial
      frequency 15
      turbulence 0.6
      color_map
      {
         [0 color White]
         [0.88 color White] 
         [0.94 color rgb<1, 0.85, .85>]
         [1.0 color rgb<0.90, 0.65, 0.65>]
      }
      rotate <0,0,90>
   }
   finish {phong 1 ambient 0.3}
}

#declare EyeWhiteVeins = texture
{
   gradient x
   texture_map
   {
      [0 EyeVeins scale 1/5]
      [0.9 EyeVeins scale 1/5]
      [0.9 EyeWhite]
      [1 EyeWhite]
   }
   scale 5
   translate <-2.5,0,0>
}

#declare WhiteEyeBody = object
{
   difference
   {
      object
      {
         sphere {<0,0,0> 2.5}
         texture {EyeWhiteVeins}
      }
      object
      {  
         cylinder {<0,0,0> <10,0,0> 0.75}
         pigment {color Black}
      }
   }
}

#declare Iris = object
{
   disc {<0,0,0> <1,0,0> 0.75 0.3}
   pigment
   {
      radial
      frequency 20
      color_map
      {  
         [0 color rgb <0,0.30,0.92>]
         [1 color rgb <0,0,0>]
      }
      rotate <0,0,90>
   }
   finish
   {
      ambient 0.15
      diffuse 0.85
      brilliance 0.5
   }
}

#declare LensGlass = texture
{
   pigment {color rgbf<1,1,1,0.80>}
   finish {phong 1}
}

#declare TopLens = object
{
   intersection
   {
      sphere {<0,0,0> 1.6}
      sphere {<0,0,0> 1.55 inverse}
      box {<0,-1.6,-1.6> <1.6,1.6,1.6>}
   }
   texture {LensGlass}
}


#declare Eye = object
{  
   union
   {
      object { WhiteEyeBody }
      object { Iris translate <2.30,0,0>}
      object { TopLens translate <1.00,0,0>}
   }
}

// ------------------ all the stuff together ----------------------

#declare BrainCritter = object
{
   union
   {
      object {Brain scale 10}    // zo is ie ongeveer in centimenters
      object {Eye translate <17,-7.5, -4>}      // right eye
      object {Eye translate <17,-7.5, 4>}       // left eye
   }
}


