#version 3.0

#declare Glass1 = texture
{
   pigment {color rgbf<1,1,1,0.92>}
   finish {refraction 1 
      ior 1.33
      diffuse 0.90
      reflection 0.15
      ambient 0
      phong 0.77
   }
}

#declare WaterFlat = texture
{
   pigment { color rgbf <0.95,1,0.90,0.95> }
   finish 
   {
      refraction 1
      // ior 1.51
      diffuse 0.2
      ambient 0
   }
}

#declare WaterWave = texture
{
   pigment { color rgbf <0.95,1,0.90,1> }
   normal 
   {
      ripples 0.5
      scale 30
      frequency 7
   }
   finish 
   {
      refraction 1
      ior 1.51
      reflection 0.4
      diffuse 0.2
      ambient 0
      phong 1
   }
}


#declare GlassHull = object
{
   merge
   {
      difference
      {
         cylinder {<0,0,0> <0,55,0> 25.5}
         cylinder {<0,3,0> <0,56,0> 25}
      }
      torus {25.25,0.25 translate <0,45,0>}
   }
   texture {Glass1}
}

#declare WaterInside = object 
{
   intersection
   {  
      object
      {
         plane {<0,1,0> 45}
         texture {WaterWave}
      }
      object
      {
         cylinder {<0,3.01,0> <0,46,0> 24.99}
         texture {WaterFlat}
      }
   }
}

#declare Canister = object
{
   union
   {
      object {GlassHull}
      object {WaterInside}
   }
}


