#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "ctwoods.inc"
#include "stones.inc"
#include "applres.inc"
#include "robo1.inc"
#include "book.inc"
#include "chair.inc"
#include "robo2.inc"
#include "cup.inc"
#include "robo3.inc"
#include "robo4.inc"
#include "robo5.inc"
#include "robo6.inc"
#include "robo7.inc"
#include "robo8.inc"

#declare Veneer = texture { T_Wood15 finish { phong 0.2 reflection 0.1 } scale <3,3,0.5> }

#declare Leather = texture { pigment {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgb <0.22, 0.1, 0.04>]
      [1.00 color rgb <0.35, 0.1, 0.05>]
    }
    scale .3
 }
  normal {  crackle 0.1
slope_map {
	[0 <0,1>]
	[.05 <1,0>]
	[.95 <1,0>]
	[1  <0,-1>]
	}

 turbulence .1  scale .1 }
  finish { specular 0.45 }
}

#declare Cardboard = texture {
pigment {color red 1 green 0.95 blue 0.5}
  normal { bumps scale 0.01 }
}

camera {
location <6,3,-8>
look_at 0
//location <19,0,-7.5>
//look_at <0,0,-7.5>
//location <0,0,-200>
//look_at 0
//location <-5,4,-2>
//look_at <-6.5,4,-0.5>
}
background {color Blue}

light_source {
<-70, 30, -65>
color rgb 1.2
/* area_light <0,0.5,0>, <0.5,0,0>, 5,5
adaptive 1
jitter */
}

light_source {
<0, 15.9, -7.5>
color rgb 0.6
/* area_light <40,0,0>, <0,0,45>, 8,8
adaptive 1
jitter  */
}

//desktop
box { <-10,-0.5,-5>, <10,0,5> texture {Veneer} }
//modesty panel
box { <9, -0.5, -4>, <-9, -10, -3.5> texture {Veneer rotate <90,0,0> } }
// rest of room
// box { <-20, 16, 15>, <20, -10, -30> }
box { <-20,-10,15>, <20,-11,-30>
pigment
 {granite
  turbulence 0.4
  color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.000>
                    color rgbf <0.769, 0.686, 0.592, 0.000>]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.000>
                    color rgbf <0.843, 0.753, 0.718, 0.000>]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.000>
                    color rgbf <0.780, 0.667, 0.561, 0.000>]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.000>
                    color rgbf <0.741, 0.659, 0.576, 0.000>]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.000>
                    color rgbf <0.729, 0.502, 0.451, 0.000>]
   }
 }
 }

box { <-20.01, 16, 15>, <-19.99, -10, -30>
  no_shadow
  texture {T_Glass1}
}

difference {
box { <-20.25, 16, 15>, <-19.75, -10, -30>
pigment {color White}
normal {bumps scale <0.01,2,0.01>} hollow } 
box { <-15,12.5,2>, <-25, 0.5, 13> }
box { <-15,12.5,-1.5>, <-25, 0.5, -13.5> }
box { <-15,12.5,-17>, <-25, 0.5, -29> }
}
box { <-20, 16, -30>, <20, -10, -30>
pigment {color White}
normal {bumps scale <0.01,2,0.01>} hollow } 
box { <-20, 16, 15>, <20, -10, 15>
pigment {color White}
normal {bumps scale <0.01,2,0.01>} hollow } 
box { <20, 16, 15>, <20, -10, -30>
pigment {color White}
normal {bumps scale <0.01,2,0.01>} hollow }
box { <-20, 16, 15>, <20, 17, -30>
pigment {color White}
normal {bumps scale <0.01,0.01,2>} hollow }

//lights in ceiling
box { <-5,15.99,0>, <-15,17,-5> pigment {color White} finish { ambient 1 diffuse 0 } }
box { <-5,15.99,5>, <-15,17,10> pigment {color White} finish { ambient 1 diffuse 0 } }
box { <-5,15.99,-10>, <-15,17,-15> pigment {color White} finish { ambient 1 diffuse 0 } }
box { <-5,15.99,-20>, <-15,17,-25> pigment {color White} finish { ambient 1 diffuse 0 } }
box { <5,15.99,5>, <15,17,10> pigment {color White} finish { ambient 1 diffuse 0 } }
box { <5,15.99,-10>, <15,17,-15> pigment {color White} finish { ambient 1 diffuse 0 } }
box { <5,15.99,-20>, <15,17,-25> pigment {color White} finish { ambient 1 diffuse 0 } }
box { <5,15.99,0>, <15,17,-5> pigment {color White} finish { ambient 1 diffuse 0 } }


//window
box { <-20.5,0.5, -1.5>, <-19.5, 1.5, -13.5> texture {T_Wood1 scale 0.15} }
box { <-20.5,12.5,-1.5>, <-19.5, 13.5, -13.5> texture {T_Wood1 scale 0.15} }
box { <-20.5,13.5,-12.5>, <-19.5, 0.5, -13.5> texture {T_Wood1 scale 0.15 rotate 90*x } }
box { <-20.5,13.5,-1.5>, <-19.5, 0.5, -2.5> texture {T_Wood1 scale 0.15 rotate 90*x } }

box { <-20.249999,1.5,-7.25>, <-19.759999,12.5,-7.75> texture {T_Wood1 scale 0.15 rotate 90*x } }
box { <-20.25,7.25,-2.5>, <-19.75,6.75,-12.5> texture {T_Wood1 scale 0.15} }


//window
box { <-20.499999999999,0.5, 2>, <-19.499999999, 1.5, 13> texture {T_Wood1 scale 0.15 rotate 0.5*y translate <0,3,0> } }
box { <-20.499999999999,12.5,2>, <-19.499999999, 13.5, 13> texture {T_Wood1 scale 0.15 rotate 1*y translate <0,15,0> } }
box { <-20.5,13.5,12>, <-19.5, 0.5, 13> texture {T_Wood1 scale 0.15 rotate 0.75*y rotate 90*x translate <0,0,14.5>} }
box { <-20.5,13.5,2>, <-19.5, 0.5, 3> texture {T_Wood1 scale 0.15 rotate 0.875*y rotate 90*x translate <0,0,4.5>} }

box { <-20.249999,1.5,7.75>, <-19.759999,12.5,8.25> texture {T_Wood1 scale 0.15 rotate 0.75*y rotate 90*x translate <0,0,10>} }
box { <-20.25,7.25,3>, <-19.75,6.75,12> texture {T_Wood1 scale 0.15 rotate 1*y translate <0,9,0> } }

//window
box { <-20.5,0.5, -29>, <-19.5, 1.5, -17> texture {T_Wood1 scale 0.15} }
box { <-20.5,12.5,-29>, <-19.5, 13.5, -17> texture {T_Wood1 scale 0.15} }
box { <-20.5,13.5,-18>, <-19.5, 0.5, -17> texture {T_Wood1 scale 0.15} }
box { <-20.5,13.5,-29>, <-19.5, 0.5, -28> texture {T_Wood1 scale 0.15} }

box { <-20.249999,1.5,-22.75>, <-19.759999,12.5,-23.25> texture {T_Wood1 scale 0.15} }
box { <-20.25,7.25,-17>, <-19.75,6.75,-29> texture {T_Wood1 scale 0.15} }

//pieces of paper
box { <0,0,0>, <1,1,-0.001>
  pigment { image_map { tga "hw.tga" } scale <-1,-1,1> }
  scale <8.5,11,1>
  scale <0.35,0.35,1>
  rotate <90,0,0>
  rotate <0,35,0>
  translate <0,0.05,1>
}

//pieces of paper
box { <0,0,0>, <1,1,-0.001>
  pigment { image_map { tga "hw1.tga" } scale <-1,-1,1> }
  scale <8.5,11,1>
  scale <0.35,0.35,1>
  rotate <90,0,0>
  rotate <0,-20,0>
  translate <-3,0.05,-1>
}


//blotter
box { <-4.5,0,4.5>, <4.5, 0.05, -1.5> texture {Cardboard} }
//blackboard
box { <-15,-1,15>, <15, 9, 14.75>
texture {
pigment { granite
  color_map {
    [0.0 color rgb 0.0]
    [1.0 color rgb 0.2]
  }
  scale 5*x
}
normal {bumps scale 0.1}
}
}

difference {
box {<-15,-1,15>, <15,-0.5,13.5>}
cylinder { <-20,-0.5,14.5>, <20,-0.5,14.5>, 0.25 }
cylinder { <-20,-0.5,14>, <20,-0.5,14>, 0.25 }
texture {T_Wood1 scale 0.15 rotate 1*y rotate 90*y translate <0,1.25,0> }
}

intersection {
superellipsoid { <0.25, 0.25> }
plane { <1,0,1>, 0 }
  scale <1.2,0.1,1.2>
  translate <-3.5, 0, -0.5>
  texture { Leather }
}

intersection {
superellipsoid { <0.25, 0.25> }
plane { <1,0,1>, 0 }
  scale <-1.2,0.1,1.2>
  translate <3.5, 0, -0.5>
  texture { Leather }
}

intersection {
superellipsoid { <0.25, 0.25> }
plane { <1,0,1>, 0 }
  scale <-1.2,0.1,-1.2>
  translate <3.5, 0, 3.5>
  texture { Leather }
}

intersection {
superellipsoid { <0.25, 0.25> }
plane { <1,0,1>, 0 }
  scale <1.2,0.1,-1.2>
  translate <-3.5, 0, 3.5>
  texture { Leather }
}

union {
object {
  Apple rotate <-90,0,0> translate <0,-0.1,0>}
  object { Robo1 scale 0.2 translate <0,0.45,-1.5> }
  rotate <0,40,0>
  translate <5,0,-3.4>
}

union {
intersection {
superellipsoid { <0.5, 0.1> scale <3,4,0.25> }
box { 0, 5 }
translate <-9,0,4>
}
intersection {
superellipsoid { <0.5, 0.1> scale <3,4,0.25> }
box { 0, 5 }
scale <1,1,-1>
translate <-9,0,-2>
}
box { <-6.25,1.5,-2>, <-6, 1, 4> }
box { <-9,1.75,-2>, <-8.75, 2.25, 4> }
box { <-9,3.5,-2>, <-8.75, 4, 4> }
box { <-6, 0, 4>, <-9, 0.25, -2> }
texture { T_Wood33 finish { phong 0.1 reflection 0.1 } scale <3,3,1> }
}

object {
  book
  scale <0.833333333333,1,1>
  translate <-7.75, 0.25, -1.5> 
}

object {
  oxfrdbook
  scale <0.833333333333,1,1>
  translate <-7.75, 0.25, -0.5> 
}

object {
  bluebook
  scale <0.6666666666666,0.8,0.5>
  translate <-8, 0.25, 0.25> 
}

object {
  brownbook
  scale <0.833333333333,1,1>
  translate <0,0,0.5>
  rotate <-25,0,0>
  translate <-7.75, 0.25, 2> 
}

object {
  nitbook
  scale <0.633333333333,0.7,1>
  translate <-7.75, 0.25, 3.5> 
}   

object {
  chair
  translate <0,1,6>
}

object {
  Tree
  scale 0.01
  translate <-70,-70,0>
}

object {
  cup
  translate 1*y
  scale 0.5
  rotate <0,45,0>
  translate <-3, 0, -4>
}

object {
  robo3
  scale 0.2
  translate <1,0,-5>
}

object {
  robo4
  scale 0.2
  rotate <0,90,0>
  translate <-6.5,3.89,-0.5>
}

object {
  robo5
  scale 0.2
  rotate <0,105,0>
  translate <-1.0,0,-3.0>
}

object {
  robo6
  scale 0.2
  rotate <0,90,0>
  translate <2,0,-4>
}

object {
  robo7
  scale 0.2
  translate <0,0.05,0>
  rotate <0,-45,0>
  translate <1.5,0,1.5>
}

object {
  robo8
  scale 0.2
  translate <0,0.05,0>
  translate <-2,0,2>
}

