
// Persistence of Vision Ray Tracer Scene Description File
// File: woodblock.inc
// Vers: 3
// Desc: used for cookie cutter graduates: tabletop object
// Date: 3/11/97
// Auth: Doug Sterrett

/*
#declare Strip=
 box{
  <0.0, 0.0, -3.0>,
  <0.2, 0.2, 3.0>
 }


 #declare table_top=
 union{
 #declare Number_of_Strips=33
 #declare Count=-33
 #declare Strip_Switch=0
 #while (Count<Number_of_Strips)

  #switch (Strip_Switch)
   #case (0)
    object{
     Strip
     texture{T_Wood14
      rotate<0.0, Count*3, 0.0>
     }
     translate<Count/10, 0.0, 0.0>
    }
    #declare Strip_Switch=1
   #break
   #case (1)
    object{
     Strip
     texture{T_Wood13
      rotate <Count*5, Count, Count*5>
     }
     translate<Count/10, 0.0, 0.0>
    }
    #declare Strip_Switch=0
   #break
   #else
  #end
 #declare Count=Count+2
#end

 #declare Number_of_Strips=33
 #declare Count=-33
 #declare Strip_Switch=0
 #while (Count<Number_of_Strips)

  #switch (Strip_Switch)
   #case (0)
    object{
     Strip
     texture{T_Wood13
      rotate<0.0, Count*3, 0.0>
     }
     translate<Count/10, -0.2, 0.0>
    }
    #declare Strip_Switch=1
   #break
   #case (1)
    object{
     Strip
     texture{T_Wood14
      rotate <Count*5, Count, Count*5>
     }
     translate<Count/10, -0.2, 0.0>
    }
    #declare Strip_Switch=0
   #break
   #else
  #end
 #declare Count=Count+2
 #end
 }
*/

///////////////////////////////////////////////

// Very straight grained, whitish
#declare ST_Wood13 =
    texture{
     pigment{
      //P_WoodGrain13A
      wood
       color_map{
       //M_Wood13A
       // Same as M_Wood7A
       [0.0, 0.1 color rgb <0.60, 0.35, 0.20>
                 color rgb <0.60, 0.35, 0.20>]
       [0.1, 0.9 color rgb <0.60, 0.35, 0.20>
                 color rgb <0.90, 0.65, 0.30>]
       [0.9, 1.0 color rgb <0.90, 0.65, 0.30>
                 color rgb <0.60, 0.35, 0.20>]
      }
      /*
      turbulence 0.02
      scale 0.1
      translate <10, 0, 0>
      */
      //dark pattern modifiers
      turbulence 0.065
      octaves 2
      scale <0.15, .15, 1>
      translate < -1 0 0 >
      rotate <-3, -3, 0>

     }
    }
    texture{
     pigment{
      //P_WoodGrain13B
      wood
       color_map{
        //M_Wood13B
        // Same as M_Wood7B
        [0.0, 0.4 color rgbf <1.00, 1.00, 1.00, 1.00>
                  color rgbf <0.90, 0.65, 0.30, 0.30>]
        [0.4, 0.5 color rgbf <0.90, 0.65, 0.30, 0.00>
                  color rgbf <0.90, 0.65, 0.30, 0.30>]
        [0.5, 1.0 color rgbf <0.90, 0.65, 0.30, 0.30>
                  color rgbf <1.00, 1.00, 1.00, 1.00>]
      }
      /*
      turbulence 0.01
      scale 0.05
      */
      //dark txtr lvl 2 modifiers
      turbulence <0, 0.1, 0>
      lambda 2.75
      omega 1.15
      octaves 4
      scale <5, 0.075, 1>
      rotate x*90
     }
    }


// Red, rough grain
#declare ST_Wood14 =
  texture{
   pigment{
    //P_WoodGrain14A
    wood
    color_map{
     //M_Wood14A
     [0.00 0.10 color rgb < 0.80, 0.232, 0.115 >
                color rgb < 0.80, 0.232, 0.115 >]
     [0.10 0.90 color rgb < 0.80, 0.232, 0.115 >
                color rgb < 0.45, 0.115, 0.060 >]
     [0.90 1.0  color rgb < 0.45, 0.115, 0.060 >
                color rgb < 0.45, 0.115, 0.060 >]
    }
    turbulence 0.065
    octaves 2
    scale <0.15, .15, 1>
    translate < -1 0 0 >
    rotate <-3, -3, 0>
   }
  }
  texture{
   pigment{
    //P_WoodGrain14B
    wood
    color_map{
     //M_Wood14B
     [0.00 0.10 color rgbf < 0.70, 0.232, 0.115, 0.5 >
                color rgbf < 0.70, 0.232, 0.115, 0.7 >]
     [0.10 0.15 color rgbf < 0.70, 0.232, 0.115, 0.7 >
                color rgbf < 0.35, 0.115, 0.060, 0.9 >]
     [0.15 0.20 color rgbf < 0.70, 0.232, 0.115, 0.9 >
                color rgbf < 0.35, 0.115, 0.060, 0.7 >]
     [0.20 1.0  color rgbf < 0.35, 0.115, 0.060, 0.7 >
                color rgbf < 0.35, 0.115, 0.060, 0.5 >]
    }
    turbulence <0, 0.1, 0>
    lambda 2.75
    omega 1.15
    octaves 4
    scale <5, 0.075, 1>
    rotate x*90
   }
  }




#declare Dark_Block=
 box{
  <-3.3, 0.0, -3.0>,<3.3, 0.2, 3.0>
  texture{ST_Wood14
   rotate  <0.0, 90.0, 90.0>
   scale <1.5, 1.0, 1.5>
   translate <0.0, 0.0, -1.5>
  }
 }
#declare Light_Block=
 box{
  <-3.3, 0.0, -3.0>,<3.3, 0.2, 3.0>
  texture{ST_Wood13
   rotate  <0.0, 0.0, 90.0>
   scale <1.0, 0.5, 1.0>
  }
 }

#declare table_top=
union{
 object{
  union{
   object{
    difference{
     object{Dark_Block}
     #declare MinusXcut=-3.1
     #while (MinusXcut<3.3)
     box{
      <MinusXcut, -0.1, -3.1>,<MinusXcut+0.2, 0.3, 3.1>
      pigment{Clear}
     }
     #declare MinusXcut=MinusXcut+0.4
     #end
    }
   }
   object{
    difference{
     object{Light_Block}
     #declare MinusXcut=-3.3
     #while (MinusXcut<3.1)
     box{
      <MinusXcut, -0.1, -3.1>,<MinusXcut+0.2, 0.3, 3.1>
      pigment{Clear}
     }
     #declare MinusXcut=MinusXcut+0.4
     #end
    }
   }
  }
 }
 object{
  union{
   object{
    difference{
     object{Light_Block
      translate <0.0, -0.2, 0.0>
     }
     #declare MinusXcut=-3.1
     #while (MinusXcut<3.3)
     box{
      <MinusXcut, -0.3, -3.1>,<MinusXcut+0.2, 0.1, 3.1>
      pigment{Clear}
     }
     #declare MinusXcut=MinusXcut+0.4
     #end
    }
   }
   object{
    difference{
     object{Dark_Block
      translate <0.0, -0.2, 0.0>
     }
     #declare MinusXcut=-3.3
     #while (MinusXcut<3.1)
     box{
      <MinusXcut, -0.3, -3.1>,<MinusXcut+0.2, 0.1, 3.1>
      pigment{Clear}
     }
     #declare MinusXcut=MinusXcut+0.4
     #end
    }
   }
  }
 }
}

