// Plank Size and Texture
#ifndef (PlankWidth)
  #declare PlankWidth = 1
#end  
#ifndef (PlankThick)
  #declare PlankThick = 0.25
#end
#ifndef (PlankLength)
  #declare PlankLength= 10
#end
#ifndef (PlankTexture)  
  #declare PlankTexture = texture { pigment { color <1,1,1> } }
#end  

// Floor Size
#ifndef (FloorWidth)
  #declare FloorWidth  = 10
#end  
#ifndef (FloorLength)
  #declare FloorLength = 10
#end  

// Floor Quality
#ifndef (FitQuality)
  #declare FitQuality = 0.01  // Lower the higher the fit quality
#end  
#ifndef (BoardQuality)
  #declare BoardQuality = 0  // Lower the less the boards twist
#end  

// Internal Vars
#declare FloorSeed = seed(42)
#declare WidthCount = div(FloorWidth,PlankWidth)
#declare CountWidth = 0

// Build Floor

#declare Floor = union {
  #while (CountWidth < WidthCount)

    #declare LengthOff =  -FloorLength * (0.5 + rand(FloorSeed))

    #while (LengthOff < FloorLength)
      #declare WidthScale = 1 - (rand(FloorSeed)*FitQuality + FitQuality/10)
      #declare LengthScale = 1 - (rand(FloorSeed)*FitQuality/PlankLength + FitQuality/PlankLength/10)

      // Plank
      #declare Plank = object {
        box {
          <0-PlankWidth/2,0-PlankThick/2,0-PlankLength/2> <PlankWidth/2,PlankThick/2,PlankLength/2>
          texture {
            PlankTexture
            translate <5*rand(FloorSeed),5*rand(FloorSeed),5*rand(FloorSeed)>
          }
        }
      }

      #declare PlankX = FloorWidth/2-(CountWidth * PlankWidth)
      object {
        Plank
        rotate <0,0,BoardQuality/2-rand(FloorSeed)*BoardQuality>
        scale <WidthScale,1,LengthScale>
        translate <PlankX+(1-WidthScale)/2,0,LengthOff+(1-LengthScale)/2>
        clipped_by {
          box {
            <0-FloorWidth/2,0-PlankThick,0-FloorLength/2>
            <FloorWidth/2,PlankThick,FloorLength/2>
          }
        }
      }
      #declare LengthOff = LengthOff + PlankLength
    #end
    #declare CountWidth = CountWidth + 1
  #end
}
