#declare TableYOffset = 0.25;

#declare Student_Desktop = union {
  // *** Student Desk
  #include "student.inc"
  object {
    student_desk
    rotate <0,0,0>

  }


  //*** Student Desk Top Items


  //* Ink Bottle
  #declare BottleTexture = texture {
    T_Glass1
  }
  #declare InkTexture = texture {
    pigment { color <0.0,0.0,0.1> }
    finish { Shiny }
  }

  #include "InkBottle.inc"
  object {
    InkBottle
    scale <1.45,2,1.45>
    translate <6.5,TableYOffset+(0.25 * 2),-1.75>
  }

  //* Pen
  #include "pen.inc"
  object {
    pen
    scale 1/3
    rotate 3*z
    rotate -65 * y
//    translate < 5, TableYOffset + 0.25,-0.5 >
    translate < 5, TableYOffset + 0.23,-0.5 >
  }

  //* Marbles

  // Aggies
  #declare GrooveZ = -3.4
  #declare GrooveY = 0.1
  #declare AggieSeed = seed(951)


  #declare ColorOne = Blue
  #include "aggie.inc"

  object {
    Aggie
    translate <4.5,GrooveY + MarbleRadius,GrooveZ>
  }

  #declare ColorOne = DarkGreen
  #include "aggie.inc"

  object {
    Aggie
    translate <4.5+MarbleRadius*2,GrooveY + MarbleRadius,GrooveZ>
  }

  // Cleary
  #declare MarbleTexture = texture { T_Ruby_Glass }
  #declare MarbleRadius = 0.3

  #include "clrmrbl.inc"

  object {
    ClearMarble
    translate <4.5 + 1.05,GrooveY + 0.3,GrooveZ>
  }

  // Spiral
  #declare SpiralTexture = texture {
    pigment {
      agate
      turbulence 0.2
      color_map {
        [0.0 0.2 color Red color Red]
        [0.2 0.8 color White color White]
        [0.8 1.0 color Blue color Blue]
      }
    }
    finish { Shiny }
  }

  #declare MarbleTexture = texture { T_Glass1 }
  #declare MarbleRadius = 2


  #include "spiral.inc"
  #include "clrmrbl.inc"

  union {
    object { ClearMarble }
    object { Spiral }
    scale 1/8
    rotate<35,0,0>
    translate<4.5-MarbleRadius/4,GrooveY + 0.25,GrooveZ>
  }

  #declare SpiralTexture = texture {
    pigment { color Yellow }
    finish { Shiny }
  }

  #include "spiral.inc"

  union {
    object { ClearMarble }
    object { Spiral }
    scale 1/8
    rotate<-15,20,0>
    translate<4.5 + 1.05 + MarbleRadius/4,GrooveY + 0.25,GrooveZ>
  }

  #declare MarbleRadius = 0.25;
  #declare ColorOne = Blue * 0.9
  #include "aggie.inc"

  object {
    Aggie
    translate <4.5 - 1,GrooveY + MarbleRadius,GrooveZ>
  }

  //* End Marbles

  #include "chalk.inc"

  object {
    Chalk
    scale 1.5
    translate <2,GrooveY + 0.2,GrooveZ>
  }

  //*  Little Chalk Board
  #declare ChalkBoardHeight = 4
  #declare ChalkBoardWidth = 6
  #declare CBFrameDepth = 0.25
  #declare ChalkBoardTexture = texture {
    pigment {
      image_map { tga "smallcb.tga" }
      translate <-0.5,-0.5,0>
      scale <6,4,1>
    }
    normal {
      crackle
      turbulence 0.80
    }
  }

  #declare CBFrameTexture = texture {
    T_Wood3
    rotate 90 * y
    normal {
      bumps
      frequency 1.0
      turbulence 0.55
      scale <0.25,0.05,0.1>
    }
  }

  #include "chlkbrd.inc"

  object {
    ChalkBoard
    rotate <90,0,0>
    rotate <0,-195,0>
    translate <-0.5,TableYOffset+CBFrameDepth/2,-1>
  }


  //* Glasses
  #include "glasses.inc"

  object {
    glasses
    scale 1/2
//    rotate <-65,15,2>
    rotate <-6,172,0>
    translate <0.25,TableYOffset+0.22 + CBFrameThick,-2.6>
  }

  //* Abacus
  #include "abacus.inc"

  object {
    Abacus
    rotate <-90,17,0>
    scale 1.5
    translate <4.5,TableYOffset+(AbacusThick * 1.5) + BeadThick,2.25>
  }

  rotate 9 * x
  translate <-11.5,3,-6.5>
}
