#declare AbacusWidth = 2
#declare AbacusHeight = 1
#declare AbacusThick = 0.1

#declare NumWires = 7

#declare AbacusFrameTexture = texture {
  T_Wood7
  rotate y * 90
  scale 1/4
}
#declare WireTexture = texture { T_Copper_1A }
#declare LightBeadTexture = texture {
  T_Wood3
  scale 1/6
  finish { Shiny }
}
#declare DarkBeadTexture = texture {
  T_Wood4
  scale 1/6
  finish { Shiny }
}

#declare AbacusFrame = union {
  union {
    box {  // Bottom
      <-AbacusWidth/2-0.2,-AbacusHeight/2-0.05,-AbacusThick/2>
      <AbacusWidth/2+0.2,-AbacusHeight/2+0.05,AbacusThick/2>
    }
    box {  // Top
      <-AbacusWidth/2-0.2,AbacusHeight/2+0.05,-AbacusThick/2>
      <AbacusWidth/2+0.2,AbacusHeight/2-0.05,AbacusThick/2>
    }
    box {  // Middle
      <-AbacusWidth/2,AbacusHeight/6,-AbacusThick/2>
      <AbacusWidth/2,AbacusHeight/6-0.1,AbacusThick/2>
    }
    texture { AbacusFrameTexture }
  }
  union {
    box {
      <-AbacusWidth/2,-AbacusHeight/2,-AbacusThick/2>
      <-AbacusWidth/2-0.1,AbacusHeight/2,AbacusThick/2>
    }
    box {
      <AbacusWidth/2,-AbacusHeight/2,-AbacusThick/2>
      <AbacusWidth/2+0.1,AbacusHeight/2,AbacusThick/2>
    }
    texture {
      AbacusFrameTexture
      rotate 90 * z
    }
  }
}

#declare BeadThick = 0.025

#declare Bead = lathe {
   linear_spline
   10,
   <0,0.01> <0.012,0.01> <0.012,0.03> <0.035,0.03> <0.07,0.01>
   <0.07,-0.01> <0.035,-0.03> <0.012,-0.03> <0.012,-0.01> <0,-0.01>
}
/*
torus {
  0.04, BeadThick
}
*/

#declare BeadSeed = seed(630)
#declare TopRange = AbacusHeight/2 - (AbacusThick + BeadThick)
#declare TMiddleRange = (AbacusHeight/2 - AbacusHeight/6) - (AbacusThick + BeadThick * 2)
#declare BMiddleRange = (AbacusHeight/2 - AbacusHeight/6) - (AbacusThick + BeadThick * 2)
#declare BottomRange = -AbacusHeight/2 + (AbacusThick + BeadThick)


#declare WireSpace = 0.25

#declare Abacus = union {
  object {
    AbacusFrame
  }
  #declare WireCount = 0
  #while (WireCount < NumWires)
    union {
      cylinder {
        <0,-AbacusHeight/2 + 0.05,0> <0,AbacusHeight/2 - 0.05,0> 0.01
        texture { WireTexture }
      }
      #declare BeadCount = 0
      #declare NewPos = rand(BeadSeed) * BeadThick
      #while (BeadCount < 2)
        object {
          Bead
          translate<0,TopRange - NewPos,0>
          texture {
            DarkBeadTexture
            translate <7 * rand(BeadSeed),7 * rand(BeadSeed),7 * rand(BeadSeed)>
          }
        }
        #declare NewPos = NewPos + (BeadThick*2) + ((BeadThick*2) * rand(BeadSeed))
        #declare BeadCount = BeadCount + 1
      #end

      #declare BeadCount = 0
      #declare NewPos = rand(BeadSeed) * BeadThick
      #while (BeadCount < 5)
        object {
          Bead
          translate<0,BottomRange + NewPos,0>
          texture {
            LightBeadTexture
            translate <7 * rand(BeadSeed),7 * rand(BeadSeed),7 * rand(BeadSeed)>
          }
        }
        #declare NewPos = NewPos + (BeadThick*2) + ((BeadThick*2) * rand(BeadSeed))
        #declare BeadCount = BeadCount + 1
      #end
      translate <-AbacusWidth/2 + WireSpace + (WireSpace * WireCount),0,0>
    }
    #declare WireCount = WireCount + 1
  #end
}

