// Include files
#ifndef (book_rand )
  #declare book_rand = seed(42)
#end

#declare book_x = 0.5 + rand(book_rand) * 0.5 - 0.25
#declare book_y = 2.5 + rand(book_rand) * 0.5 - 0.25
#declare book_z = 1.75 + rand(book_rand) * 0.5 - 0.25
#declare max_z = 2
#declare book_cover = 0.1 + rand(book_rand) * 0.05 - 0.025

#declare book_side = union {
  box { <-book_cover/2,0,0> <book_cover/2,book_y,book_z> }
  cylinder { <0,0,book_z> <0,book_y,book_z> book_cover/2 }
  cylinder { <0,book_y,0> <0,book_y,book_z> book_cover/2 }
  cylinder { <0,0,0> <0,0,book_z> book_cover/2 }
  sphere { <0,0,book_z> book_cover/2}
  sphere { <0,book_y,book_z> book_cover/2}
}

#declare binding = union {

  difference {
    cylinder { <0,0,0> <0,book_y,0> (book_x/2 + book_cover/2) }
    cylinder { <0,-book_y/2,0> <0,book_y/2,0> (book_x/2 - book_cover/2)
      scale 1.01
      translate <0,book_y/2,0>
    }
  }
  torus { book_x/2, book_cover/2 }
  torus { book_x/2, book_cover/2
    translate <0,book_y,0>
  }
  // check for binding_rings
  #declare rings = rand(book_rand)
  #if (rings < 0.6)
    #declare ring_radius = (book_cover*(0.5 + rings*0.2 - 0.1))
    #declare ring = torus { (book_x + book_cover)/2, ring_radius}
    object { ring
      translate <0,book_y * 0.2,0>
    }
    object { ring
      translate <0,book_y * 0.8,0>
    }
    #if (rings < 0.3)
      object { ring
        translate <0,book_y * 0.15,0>
      }
      object { ring
        translate <0,book_y * 0.85,0>
      }
    #end
  #end

  // do title
  #declare title_length = rand(book_rand) * 5
  #declare y_offset = book_y * 0.7
  #if (rand(book_rand) < 0.5) // horizontal title
    #declare title_height = (book_cover*(0.5 + rand(book_rand)*0.2 - 0.1))
    #while (title_length > 0)
      #declare title_word = difference {
        cylinder { <0,-title_height/2,0> <0,title_height/2,0> (book_x/2 + book_cover/2)  }
        cylinder { <0,-title_height/2,0> <0,title_height/2,0> (book_x/2 - book_cover/2)
          scale 1.01
          translate <0,book_y/2,0>
        }
        #declare word_width = book_x * (rand(book_rand) * 0.3 + 0.3)
        clipped_by {
            box { <-word_width/2,-title_height/2,0>
                  < word_width/2, title_height/2,-(book_x/2 + book_cover/2) * 1.02>
              scale 1.01
            }
        }
        texture { pigment { Yellow/2 + Yellow * rand(book_rand) * 0.5 } }
      }
      object { title_word
        translate <0,y_offset,0>
        #declare y_offset = y_offset - title_height * 1.5
      }
      #declare title_length = title_length - 1
    #end
  #else  // vertical title
    #declare title_width = (book_x*(1/3 + rand(book_rand)*0.4 - 0.2))
    #declare title_space = book_y * 0.5
    #while (title_length > 0)
      #declare title_height = (title_space / title_length) // * rand(book_rand)
      difference {
        cylinder { <0,y_offset,0> <0,y_offset - title_height,0> (book_x/2 + book_cover/2)  }
        cylinder { <0,y_offset,0> <0,y_offset - title_height,0> (book_x/2 - book_cover/2)
          scale 1.01
        }
        clipped_by {
          box { <-title_width/2,book_y/2-title_space/2             ,0>
                < title_width/2,book_y/2+title_space/2,-(book_x/2 + book_cover/2) * 1.02>
            scale 1.01
          }
        }
        texture { pigment { Yellow/2 + Yellow * rand(book_rand) * 0.5 } }
      }
      #declare y_offset = y_offset - (title_height + 0.05)
      #declare title_length = title_length - 1
    #end



  #end

  clipped_by { box { <-(book_x/2+book_cover/2),-book_cover/2,0>
                     <(book_x/2+book_cover/2),book_y+book_cover/2,-(book_x + book_cover)> }
  }
  scale <1,1,1/2>
}

#declare cover = union {
  object { book_side
    translate <-book_x/2,0,0>
  }
  object { book_side
    translate <book_x/2,0,0>
  }
  object { binding }

//#if (rand(book_rand) < 0.7)
/*  texture { pigment { Brown * rand(book_rand) +
                      Red * rand(book_rand) * 0.25 +
                      Yellow * rand(book_rand) * 0.25 } }
*/
//#else
  texture {
    pigment {
      Brown * rand(book_rand) +
      Red * rand(book_rand) * 0.25 +
      Yellow * rand(book_rand) * 0.25    
    /*
      wrinkles
      #declare da_book_color = Brown * rand(book_rand) +
                             Red * rand(book_rand) * 0.25 +
                             Yellow * rand(book_rand) * 0.25
      color_map {
        [0.85 color da_book_color]
        [1.0 color da_book_color * 0.5 ]
      }
      frequency 30
      turbulence 0.5
      scale <1/10,10,1>
    */
    }
    normal {
      wrinkles
      scale 1/20
//      frequency 30
//      turbulence 0.5
     // scale <1/10,10,1>
    }
  }
//#end

}

#declare manuscript = union {
  #declare manudent = object {
    cylinder { <0,0,0> <0,book_y,0> (book_x/2) }
  }
  difference { box {
      <-(book_x/2 - book_cover/2),0,0>
      <(book_x/2 - book_cover/2),book_y,book_z>
    }
    object { manudent
      scale <1,1,1/3>
      scale <1,1.01,1>
      translate <0,0,book_z>
    }
  }
  object { manudent
    scale <1,1,1/3>
  }
    
  
    texture {
      pigment {
        ripples
        color_map {
            [0.8 color Gray80]
            [1.0 color Gray20]
        }
        frequency 30
      }
    }
/*  
  box {
    <-(book_x/2 - book_cover/2),0,-0.01>
    <(book_x/2 - book_cover/2),book_y,0.01>
    texture { pigment { Gray20 } }
  }
*/  
}

#declare book_x = book_x + book_cover

#declare book = union {
  object { cover }
  object { manuscript }
  translate <book_x/2,0,max_z - book_z>
}


