#declare sx = 5
#declare sy = 0.1
#declare sz = 1.2

#declare bshelf = object {
  box { <-sx,-sy,-sz> <sx,sy,sz> }
  texture { pigment { Tom_Wood }
    scale 0.2
  }
}

#declare lower_shelf = union {
  #declare stack_height = 2
  #include "bstack.inc"
  object { stack
    rotate <0,90,0>
    translate <-(sx - bx/2),0,0>
  }
  #include "bstack.inc"
  object { stack
    rotate <0,90,0>
    translate <sx - bx/2,0,0>
  }
  #declare lower_shelf_y = sy*2 + by*2*stack_height
  object { bshelf
    translate <0,lower_shelf_y-sy  ,0>
  }
}

#declare upper_shelf = union {
  #declare stack_height = 5
  #include "bstack.inc"
  object { stack
    rotate <0,90,0>
    translate <-(sx - bx/2),0,0>
  }
  #include "bstack.inc"
  object { stack
    rotate <0,90,0>
    translate <sx - bx/2,0,0>
  }
  #declare upper_shelf_y = sy*2 + by*2*stack_height
  object { bshelf
    translate <0,upper_shelf_y-sy  ,0>
  }
}

#declare bookshelf = union {

  // LOWER SHELF
  object { lower_shelf }

  // LOWER SHELF BOOKS
  #declare max_books = 12
  #declare x_offset = 0
  union {
    #while (max_books > 0)
      #include "book.inc"
      object { book
        translate <x_offset,0,0>
      }

      #declare x_offset = x_offset + book_x
      #declare max_books = max_books - 1
    #end
    rotate <0,180,0>

    translate <x_offset/2,lower_shelf_y,0.9>
  }

  // UPPER SHELF
  object { upper_shelf
    translate <0,lower_shelf_y,0>
  }
  #include "lamp.inc"

  // UPPER SHELF LAMP
  object {
    lamp
    scale 7/24
    rotate 130 * y
    translate <sx * 1/3,lower_shelf_y + upper_shelf_y + 0.05,0>
  }

  // UPPER SHELF BOOKS
  union {
    #declare max_books = 3
    #declare x_offset = 0
    #while (max_books > 0)
      #include "book.inc"
      object { book
        translate <0,-book_y/2,-book_z/2 - (max_z - book_z)>
        rotate <rand(br)*120-60,0,0>
        translate <x_offset,0,0>
      }
      #declare x_offset = x_offset + book_x
      #declare max_books = max_books - 1
    #end
    rotate <0,0,-90>
    rotate <0,135,0>
    translate <-sx * 2/3,lower_shelf_y + upper_shelf_y + x_offset,0.4>
  }
}
