// Chalk Board

#ifndef (ChalkBoardHeight)
  #declare ChalkBoardHeight = 2
#end

#ifndef (ChalkBoardWidth)
  #declare ChalkBoardWidth = 3
#end

#ifndef (CBFrameThick)
  #declare CBFrameThick = 0.5
#end

#ifndef (CBFrameDepth)
  #declare CBFrameDepth = 0.5
#end

#ifndef (ChalkBoardTexture)
  #declare ChalkBoardTexture = texture { pigment { color <0.05,0.05,0.05> } }
#end

#ifndef (CBFrameTexture)
  #declare CBFrameTexture = texture { pigment { color <0.8,0.8,0.8> } }
#end

#declare CBSeed = seed(232)

#declare ChalkBoard = union {
  box {
    <-ChalkBoardWidth/2,-ChalkBoardHeight/2,-0.01> <ChalkBoardWidth/2,ChalkBoardHeight/2,0.01>
    texture { ChalkBoardTexture }
  }
  
  union {
    box {
      <-ChalkBoardWidth/2,-ChalkBoardHeight/2-CBFrameThick/2,-CBFrameDepth/2>
      <ChalkBoardWidth/2,-ChalkBoardHeight/2+CBFrameThick/2,CBFrameDepth/2>
    }
    cylinder {
      <-ChalkBoardWidth/2,-ChalkBoardHeight/2,-CBFrameDepth/2>
      <-ChalkBoardWidth/2,-ChalkBoardHeight/2,CBFrameDepth/2> CBFrameThick/2
    }
    cylinder {
      <ChalkBoardWidth/2,-ChalkBoardHeight/2,-CBFrameDepth/2>
      <ChalkBoardWidth/2,-ChalkBoardHeight/2,CBFrameDepth/2> CBFrameThick/2
    }
    texture {
      CBFrameTexture
      translate <7 * rand(CBSeed),7 * rand(CBSeed),7 * rand(CBSeed)>
    }
  }
  union {
    box {
      <-ChalkBoardWidth/2,ChalkBoardHeight/2-CBFrameThick/2,-CBFrameDepth/2>
      <ChalkBoardWidth/2,ChalkBoardHeight/2+CBFrameThick/2,CBFrameDepth/2>
    }
    cylinder {
      <-ChalkBoardWidth/2,ChalkBoardHeight/2,-CBFrameDepth/2>
      <-ChalkBoardWidth/2,ChalkBoardHeight/2,CBFrameDepth/2> CBFrameThick/2
    }
    cylinder {
      <ChalkBoardWidth/2,ChalkBoardHeight/2,-CBFrameDepth/2>
      <ChalkBoardWidth/2,ChalkBoardHeight/2,CBFrameDepth/2> CBFrameThick/2
    }
    texture {
      CBFrameTexture
      translate <7 * rand(CBSeed),7 * rand(CBSeed),7 * rand(CBSeed)>
    }
  }
  box {
    <-ChalkBoardWidth/2-CBFrameThick/2,-ChalkBoardHeight/2,-CBFrameDepth/2>
    <-ChalkBoardWidth/2+CBFrameThick/2,ChalkBoardHeight/2,CBFrameDepth/2>
    texture {
      CBFrameTexture
      rotate 90 * z
      translate <7 * rand(CBSeed),7 * rand(CBSeed),7 * rand(CBSeed)>
    }
  }
  box {
    <ChalkBoardWidth/2-CBFrameThick/2,-ChalkBoardHeight/2,-CBFrameDepth/2>
    <ChalkBoardWidth/2+CBFrameThick/2,ChalkBoardHeight/2,CBFrameDepth/2>
    texture {
      CBFrameTexture
      rotate 90 * z
      translate <7 * rand(CBSeed),7 * rand(CBSeed),7 * rand(CBSeed)>
    }
  }
}
