#ifndef(MarbleRadius)
  #declare MarbleRadius = 2
#end
#ifndef(NumberBubbles)
  #declare NumberBubbles = 12
#end
#ifndef(MarbleTexture)
  #declare MarbleTexture = texture { T_Glass1 }//pigment{ color rgbt <1,1,1,0.8> } }
#end


#declare ClearMarbleSeed = seed(1353)

#if(NumberBubbles > 0)
#declare ClearMarble = difference {
  sphere {
    0, MarbleRadius
    texture { MarbleTexture }
  }
  #declare BubbleCount = 0
  #while (BubbleCount < NumberBubbles)
    sphere {
      <(MarbleRadius-(MarbleRadius/25))*rand(ClearMarbleSeed),0,0>,
       (MarbleRadius/25) * rand(ClearMarbleSeed)
      rotate <0,360 * rand(ClearMarbleSeed),360 * rand(ClearMarbleSeed)>
      scale <1,0.4 + (rand(ClearMarbleSeed) * 0.4),1>
      texture { MarbleTexture }
    }
    #declare BubbleCount = BubbleCount + 1
  #end
}
#else
#declare ClearMarble = object {
  sphere {
    0, MarbleRadius
  }
  texture { MarbleTexture }
}
#end
