#declare boardcount = 8
#declare boardwidth = 1.5
#declare boarddepth = 0.6
#declare boardlength = 8

#declare tabletop = union {
  #declare i = boardcount

  #declare plank = box {
    <-boardwidth/2, -boarddepth/2, -boardlength/2>
    < boardwidth/2,  boarddepth/2,  boardlength/2>
  }

  union {
    #while (i > 0)
      #include "mytects.inc"
      object { plank
        texture { Desk_Top_Texture }
        translate <(i-((boardcount + 1)/2)) * boardwidth,0,0>
      }
      #declare i = i - 1
    #end
  }


  #include "mytects.inc"
  union {
    cylinder { <-(boardcount * boardwidth / 2),0,-boardlength/2> <(boardcount * boardwidth / 2),0,-boardlength/2> boarddepth / 2 }
    cylinder { <-(boardcount * boardwidth / 2),0,boardlength/2> <(boardcount * boardwidth / 2),0,boardlength/2> boarddepth / 2 }
    cylinder { <-(boardcount * boardwidth / 2),0,-boardlength/2> <-(boardcount * boardwidth / 2),0,boardlength/2> boarddepth / 2 }
    cylinder { <boardcount * boardwidth / 2,0,-boardlength/2> <boardcount * boardwidth / 2,0,boardlength/2> boarddepth / 2 }
    sphere { <boardcount * boardwidth / 2,0,boardlength/2> boarddepth / 2}
    sphere { <boardcount * boardwidth / 2,0,-boardlength/2> boarddepth / 2}
    sphere { <-boardcount * boardwidth / 2,0,boardlength/2> boarddepth / 2}
    sphere { <-boardcount * boardwidth / 2,0,-boardlength/2> boarddepth / 2}
    texture { Copper_Texture normal { dents 1 turbulence 0.5 scale 0.2 } }
  }
}


#declare legs = union {
  #declare leg_size = 0.5
  #declare leg_height = 7

  #declare modest_height = 1.5
  #declare modest_depth = 0.15
  #declare modest_length = boardcount * boardwidth

  #declare modest_count = 10
  #declare modest_x = 0.5
  #declare modest_y = 2.8
  #declare modest_z = modest_depth/2
  #declare modest_front = box {
    <-modest_x, -modest_y, -modest_z>
    < modest_x,  modest_y,  modest_z>
  }
  union {
    #declare i = 0
    #declare mx=modest_x * 2
    #while (i <= modest_count)
      #include "mytects.inc"
      object { modest_front
        texture { Desk_Modest_Front_Texture }
        translate <-mx*modest_count/2 + mx*i,0.5,-(boardlength/2 - modest_depth/2)>
      }
      #declare i = i + 1
    #end
  }
  
  #declare post_cyl = leg_size / 4
  #declare dw = boardcount*boardwidth/2  
  union {
    box { <-(dw-leg_size/2),-leg_size/2,-(leg_size/2 - post_cyl)>
          < (dw-leg_size/2), leg_size/2, (leg_size/2 - post_cyl)> }
    box { <-(dw-leg_size/2),-(leg_size/2 - post_cyl),-leg_size/2>
          < (dw-leg_size/2), (leg_size/2 - post_cyl), leg_size/2> }
    #declare pc = cylinder { <-(dw-leg_size/2),0,0> <(dw-leg_size/2),0,0> post_cyl }
    object { pc translate <0,-(leg_size/2 - post_cyl),-(leg_size/2 - post_cyl)> }
    object { pc translate <0,-(leg_size/2 - post_cyl), (leg_size/2 - post_cyl)> }
    object { pc translate <0,(leg_size/2 - post_cyl),-(leg_size/2 - post_cyl)> }
    object { pc translate <0,(leg_size/2 - post_cyl), (leg_size/2 - post_cyl)> }
    translate <0,-modest_y + 0.5,-(boardlength/2 - modest_depth/2)>
    texture { Desk_Leg_Texture
      rotate <0,0,90>
    }
    
  }

  #declare modest_count = 4
  #declare modest_x = modest_depth/2
  #declare modest_y = modest_height/2
  #declare modest_z = boardlength/2-leg_size
  #declare modest_side = box {
    <-modest_x, -modest_y, -modest_z>
    < modest_x,  modest_y,  modest_z>
  }
  union {
    #declare i = 0
    #while (i < modest_count)
      #declare modest_y = (leg_height/2 - modest_height/2) - (i * modest_height)

      #include "mytects.inc"
      object { modest_side
        texture { Desk_Modest_Side_Texture }
        translate <modest_length/2 - modest_depth/2,modest_y,0>
      }

      #include "mytects.inc"
      object { modest_side
        texture { Desk_Modest_Side_Texture }
        translate <-(modest_length/2 - modest_depth/2),modest_y,0>
      }

      #declare i = i + 1
    #end
  }

  #declare post = union {
    box { <-(leg_size/2 - post_cyl),-leg_height/2,-leg_size/2> <leg_size/2 - post_cyl,leg_height/2,leg_size/2> }
    box { <-leg_size/2,-leg_height/2,-(leg_size/2-post_cyl)> <leg_size/2,leg_height/2,leg_size/2-post_cyl> }
    #declare pc = cylinder { <0,-leg_height/2,0> <0,leg_height/2,0> post_cyl }
    object { pc translate <-(leg_size/2 - post_cyl),0,-(leg_size/2 - post_cyl)> }
    object { pc translate <-(leg_size/2 - post_cyl),0, (leg_size/2 - post_cyl)> }
    object { pc translate < (leg_size/2 - post_cyl),0,-(leg_size/2 - post_cyl)> }
    object { pc translate < (leg_size/2 - post_cyl),0, (leg_size/2 - post_cyl)> }
  }
 

  #declare cowling = object {
    superellipsoid { <0.2, 0.2 > }
    clipped_by { box { <-1,0,-1> <1,1,1> } }
    scale leg_size * 0.6
    translate <0,-leg_height / 2,0>
  }

  union {
    #include "mytects.inc"
    object { post     texture { Desk_Leg_Texture } }
    object { cowling  texture { Copper_Texture normal { dents 1 turbulence 0.5 scale 0.2 } } }
    translate <((boardcount*boardwidth/2 - leg_size/2)),0,(boardlength/2 - leg_size/2)>
  }

  union {
    #include "mytects.inc"
    object { post     texture { Desk_Leg_Texture } }
    object { cowling  texture { Copper_Texture normal { dents 1 turbulence 0.5 scale 0.2 } } }
    translate <(boardcount*boardwidth/2 - leg_size/2),0,-((boardlength/2 - leg_size/2))>
  }

  union {
    #include "mytects.inc"
    object { post     texture { Desk_Leg_Texture } }
    object { cowling  texture { Copper_Texture normal { dents 1 turbulence 0.5 scale 0.2 } } }
    translate <-((boardcount*boardwidth/2 - leg_size/2)),0,(boardlength/2 - leg_size/2)>
  }

  union {
    #include "mytects.inc"
    object { post     texture { Desk_Leg_Texture } }
    object { cowling  texture { Copper_Texture normal { dents 1 turbulence 0.5 scale 0.2 } } }
    translate <-((boardcount*boardwidth/2 - leg_size/2)),0,-((boardlength/2 - leg_size/2))>
  }
}


#declare desk = union {
  object { tabletop translate <0,leg_height / 2,0> }
  object { legs }
}
