#ifndef (r1)
  #declare r1 = seed(42)
#end

#declare My_Copper_Color_Map = color_map {
//  [0.0 color P_Copper1]
  [0.2 color P_Copper2]
//  [0.4 color P_Copper3]
  [0.6 color P_Copper4]
//  [0.8 color P_Copper5]
}

#declare My_Copper_Pigment = pigment {
  bozo
  colour_map { My_Copper_Color_Map }
  turbulence 0.8 + 0.4 * rand(r1)
  octaves 2
  scale <0.15, .15, 1>
  translate < -rand(r1),0 0 >
  rotate <-3 * rand(r1), -3 * rand(r1), 0>
}

#declare My_Copper_Finish = finish {
//  ambient 0.35
  ambient 0.1
  brilliance 2
  diffuse 0.3
  metallic
  specular 0.20
  roughness 1/20
  reflection 0.1
}

#declare Copper_Texture = texture {
  pigment { My_Copper_Pigment }
  finish { My_Copper_Finish }
}

#declare Desk_Top_Texture = texture {
  T_Wood30
  scale 1 + rand(r1) * 1
  translate rand(r1) * 2 - 1
  rotate <0,rand(r1) * 5 - 2.5,0>
}

#declare Desk_Modest_Front_Texture = texture {
  T_Wood30
  scale 1 + rand(r1) * 1
  translate rand(r1) * 2 - 1
  rotate <90,0,0>
  rotate <0,0,rand(r1) * 5 - 2.5>
}  
texture {
   pigment {
     bumps
     turbulence 0.9
     color_map {
       [0.0 0.6 color rgbft <1,1,1,1,1> color rgbft <1,1,1,1,1>]
       [1.0 color rgbft <0.647059,0.164706,0.164706,0.5,0.5>]
     }
     scale <1.5,3,1>
   }
 }     


#declare Desk_Modest_Side_Texture = texture {
  T_Wood30
  scale 1 + rand(r1) * 1
  translate rand(r1) * 2 - 1
  rotate <rand(r1) * 5 - 2.5,0,0>
}

#declare Desk_Leg_Texture = texture {
  T_Wood30
  scale 3.5 + rand(r1) * 1
  translate rand(r1) * 2 - 1
  rotate <90,0,0>
}
texture {
   pigment {
     bumps
     turbulence 0.6
     color_map {
       [0.0 0.7 color rgbft <1,1,1,1,1> color rgbft <1,1,1,1,1>]
       [1.0 color rgbft <0.647059,0.164706,0.164706,0.5,0.5>]
     }
     scale <1,2,1>
   }
 }     
