#ifndef (Color1)
  #declare Color1 = Black
#end

#ifndef (Color2)
  #declare Color2 = Black
#end

#ifndef (Color3)
  #declare Color3 = rgbt<0.9,0.9,0,0.25>
#end

#ifndef (Color4)
  #declare Color4 = rgbt<0.9,0.9,0,0.25>
#end

#ifndef (rjButterflySeed)
  #declare rjButterflySeed = seed(42)
#end

#ifndef (WingSize)
  #declare WingSize = 1
#end

#declare rjWingTexture = texture {
  pigment {
    marble
    turbulence 0.75
    color_map {
      [0.0 0.3 color Color1 color Color2 ]
      [0.3 1.0 color Color3 color Color4 ]
    }
  }

}
texture {
  pigment {
    marble
    turbulence 0.75
    color_map {
      [0.0 0.1 color Black color Black]
      [0.1 1.0 color rgbft<1,1,1,1,1> color rgbft<1,1,1,1,1>]
    }
  }
  scale 1/12
}

#declare rjBodyTexture = texture {
  pigment { color Black }
}

#declare rjSmallWing = union {
  sphere {
   <0.5,0.5,0> 0.5
  }
  cone {
   <0.4,0.4,0> 0.45
   <0.05,0.2,0> 0.025
  }
  sphere {
    <0.3,-0.2,0> 0.3
  }
  cone {
    <0.15,-0.15,0> 0.25
    <0.05,0.2,0> 0.025
  }
  scale <1.25,1,0.001>
  texture {
    rjWingTexture
    translate <7 * rand(rjButterflySeed),7 * rand(rjButterflySeed),7 * rand(rjButterflySeed)>
  }
}

#declare rjLargeWing = union {

  cone {
   <0.8,0.3,0> 0.75
   <0.05,0.3,0> 0.025

   clipped_by {
     box {
       <0,0.3,-0.8>
       <0.8,1.2,0.8>
     }
   }
  }
  sphere {
    <0.4,0.15,0.0> 0.27
    scale <2,1,1>
    rotate <0,0,45>
  }

  sphere {
    <0.3,0.4,0> 0.24
    scale <1.6,1,1>
    rotate <0,0,3>
  }

  sphere {
    <0,0,0> 0.28
    scale <1.15,1,1>
    rotate <0,0,-60>
    translate <0.475,-0.1,0>
  }

  cone {
   <0.5,0.15,0> 0.6
   <0.05,0.29,0> 0.025
  }

  scale <1.5,1,0.001>
  texture {
    rjWingTexture
    translate <7 * rand(rjButterflySeed),7 * rand(rjButterflySeed),7 * rand(rjButterflySeed)>
  }
}

#if (WingSize = 0)
  #declare rjWing = rjSmallWing
#else
  #declare rjWing = rjLargeWing
#end

#declare rjAntena = object {
  torus {
    0.25, 0.01
    clipped_by {
      box {
        <0,0.1,0>
        <1.2,-0.1,-1.2>
      }
    }
    rotate <65,0,0>
  }
  texture { rjBodyTexture }
}

#declare LegPrimative = torus {
  0.25, 0.015

  clipped_by {
    box {
      <0,-0.01,-0.26>
      <0.26,0.01,0.26>
    }
  }

  scale <1,1,0.45>
}

#declare rjLegs = union {
  object {
    LegPrimative
    rotate <0,0,25>
    translate <0.05,0.3,0.05>
  }
  object {
    LegPrimative
    translate <0.075,0.25,0.05>
  }
  object {
    LegPrimative
    rotate <0,0,-15>
    translate <0.05,0.2,0.05>
  }
}

#declare rjBody = union {
  sphere {
    <0,0.5,-0.05> 0.09
  }
  object {
    rjAntena
    translate <-0.27,0.575,-0.05>
  }
  object {
    rjAntena
    translate <-0.27,0.575,-0.05>
    scale <-1,1,1>
  }
  sphere {
    <0,0.1,-0.05> 0.09
    scale <1,2.5,1>
  }
  object {
    rjLegs
  }
  object {
    rjLegs
    scale <-1,1,1>
  }
  sphere {
    <0,-0.035,-0.05> 0.085
    scale <1,3.5,1>
  }
  texture { rjBodyTexture }
}

#declare rjWingAngle = (rand(rjButterflySeed) * 70) + 10

#declare rjButterfly = union {
  object {
    rjBody
    translate <0,0,0.06>
  }
  object {
    rjWing
    translate <0,0,0>
    rotate <0,rjWingAngle,0>
  }
  object {
    rjWing
    translate <0.01,0,0>
    rotate <0,rjWingAngle,0>
    scale <-1,1,1>
  }
}
