// Include files

#include "finish.inc"
#include "metals.inc"
#include "colors.inc"
#include "glass.inc"
#include "woods.inc"
#include "textures.inc"

global_settings {
  assumed_gamma 1
  radiosity {
    //brightness FLOAT
    //count INTEGER
    
    count 1300
    
    distance_maximum 3 // 30
    
    error_bound 0.25
    //gray_threshold FLOAT
    low_error_factor 0.6
    //minimum_reuse FLOAT
    //nearest_count INTEGER
    
    nearest_count 8
    recursion_limit 1
  }
}

camera {
  location  <-8,  6.5, 1>
  look_at   <-9, 5, -10>
}
light_source {
  <-8,7,4.5>
  color White * 0.05
  shadowless
}
light_source {
  <-30,16,-20>
  color White
  atmospheric_attenuation on
}

/*******************************************************/
/*                      ROOM                           */
/*******************************************************/

//#declare USE_ATMOSPHERE = 1
#declare USE_WINDOWS = 1
#declare USE_SKY_AND_GROUND = 1
#declare USE_FURNISHINGS = 1
//#declare Area_Light = 1

#declare RoomWidth = 40
#declare RoomLength = 60

/***   Floor   ***/

// Declare Vars For Floor
#declare PlankWidth = 1
#declare PlankThick = 0.25
#declare PlankLength= 10
#declare PlankTexture = texture { T_Wood8 } //1,2,3,8

#declare FloorWidth  = RoomWidth
#declare FloorLength = RoomLength

#declare FitQuality = 0.03  // Lower the higher the fit quality
#declare BoardQuality = 10  // Lower the less the boards twist

#include "floor.inc"

Floor

/***   End Floor   ***/

/*** Wall ***/

#include "roomwalls.inc"

Walls
RoomMolding

/*** End Wall ***/

/***   Window   ***/

#ifdef (USE_WINDOWS)

#declare PaneTexture = texture {
  /*
  T_Old_Glass
  */
  NBoldglass
/*
  normal {
    waves
    //frequency 0.2
    turbulence 0.2
//    scale <2,3,0.1>
  }
*/
}

#declare WindowTexture = texture {
  pigment { color DarkBrown }
  finish { Shiny specular 0.8}
  normal {
    ripples
    frequency 0.6
    turbulence 0.75
    scale < 0.01,2,0.01 >
  }
}

#declare WindowWidth = 8
#declare WindowFrameDepth = 0.75
#declare WindowFrameThick = 0.4
#declare LipDepth = 0
#declare NumberWindows = 2
#declare PaneColumns = 4
#declare WindowState = 1

#include "window.inc"

light_source {
  <RoomWidth/2,
   WallHeight * 0.25+WindowHeight-WindowFrameHeight/2,
   RoomLength/2- (WindowSideOffset + WindowSpacing)>
  color White * 0.1
  shadowless
#ifdef (Area_Light)
  area_light  y, z, 8,8
#end
}

object {
  WindowWithFrame
  rotate<0,90,0>
  translate<-RoomWidth/2,
//             WallHeight * 0.25+WindowHeight-WindowFrameHeight/2,
             WallHeight * 0.25 + WindowHeight-WindowFrameHeight/2 + 0.05,
             RoomLength/2- (WindowSideOffset + WindowSpacing)>
}

#declare WindowState = 0
#include "window.inc"

object {
  WindowWithFrame
  rotate<0,90,0>
  translate<-RoomWidth/2,
             WallHeight * 0.25+WindowHeight-WindowFrameHeight/2,
             RoomLength/2 - WindowSideOffset>
}

#end
/***   End Window   ***/

/***   Ceiling   ***/
#declare CeilingTexture = texture { pigment { color White } }

object {
  box {
    <0-FloorWidth/2,WallHeight-0.5,0-FloorLength/2>
    <FloorWidth/2,WallHeight,FloorLength/2>
  }
  texture { CeilingTexture }
}
/***   End Ceiling   ***/
/***   Atmosphere   ***/
#ifdef (USE_ATMOSPHERE)
 box { -0.5,0.5
    pigment { colour rgbt <1, 1, 1, 1> }
    halo {
      dust
      dust_type 4
      box_mapping
      linear
      //constant
      turbulence 1
      colour_map {
        [ 0 color rgbt <1, 0.8, 0.7, 1.0> ]
        [ 1 color rgbt <1, 0.8, 0.7, 0.78> ]
      }
      samples 50
      aa_level 3
      aa_threshold 0.2
      jitter 0.1
    }
    hollow
    scale <RoomWidth,WallHeight,RoomLength>
    translate <0,WallHeight/2,0>
  }
#end
/***   End Atmosphere   ***/

/*************************************************/
/*                  End Room                     */
/*************************************************/


/*** Furnishings ***/

/***   Big Chalk Board ***/
#declare ChalkBoardHeight = 12
#declare ChalkBoardWidth = 23

#include "bookshlf.inc"
object { bookshelf
  rotate <0,90,0>
  translate <-17.5,0,-16>
}

#declare ChalkBoardTexture = texture {
  pigment {
    image_map { tga "chlkbrd.tga" }
    translate <-0.5,-0.5,0>
    scale <-23,12,1>
//    translate <2,1,0>
  }
  normal {
    crackle
    turbulence 0.80
    scale 2
  }
}

#declare CBFrameTexture = texture { T_Wood8 rotate 90 * y }

#include "chlkbrd.inc"

object {
  ChalkBoard
  translate <0,13,-RoomLength/2 + CBFrameThick>
}
/***   End Big Chalk Board   ***/



#include "stool.inc"
object {
  chair
  rotate <0,35,0>
  translate <-17,3,-26>
}

// Dunce Cap Primative
#include "dunce.inc"
object {
  Dunce_Cap
  rotate <0,32,0>
  translate <-16.5,8.5,-25.5>
}

#include "tdesk.inc"
object {
  tdesk
  rotate 170*y
  translate <0.5,0,-18>
 }

#include "sdesktop.inc"

Student_Desktop

/*** Outside ***/

#include "rjBttrfly.inc"

object {
  rjButterfly
  scale 2/3 // 1/2
  rotate <90,0,0>
  translate <-RoomWidth/2 + 0.7,
             WallHeight * 0.25 + 0.55,
             RoomLength/2-(WindowSideOffset+WindowSpacing)-1>
}         

#include "flock.inc"


object {
  flock
  rotate -150*y // -130
  translate <-RoomWidth/2 - 4 - 1.5,
             WallHeight * 0.25+WindowHeight-WindowFrameHeight/2 -3  - 2,
             RoomLength/2- (WindowSideOffset + WindowSpacing)-1 - 2>
}


#declare CloudColors = color_map {
   [0.0 0.4 color SkyBlue color SkyBlue]
   [0.80 color rgb <3/5, 3/5, 2/3>] // 4/5 4/5 5/6
   [1.0 color White]
}

//#ifdef (USE_SKY_AND_GROUND)

sky_sphere {
   pigment{
      bozo
      turbulence 0.6
      octaves 3
      lambda 6
      color_map { CloudColors }
   }
   scale 1/8
}

plane {
  y,0
  pigment {
    bozo
    turbulence 0.6
    color_map {
      [0.0 0.3 color Green color Green]
      [0.7 color <0,0.7,0>]
      [1.0 color <0,0.4,0>]
    }
    scale 1/4
  }
  hollow
}

//#end
/*** End Outside ***/
