
#ifndef(NumSegs)
  #declare NumSegs = 36
#end
#ifndef(NumRevs)
  #declare NumRevs = 4
#end
#ifndef(SpiralRadius)
  #declare SpiralRadius  = 1
#end
#ifndef(Segment)
  #declare Segment = cylinder {
    <-0.05,0,-0.5> <-0.05,0,0.5>, 0.1
    scale <1,0.4,1>
  }
#end
#ifndef(SpiralTexture)
  #declare SpiralTexture = texture { pigment { color <1,1,1> } }
#end


#declare FudgeFactor = (NumSegs/NumRevs) - 1
#declare RotateAngle = 360/NumSegs
#declare TanRotateAngle = tan(radians(RotateAngle))

#declare SegAngle = 360/(NumSegs * NumRevs)


#declare RevGap = (2 * SpiralRadius)/NumRevs
#declare SegChange = RevGap / NumSegs
#declare YChange = RevGap/(NumSegs + 1)
#declare XChange = sin(YChange/SpiralRadius)

#declare Spiral = union {
  #declare Passes = 0
  #declare YPos = -SpiralRadius
  while (YPos <= SpiralRadius)
    #declare r= cos(YPos) * SpiralRadius
    object {
      Segment

      scale <1,1,r * TanRotateAngle>
      #if(YPos<=0)
        rotate  <FudgeFactor*degrees(atan2(YChange,abs(r))),-2*degrees(atan2(XChange,abs(r))),0>
      #else
        rotate  <FudgeFactor*degrees(atan2(YChange,abs(r))),2*degrees(atan2(XChange,abs(r))),0>
      #end
      translate <abs(r),YPos,0>
      rotate mod(RotateAngle * Passes,360) * y
    }
    #declare YPos = YPos + SegChange
    #declare Passes = Passes + 1
  #end

  texture { SpiralTexture }
}
