/*
expects
  x1,y1    Starting position
  x2,y2    Ending Position
*/

#if (x1 < x2)
  #declare mx1 = x1
  #declare mx2 = x2
#else
  #declare mx1 = x2
  #declare mx2 = x1
#end

#if (y1 < y2)
  #declare my1 = y1
  #declare my2 = y2
#else
  #declare my1 = y2
  #declare my2 = y1
#end



#declare sl = sqrt((mx2-mx1)*(mx2-mx1) + (my2-my1)*(my2-my1))
#declare scx = (mx1 + mx2) / 2
#declare scy = (my1 + my2) / 2
#declare sca = degrees(atan2((y2-y1),(x2-x1)))

#ifndef (stickrand)
  #declare stickrand = seed(42)
#end

#declare sw = 0.1 + rand(stickrand) * 0.1

#declare stick = object {
  box { <-sl/2,-sw,-sw> <sl/2,sw,sw> }
  rotate <rand(stickrand) * 10 + 35,0,0>
  rotate <0,0,sca>
  translate <scx,scy,0>
}

#declare x1=x2
#declare y1=y2


