#declare stool_clipper = union {
  torus { 1.6 0.2 }
  cylinder { <0,-0.2,0> <0,0.2,0> 1.6}
}

// create a box that extends between the 2 specified points
#declare seat = union {
  #declare r1 = seed(0)

  #declare i = 5
  #while (i > 0)
    #declare boardwidth = .8
    #declare plank = box {
      <-0.4, -0.2, -2>  // one corner position <X1 Y1 Z1>
      < 0.4,  0.2,  2>  // other corner position <X2 Y2 Z2>
    }
    intersection {
      object { plank
        // rotate <0,0,rand(r1) * 6 - 3>
        translate <(i-3) * boardwidth,0,0>
      }
      object { stool_clipper  scale 1.1 }
      texture { T_Wood1
                scale 3.5 + rand(r1) * 1
                translate rand(r1) * 2 - 1
                rotate <0,rand(r1) * 40 - 20,0>
              }
    }
    #declare i = i - 1
  #end
}

#declare rod = object {
  cylinder { <0,-3,0> <0,3,0> 0.25 }

  texture { T_Wood1
    scale 3.5 + rand(r1) * 1
    rotate <90,0,0>
  }
}


#declare chair = union {
  object { seat translate <0,3,0> }
  #declare la = 10
  #declare ld = 1.5

  #declare support = union {
    cylinder { <-1.8,-1,0> <1.8,-1,0> 0.2
      texture { T_Wood1
        scale 3.5 + rand(r1) * 1
        rotate <0,90,0>
      }
    }
    cylinder { <-1.4,1,0> <1.4,1,0> 0.165
      texture { T_Wood1
        scale 3.5 + rand(r1) * 1
        rotate <0,90,0>
      }
    }
    rotate <la,0,0>
  }

  object { support rotate <0,  0,0> translate <0,0,-ld> }
  object { support rotate <0, 90,0> translate <-ld,0,0> }
  object { support rotate <0,180,0> translate <0,0,ld> }
  object { support rotate <0,270,0> translate <ld,0,0> }

  object { rod
    rotate <-la,0,-la>
    translate <-ld,0,ld>
  }

  object { rod
    rotate <-la,0,la>
    translate <ld,0,ld>
  }

  object { rod
    rotate <la,0,-la>
    translate <-ld,0,-ld>
  }

  object { rod
    rotate <la,0,la>
    translate <ld,0,-ld>
  }

}


