// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "WOODS.INC"
//#include "METALS.INC"

#declare tabletop = union {
  #declare bc = 10     // board count
  #declare bx = 1.5   // board x
  #declare by = 0.6   // board y
  #declare bz = 8     // board z

  #declare dv_x = (bc * bx) * 0.5 // desk veneer
  #declare dv_y = by * 0.5
  #declare dv_z = bz * 0.5

  #declare di_x = dv_x * 1.05
  #declare di_y = dv_y * 1.1
  #declare di_z = dv_z * 1.1

  #declare clip_cyl = union {
    cylinder {
      <-dv_x*0.95,0,-dv_z * 0.85> <dv_x*0.95,0,-dv_z * 0.85> 0.3
      scale <1,0.5,1>
    }
    sphere {
      <-dv_x*0.95,0,-dv_z * 0.85> 0.3
      scale <1,0.5,1>
    }
    sphere {
      < dv_x*0.95,0,-dv_z * 0.85> 0.3
      scale <1,0.5,1>
    }
  }

  #declare desk_veneer = object {
    difference {
      union {
        box { <-di_x,-di_y,-di_z> < di_x, di_y, di_z>  }
        cylinder { <-di_x,0, di_z> < di_x,0, di_z> di_y }
        cylinder { <-di_x,0,-di_z> < di_x,0,-di_z> di_y }
        cylinder { <-di_x,0,-di_z> <-di_x,0, di_z> di_y }
        cylinder { < di_x,0,-di_z> < di_x,0, di_z> di_y }
        sphere { < di_x,0, di_z> di_y }
        sphere { < di_x,0,-di_z> di_y }
        sphere { <-di_x,0, di_z> di_y }
        sphere { <-di_x,0,-di_z> di_y }
      }
      object { clip_cyl translate <0,dv_y * 0.99,0> }
    }

    texture {

      pigment {
        P_WoodGrain7A
        turbulence 0.05
        color_map { M_Wood7A }
        rotate 92*y
      }
      normal {
       bump_map { tga "desktop.tga" }
       translate <-0.5,-0.5, 0 >
       scale <-10,10,1>
       rotate -90 * x
     }

    }

    texture {

      pigment {
        P_WoodGrain7B
        turbulence 0.05
        color_map { M_Wood7B }
        rotate 92*y
      }
      normal {
        bump_map { tga "desktop.tga" }
        translate <-0.5,-0.5, 0 >
        scale <-10,10,1>
        rotate -90 * x
      }

    }

    texture {
      pigment {
        bumps
        turbulence 0.9
        color_map {
          [0.0 0.6 color rgbft <1,1,1,1,1> color rgbft <1,1,1,1,1>]
          [1.0 color rgbft <0.647059,0.164706,0.164706,0.5,0.5>]
        }
        translate <-1,0,0>
        scale <4,3,1>
      }
    }   
   
  }

  #declare desk_inner_plank = box {
    <-bx/2, -by/2, -bz/2>
    < bx/2,  by/2,  bz/2>
  }

  object { desk_veneer }

  union {
    #declare i = bc
    #while (i > 0)
      #include "mytects.inc"
      difference {
        object { desk_inner_plank
          translate <(i-((bc + 1)/2)) * bx,0,0>
        }
        object { clip_cyl translate <0,dv_y * 0.75 /* 1.01 */,0> }
        texture {
          Desk_Top_Texture
          rotate 90 * z
        }
      }
      #declare i = i - 1
    #end
  }
}

/*
#declare graphiti = union {

  #declare x1 = 1
  #declare y1 = 5
  #declare x2 = 4
  #declare y2 = 7
  #include "stick.inc"
  object { stick }
  #declare x2 = 5
  #declare y2 = 5
  #include "stick.inc"
  object { stick }
  #declare x2 = 7
  #declare y2 = 7
  #include "stick.inc"
  object { stick }
  #declare x2 = 8
  #declare y2 = 6
  #include "stick.inc"
  object { stick }
  #declare x2 = 6
  #declare y2 = 0
  #include "stick.inc"
  object { stick }
  #declare x2 = 1
  #declare y2 = 3.5
  #include "stick.inc"
  object { stick }
  #declare x2 = 1
  #declare y2 = 5
  #include "stick.inc"
  object { stick }

  texture { Glass3 }
  rotate <90,0,0>
  translate <-4,0,-4>
}

#declare carved_desk = difference {
  object { tabletop }
  object { graphiti
    rotate <0,208,0>
    scale <1/4,1/2,1/4>
    translate <5,di_y,-2>
  }
}
*/

#declare student_desk = object { // union {
  object { tabletop }
//  object { legs }
}


/*
          [0.10 color rgbf <0.49020, 0.22353, 0.00000, 0.00>]
          [0.16 color rgbf <0.71863, 0.69412, 0.46275, 0.00>]
          [0.20 color rgbf <0.49020, 0.22353, 0.00000, 0.00>]
          [0.25 color rgbf <0.76863, 0.69412, 0.46275, 0.00>]
          [0.32 color rgbf <0.44020, 0.22353, 0.00000, 0.00>]
          [0.37 color rgbf <0.74863, 0.69412, 0.46275, 0.00>]
          [0.40 color rgbf <0.49020, 0.20353, 0.00000, 0.00>]
          [0.45 color rgbf <0.76863, 0.66412, 0.48275, 0.00>]
          [0.51 color rgbf <0.49020, 0.22353, 0.00000, 0.00>]
          [0.55 color rgbf <0.76863, 0.67059, 0.37255, 0.00>]
          [0.61 color rgbf <0.49020, 0.25353, 0.00000, 0.00>]
          [0.65 color rgbf <0.76863, 0.67059, 0.37255, 0.00>]
          [0.70 color rgbf <0.49020, 0.22353, 0.00000, 0.00>]
          [0.75 color rgbf <0.76863, 0.63059, 0.37255, 0.00>]
          [0.82 color rgbf <0.49020, 0.22353, 0.00000, 0.00>]
          [0.88 color rgbf <0.77863, 0.67059, 0.37255, 0.00>]
          [0.91 color rgbf <0.49020, 0.22353, 0.00000, 0.00>]
          [0.95 color rgbf <0.79863, 0.67059, 0.39550, 0.00>]
          [1.00 color rgbf <0.48020, 0.22353, 0.00000, 0.00>]
*/
