#ifndef (WallLength)
  #declare WallLength = 20
#end
#ifndef (WallThick)
  #declare WallThick = 1
#end
#ifndef (WallHeight)
  #declare WallHeight = 16
#end

#ifndef (NumberWindows)
  #declare NumberWindows = 2
#end
#ifndef (WindowWidth)
  #declare WindowWidth = 8
#end
#ifndef (WindowHeight)
  #declare WindowHeight = 12
#end
#ifndef (WindowBaseOffset)
  #declare WindowBaseOffset = WallHeight * 0.24
#end
#ifndef (WindowSideOffset)
  #declare WindowSideOffset = 5
#end
#ifndef (WindowSpacing)
  #declare WindowSpacing = 10
#end

#ifndef (NumberBeams)
  #declare NumberBeams = 2
#end
#ifndef (BeamWidth)
  #declare BeamWidth = 2
#end
#ifndef (BeamThick)
  #declare BeamThick = 5
#end
#ifndef (BeamSideOffset)
  #declare BeamZOffset = 10
#end
#ifndef (BeamSpacing)
  #declare BeamSpacing =  15
#end

#ifndef (WallTexture)
  #declare WallTexture = texture { pigment { color <1,1,0.8> } }
#end


#declare MoldingThick = 1.0 //0.5

#declare MoldingPrim = object {
  box { <-0.5,-0.5,-MoldingThick/2> <0.5,0.5,MoldingThick/2> }
}

#declare WallPanel = object {
  box {
    <-WallLength/2,WallHeight,-WallThick/2> <WallLength/2,0,WallThick/2>
  }
}

#declare WallMolding = object {
    MoldingPrim
    translate <0,0.5,MoldingThick>
    scale <WallLength,1,1>
}

#if (NumberWindows > 0)
  #declare WindowCutOut = object {
    box {
      <-WindowWidth/2,WindowHeight,-WallThick> <WindowWidth/2,0,WallThick>
    }
  }

  #declare BaseWall = difference {
    object {
      WallPanel
    }
    #declare WindowCount = 0
    #while (WindowCount < NumberWindows)
      object {
        WindowCutOut
        translate <-WallLength/2 + WindowSideOffset + (WindowSpacing*WindowCount),
                    WindowBaseOffset,0>
      }
      #declare WindowCount = WindowCount + 1
    #end
  }
#else
  #declare BaseWall = WallPanel
#end

#declare WallSeed = seed(232)

#if (NumberBeams > 0)
  #declare Beam = object {
    box {
      <-BeamWidth/2,WallHeight,-BeamThick/2> <BeamWidth/2,0,BeamThick/2>
    }
  }

  #declare Wall = union {
    object {
      BaseWall
    }
    #declare BeamCount = 0
    #while (BeamCount < NumberBeams)
      object {
        Beam
        translate <-WallLength/2 + BeamSideOffset + (BeamSpacing*BeamCount),0,0>
      }
      #declare BeamCount = BeamCount + 1
    #end
  }
#else
  #declare Wall = object {
    BaseWall
  }
#end

#if (NumberBeams > 0)
  #declare BeamMolding = union {
    object {
      MoldingPrim
      translate <0,0.5,BeamThick/2>
      scale <BeamWidth+MoldingThick,1,1>
    }
    object {
      MoldingPrim
      rotate <0,-90,0>
      translate <-BeamWidth/2,0.5,0>
      scale <1,1,BeamThick+MoldingThick>
    }
    object {
      MoldingPrim
      rotate <0,90,0>
      translate <BeamWidth/2,0.5,0>
      scale <1,1,BeamThick+MoldingThick>
    }
  }

  #declare Molding = union {
    object {
      WallMolding
    }
    #declare BeamCount = 0
    #while (BeamCount < NumberBeams)
      object {
        BeamMolding
        translate <-WallLength/2 + BeamSideOffset + (BeamSpacing*BeamCount),0,0>
      }
      #declare BeamCount = BeamCount + 1
    #end
  }
#else
  #declare Molding = object {
    WallMolding
  }
#end
