#ifndef (PaneWidth)
  #declare PaneWidth = 2
#end
#ifndef (PaneHeight)
  #declare PaneHeight = 3
#end
#ifndef (PaneThick)
  #declare PaneThick = 0.1
#end

#ifndef (PaneRows)
  #declare PaneRows = 2
#end
#ifndef (PaneColumns)
  #declare PaneColumns = 3
#end

#ifndef (PaneTexture)
  #declare PaneTexture = texture { pigment { color rgbt<1,1,1,0.9> } }
#end

#ifndef (WindowTexture)
  #declare WindowTexture = texture { pigment { color <1,1,1> } }
#end

#ifndef (SparThick)
  #declare SparThick = 0.25
#end

#ifndef (FrameThick)
   #declare FrameThick = 0.5
#end


#ifndef (NumberWindows)
  #declare NumberWindows = 2
#end
#ifndef (WindowFrameThick)
  #declare WindowFrameThick = 0.25
#end
#ifndef (WindowFrameDepth)
  #declare WindowFrameDepth = 2
#end
#ifndef (LipDepth)
  #declare LipDepth = 1
#end

#ifndef (WindowState)
  #declare WindowState = 0
#end

// Internal Vars
#declare FrameWidth = PaneWidth * PaneColumns
#declare FrameHeight = PaneHeight * PaneRows
#declare WindowSeed = seed(6350)

#declare SparPrimative = difference {
  box { -0.5,0.5 }
  cylinder {
    <-0.5,-0.5,0.5> <0.5,-0.5,0.5> 0.25
  }
  cylinder {
    <-0.5,0.5,0.5> <0.5,0.5,0.5> 0.25
  }
}

#declare HSpar = object {
  SparPrimative
  scale<FrameWidth,SparThick,SparThick>
  texture { WindowTexture }
}

#declare VSpar = object {
  SparPrimative
  rotate<0,0,90>
  scale <SparThick,FrameHeight,SparThick>
  texture {
    WindowTexture
    rotate<0,0,90>
  }
}

#declare Frame = union {
  // Top
  box {
    <-FrameWidth/2,-FrameHeight/2,-FrameThick/2>
    <FrameWidth/2,-FrameHeight/2+FrameThick/2,FrameThick/2>
    texture {
      WindowTexture
      translate <rand(WindowSeed)*10,rand(WindowSeed)*10,rand(WindowSeed)*10>
    }
  }
  // Bottom
  box {
    <-FrameWidth/2,FrameHeight/2,-FrameThick/2>
    <FrameWidth/2,FrameHeight/2-FrameThick/2,FrameThick/2>
    texture {
      WindowTexture
      translate <rand(WindowSeed)*10,rand(WindowSeed)*10,rand(WindowSeed)*10>
    }
  }
  // Left
  box {
    <-FrameWidth/2,-FrameHeight/2,-FrameThick/2>
    <-FrameWidth/2+FrameThick/2,FrameHeight/2,FrameThick/2>
    texture {
      WindowTexture
      rotate <0,0,90>
      translate <rand(WindowSeed)*10,rand(WindowSeed)*10,rand(WindowSeed)*10>
    }
  }
  // Right
    box {
    <FrameWidth/2,-FrameHeight/2,-FrameThick/2>
    <FrameWidth/2-FrameThick/2,FrameHeight/2,FrameThick/2>
    texture {
      WindowTexture
      rotate <0,0,90>
      translate <rand(WindowSeed)*10,rand(WindowSeed)*10,rand(WindowSeed)*10>
    }
  }
}

// Window Frame

#declare WindowFrameHeight = FrameHeight * NumberWindows

#declare WindowFrame = union {
  // Bottom
  box {
    <-FrameWidth/2,-WindowFrameHeight/2-WindowFrameThick/2,-WindowFrameDepth/2>
    <FrameWidth/2,-WindowFrameHeight/2+WindowFrameThick/2,WindowFrameDepth/2+LipDepth>
    texture { WindowTexture }
  }
  // Top
  box {
    <-FrameWidth/2,WindowFrameHeight/2+WindowFrameThick/2,-WindowFrameDepth/2>
    <FrameWidth/2,WindowFrameHeight/2-WindowFrameThick/2,WindowFrameDepth/2>
    texture { WindowTexture }
  }
  // Left
  difference {
    box {
      <-FrameWidth/2-WindowFrameThick/2,-WindowFrameHeight/2,-WindowFrameDepth/2>
      <-FrameWidth/2+WindowFrameThick/2,WindowFrameHeight/2,WindowFrameDepth/2>
    }
    box {
      <-FrameWidth/2,-WindowFrameHeight/2,-FrameThick/2>
      <-FrameWidth/2+WindowFrameThick,WindowFrameHeight/2,FrameThick/2>
    }
    texture {
      WindowTexture
      rotate <0,0,90>
    }
  }
  // Right
  difference {
    box {
      <FrameWidth/2-WindowFrameThick/2,-WindowFrameHeight/2,-WindowFrameDepth/2>
      <FrameWidth/2+WindowFrameThick/2,WindowFrameHeight/2,WindowFrameDepth/2>
    }
    box {
      <FrameWidth/2,-WindowFrameHeight/2,-FrameThick/2>
      <FrameWidth/2-WindowFrameThick,WindowFrameHeight/2,FrameThick/2>
    }
    texture {
      WindowTexture
      rotate <0,0,90>
    }
  }
}

#declare Window = union {
    object { Frame }

    #declare ColCount = 0
    #while (ColCount < PaneColumns - 1)
      object {
        VSpar
        translate <((PaneWidth*ColCount)-FrameWidth/2) + PaneWidth,0,0 >
      }
      #declare ColCount = ColCount + 1
    #end

    #declare RowCount = 0
    #while (RowCount < PaneRows - 1)
      object {
        HSpar
        translate <0,((PaneHeight*RowCount)-FrameHeight/2) + PaneHeight,0>
      }
      #declare RowCount = RowCount + 1
    #end

    #declare RowCount = 0
    #while (RowCount < PaneRows)
      #declare ColCount = 0
      #while (ColCount < PaneColumns)
        object {
          box {
            <-PaneWidth/2+SparThick/2,-PaneHeight/2+SparThick/2,-PaneThick/2>
            <PaneWidth/2-SparThick/2,PaneHeight/2-SparThick/2,PaneThick/2>
          }
          texture {
            PaneTexture
            translate <rand(WindowSeed)*10,rand(WindowSeed)*10,rand(WindowSeed)*10>
          }
          translate <PaneWidth*ColCount-FrameWidth/2+PaneWidth/2,PaneHeight*RowCount-FrameHeight/2+PaneHeight/2,0>
        }
        #declare ColCount = ColCount + 1
      #end
      #declare RowCount = RowCount + 1
    #end
}

#declare WindowWithFrame = union {
  object { WindowFrame }

  #declare WindowCount = 0
  #while (WindowCount < NumberWindows)
    object {
      Window
      #if (WindowState = 1)
        translate <0,
                   (WindowFrameHeight-FrameHeight)/2-(FrameHeight*0.55*WindowCount),
                   -FrameThick+(FrameThick/2*WindowCount)>
      #else
        translate <0,
                   (WindowFrameHeight-FrameHeight)/2-(FrameHeight*WindowCount),
                   -FrameThick+(FrameThick/2*WindowCount)>
      #end
    }
    #declare WindowCount = WindowCount + 1
  #end
}
