#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare BackGroundNebula = object{
	sphere{
		<0,0,0>,1
		texture{pigment {White filter 1.0}}
		hollow
		halo{
			emitting
			box_mapping
			linear
			turbulence 1.5
			color_map{
				[0.2 color rgbt <1, 0, 0,  1.0>]
				[0.7 color rgbt <0,1,1,-1>]
				[1 color rgbt <1, 1, 0, 1>]
				}
			 samples 100
			 scale <0.5,0.85,0.5>
			 }
		scale <250,400,20>
		}
	translate<0,-50,0>
	}

#declare EngineExhaust = object{
	cylinder{
		0*y,  1*y,  1
		texture{pigment {White filter 1.0}}
		hollow
		halo{
			emitting
			spherical_mapping
			linear
			turbulence .25
			color_map{
				[0 color rgbt <0, 1, 0,  1.0>]
				[0.6 color rgbt <0,0,1,-1>]
				[1 color rgbt <0, 0, 1, -1>]
				}
			 samples 100
			 rotate<0,90,0>
			 scale <0.6,0.5,0.6>
			 }
		scale <1.8,9,1.8>
		}
	}

#declare ShipNose = union{
	cone{
		-1.5*x,0.1, -1.75*x,0
		texture{
			pigment{Pine_Wood}
			scale 0.1
			}
		}
	cone{
		-1.75*x,0.01, -1.65*x,0.04
		texture{pigment{Gray20}
			finish{Luminous}}
		}
	finish{ambient 0.5}
	scale <35,28.75,28.75>
	rotate<0,0,90>
	}

#declare PencilBodyTexture = texture{
	pigment{
		brick color SteelBlue, color Gray
		brick_size <2,0.75,0.75>   // size of brick
		mortar 0.2  // width of mortar
		}
	normal{crackle 0.5}
	finish{metallic on}
	scale 0.1
	}
	texture{
		pigment{
			brick color White filter 1.0, color SteelBlue
			brick_size <1,2,2>
			mortar 0.4
			}
		scale 0.1
		}

//#declare PencilBodyTexture = texture{pigment{Yellow}}

#include "pencil2.inc"

#declare EngineStrut = union{
	object{Pencil //Strut1_0
		scale<0.5,0.1,0.5>
		translate<8,0,0>
		}
	object{Pencil //Strut1_1
		scale<0.5,0.1,0.5>
		translate<7.5,0,0>
		}
	object{Pencil //Strut1_2
		scale<0.5,0.1,0.5>
		translate<7,0,0>
		}
	object{Pencil //Strut1_3
		scale<0.5,0.1,0.5>
		translate<6.5,0,0>
		}
	object{Pencil //Strut1_4
		scale<0.5,0.1,0.5>
		translate<6,0,0>
		}
	object{Pencil //Strut1_5
		scale<0.5,0.1,0.5>
		translate<5.5,0,0>
		}
	object{Pencil //Strut1_6
		scale<0.5,0.1,0.5>
		translate<5,0,0>
		}
	object{Pencil //Strut1_7
		scale<0.5,0.1,0.5>
		translate<4.5,0,0>
		}
	object{Pencil //Strut1_8
		scale<0.5,0.1,0.5>
		translate<4,0,0>
		}
	object{Pencil //Strut1_9
		scale<0.5,0.1,0.5>
		translate<3.5,0,0>
		}
	object{Pencil //Strut1_10
		scale<0.5,0.1,0.5>
		translate<3,0,0>
		}
	}

#declare PencilShipBody = union{
	object{Pencil}
	object{
		Pencil
		translate<1.9,0,0>
		}
	object{
		Pencil
		translate<-1.9,0,0>
		}
	object{
		Pencil
		translate<0.9,0,1.6>
		}
	object{
		Pencil
		translate<-0.9,0,1.6>
		}
	object{
		Pencil
		translate<0.9,0,-1.6>
		}
	object{
		Pencil
		translate<-0.9,0,-1.6>
		}
	object{
		ShipNose
		translate<0,32.7,0>
		}
	}

#declare PencilShip = union{
	object{PencilShipBody scale <1,0.9,1> translate <0,9,0>}
	object{EngineStrut
		rotate<180,0,0>
		translate<0,11,0>
		}
	object{EngineStrut
		rotate<180,180,0>
		translate<0,11,0>
		}
	object{Pencil //Rocket1
		scale <2,0.25,2>
		rotate<180,0,0>
		translate<10,12,0>
		}
	object{Pencil //Rocket2
		scale <2,0.25,2>
		rotate<180,0,0>
		translate<-10,12,0>
		}
	object{EngineExhaust
		scale 2
		translate<-10,17,0>
		}
	object{EngineExhaust
		scale 2
		translate<10,17,0>
		}
	}

camera{
	//location<0,25,0>
	//look_at<0,0,10>
	location  <1 , 28 ,-37>
	look_at   <0.0 , -8 , 1>
	}

light_source{
	0*x
	color red 1.0  green 1.0  blue 1.0
	translate <40, 50, -10>
	shadowless
	}

background{Black}

object{PencilShip
	rotate<-95,30,-20>
	}
object{BackGroundNebula
	translate<0,0,100>
	}

#declare Energy_Formula = union{
	text{
		ttf "arial.ttf" "e=mc",0.25,0
		}
	text{
		ttf "arial.ttf" "2",0.5,0
		scale 0.65
		translate<2.5,0.5,0>
		}
	texture{
		pigment{White}
		finish{Luminous}
		}
	}
#declare Acceleration_Formula = object{
	text{
		ttf "arial.ttf" "d=d0+vt+.5at^2",0.25,0.1*x
		}
	texture{
		pigment{White}
		finish{Luminous}
		}
	}
#declare Plancks_Constant = object{
	text{
		ttf "arial.ttf" "6.62618e-34 J-s",0.15,0
		}
	texture{
		pigment{White}
		finish{Luminous}
		}
	}
#declare Distance_Formula = object{
	text{
		ttf "arial.ttf" "d=rt",0.05,0.2*x
		}
	texture{
		pigment{White}
		finish{Luminous}
		}
	}
#declare Orbit_Energy = object{
	text{
		ttf "arial.ttf" "GMm (1/Re - 1/2Rcirc)",0.25,0
		}
	texture{
		pigment{White}
		finish{Luminous}
		}
	}

object{Energy_Formula
	scale 10
	rotate<45,0,-20>
	translate<40,-40,90>
	}
object{Distance_Formula
	scale 10
	rotate<30,0,0>
	translate<-88,-25,100>
	}
object{Plancks_Constant
	scale 10
	rotate<0,0,45>
	rotate<0,70,0>
	translate<55,-120,98>
	}
object{Acceleration_Formula
	scale 10
	rotate<30,0,0>
	translate<10,-200,100>
	}
object{Orbit_Energy
	scale 10
	rotate<20,0,10>
	translate<-70,-85,165>
	}
