
// Persistence of Vision Ray Tracer Scene Description File
// File: fabook.pov
// Vers: 3
// Date: 25/04/97
// Auth: Franck Angella, angella@goelette.tsi.u-bordeaux.fr



#include "colors.inc"
#include "stones.inc"
#include "metals.inc"

camera
{
  location  <0.0 , 6.0 , -2.0>
  look_at   <0.0 , 0.0 , 1.0>
}

light_source
{
  <1.0, -5.0, 0.0>
  color red 0.5  green 1.0  blue 1.0
  shadowless
}

light_source
{
  <1.3, 3.0, -0.5>
  color rgb <3.0, 3.0, 3.0>
  spotlight
  point_at <1.0, 0.0, 0.0>
  radius 80
  tightness 0.5 // 0.1
  falloff 90
  area_light
  <0.1, 0.0, 0.0> <0.0, 0.0, 0.1>
  4, 4
  adaptive 1
  jitter
}

//background { color red 0.1 green 0.3 blue 0.8 }

#declare Sol = plane
{
  y, -10.0
  texture { T_Stone24 finish { reflection 0.7 } }
  /*texture
  {
    pigment { color rgb <0.0, 0.6, 0.4> }
    finish { reflection 0.4 }
  }*/
}

#declare Table = union
{
  box
  {
    <-10.0, -0.1, -1.7>
    <10.5, -0.7, 5.0>
    texture
    {
      pigment { rgbf <0.5, 1.0, 1.0, 0.8> }
      finish
      {
        diffuse 0.0
        reflection 0.35
        refraction 1.0
        ior 1.33
        specular 1.0
        roughness 0.001
      }
    }
  }
  text
  {
    ttf "cyrvetic.ttf"
    "History, Section I."
    0.01, 0
    scale <0.4, 0.4, 0.2>
    rotate 90*x
    translate <0.0, -0.7, -1.0>
    texture { pigment { rgb <0.0, 2.0, 0.0> } finish { ambient 0.7 } }
    no_shadow
  }
  text
  {
    ttf "cyrvetic.ttf"
    "::Prehistory"
    0.01, 0
    scale <0.4, 0.3, 0.2>
    rotate 90*x
    translate <0.0, -0.7, -1.3>
    texture { pigment { rgb <0.0, 2.0, 0.0> } finish { ambient 0.7 } }
    no_shadow
  }
}

#declare X0 = 0.0
#declare Y0 = 0.0
#declare X1 = 0.6
#declare Y1 = 0.7
#declare X2 = 1.3
#declare Y2 = 0.3
#declare X3 = 4.0
#declare Y3 = 0.0
#declare Z0 = 0.0
#declare Z1 = 1.0
#declare Z2 = 2.0
#declare Z3 = 3.0
#declare NbPage = 8.0

#declare Page = bicubic_patch
{
      type 1
      u_steps 3
      v_steps 3
      flatness 0.01
      <X0, Y0, Z0>, <X1, Y1, Z0>, <X2, Y2, Z0>, <X3, Y3, Z0>,
      <X0, Y0, Z1>, <X1, Y1, Z1>, <X2, Y2, Z1>, <X3, Y3, Z1>,
      <X0, Y0, Z2>, <X1, Y1, Z2>, <X2, Y2, Z2>, <X3, Y3, Z2>,
      <X0, Y0, Z3>, <X1, Y1, Z3>, <X2, Y2, Z3>, <X3, Y3, Z3>
      texture
      {
        pigment { White }
        finish { reflection 0.2 }
      }
}

#declare PageSup = bicubic_patch
{
      type 1
      u_steps 3
      v_steps 3
      flatness 0.01
      <X0, Y0, Z0>, <X1, Y1, Z0>, <X2, Y2, Z0>, <X3, Y3, Z0>,
      <X0, Y0, Z1>, <X1, Y1, Z1>, <X2, Y2, Z1>, <X3, Y3, Z1>,
      <X0, Y0, Z2>, <X1, Y1, Z2>, <X2, Y2, Z2>, <X3, Y3, Z2>,
      <X0, Y0, Z3>, <X1, Y1, Z3>, <X2, Y2, Z3>, <X3, Y3, Z3>
//     pigment { Red }
      texture
      {
        pigment
        {
          image_map
          {
            tga "grotte.tga"
            interpolate 2
          }
        }
        finish { reflection 0.2 }
        rotate 90*x
        scale <X3, 1.0, Z3>
      }
      scale <1.0, 1.05, 1.0>
      translate <0.0, 0.3, 0.0>
}

#declare PageSupGarde = bicubic_patch
{
      type 1
      u_steps 3
      v_steps 3
      flatness 0.01
      <X0, Y0, Z0>, <X1, Y1, Z0>, <X2, Y2, Z0>, <X3, Y3, Z0>,
      <X0, Y0, Z1>, <X1, Y1, Z1>, <X2, Y2, Z1>, <X3, Y3, Z1>,
      <X0, Y0, Z2>, <X1, Y1, Z2>, <X2, Y2, Z2>, <X3, Y3, Z2>,
      <X0, Y0, Z3>, <X1, Y1, Z3>, <X2, Y2, Z3>, <X3, Y3, Z3>
//     pigment { Red }
      texture
      {
        pigment { color rgbt<1.0, 1.0, 1.0, 0.6> }
        normal { bumps 0.8 scale 0.15 }
        finish
        {
          phong 1.0
          reflection 0.1
          ambient 0.5
          diffuse 0.2
          caustics 1.0
          irid { 0.35 thickness 0.5 turbulence 0.5 }
        }
      }
      scale <1.0, 1.3, 1.0>
      translate <0.0, 0.35, 0.0>
}

#declare DemiLivre = union
{
  #declare Count = 0
  #while ( Count < NbPage )
    object
    {
      Page
      scale <1.0+0.3*Count/NbPage, 1.0-1.0*Count/NbPage, 1.0>
      translate <0.0, -0.3*Count/NbPage, 0.0>
    }
    #declare Count = Count+1
  #end
  translate <0.0, 0.3, 0.0>
}

#declare Couverture = difference
{
  box
  {
    <-1.3*X3-0.1, -0.2, -0.1>
    <1.3*X3+0.1, 0.0, Z3+0.1>
  }
  cylinder
  {
    <0.0, -0.5, -1.0>
    <0.0, -0.5, Z3+1.0>
    0.35
  }
  cylinder
  {
    <0.2, 0.3, -1.0>
    <0.2, 0.3, Z3+1.0>
    0.35
  }
  cylinder
  {
    <-0.2, 0.3, -1.0>
    <-0.2, 0.3, Z3+1.0>
    0.35
  }
  texture
  {
    pigment { rgb <0.0, 0.4, 0.4> }
    normal { bumps scale 0.1}
    finish { reflection 0.5 }
  }
}

#declare Livre = union
{
  object { DemiLivre }
  object { DemiLivre rotate y*180 translate 3.0*z }
  object { Couverture }
  object { PageSup }
  object { PageSupGarde rotate y*180 translate 3.0*z }
  translate 0.2*y
}


#declare Carte_Maths = union
{
  difference
  {
    box
    {
      <0.0, 0.0, 0.0>
      <2.0, 0.1, 1.0>
      texture { T_Silver_5C }
      //pigment { Gray }
    }
    union
    {
      box
      {
        <0.2, 0.05, 0.2>
        <3.0, 0.2, 0.3>
      }
      box
      {
        <0.2, 0.05, 0.4>
        <0.3, 0.2, 2.0>
      }
      box
      {
        <0.4, 0.05, 0.4>
        <0.5, 0.2, 2.0>
      }
      texture { T_Gold_5C }
      //pigment { Yellow }
    }
  }
  text
  {
    ttf "timrom.ttf"
    "Maths"
    0.05, 0
    scale <0.5, 0.8, 0.2>
    rotate 90*x
    translate <0.6, 0.12, 0.4>
    pigment { Gray }
  }
}

#declare Carte_Bio = union
{
  difference
  {
    box
    {
      <0.0, 0.0, 0.0>
      <2.0, 0.1, 1.0>
      texture { T_Silver_5C }
      //pigment { Gray }
    }
    union
    {
      box
      {
        <0.2, 0.05, 0.2>
        <3.0, 0.2, 0.3>
      }
      box
      {
        <0.2, 0.05, 0.4>
        <0.3, 0.2, 2.0>
      }
      box
      {
        <0.4, 0.05, 0.4>
        <0.5, 0.2, 2.0>
      }
      texture { T_Gold_5C }
      //pigment { Yellow }
    }
  }
  text
  {
    ttf "timrom.ttf"
    "Bio"
    0.05, 0
    scale <0.5, 0.8, 0.2>
    rotate 90*x
    translate <0.6, 0.12, 0.4>
    pigment { Gray }
  }
}

#declare Carte_Art = union
{
  difference
  {
    box
    {
      <0.0, 0.0, 0.0>
      <2.0, 0.1, 1.0>
      texture { T_Silver_5C }
      //pigment { Gray }
    }
    union
    {
      box
      {
        <0.2, 0.05, 0.2>
        <3.0, 0.2, 0.3>
      }
      box
      {
        <0.2, 0.05, 0.4>
        <0.3, 0.2, 2.0>
      }
      box
      {
        <0.4, 0.05, 0.4>
        <0.5, 0.2, 2.0>
      }
      texture { T_Gold_5C }
      //pigment { Yellow }
    }
  }
  text
  {
    ttf "timrom.ttf"
    "Art"
    0.05, 0
    scale <0.5, 0.8, 0.2>
    rotate 90*x
    translate <0.6, 0.12, 0.4>
    pigment { Gray }
  }
}

#declare Stylo_Laser_Rouge = union
{
  merge
  {
    cylinder
    {
      <0.0, -0.2, 0.0>
      <0.0, 1.0, 0.0>
      0.15
    }
    cone
    {
      <0.0, 1.0, 0.0>, 0.15
      <0.0, 1.5, 0.0>, 0.01
    }
    texture
    {
      pigment { color rgbt <1.0, 1.0, 1.0, 0.75> }
      finish { reflection 0.3 }
    }
    halo
    {
      glowing
      cylindrical_mapping
      linear
      turbulence 1.5
      frequency 10.0
      color_map
      {
        [0.0 color rgbf <1.5, 0.0, 0.0, 1.0> ]
        [1.0 color rgbf <0.0, 1.0, 0.0, 0.0> ]
      }
      samples 20
      scale <0.2, 1.5, 0.2>
    }
    hollow
    rotate -90*z
    translate 0.15*y
  }
  cone
  {
    <-0.1, 0.2, 0.0>, 0.02
    <1.5, 0.2, 0.0>, 0.01
    texture
    {
      pigment { Red }
      finish { reflection 0.2 }
    }
  }
  difference
  {
    union
    {
      cylinder
      {
        <0.0, 0.2, 0.0>
        <0.1, 0.2, 0.0>
        0.2
      }
      cylinder
      {
        <0.8, 0.2, 0.0>
        <0.9, 0.2, 0.0>
        0.2
      }
    }
    cylinder
    {
      <-0.2, 0.2, 0.0>
      <1.0, 0.2, 0.0>
      0.15
    }
    texture { T_Silver_5C }
  }
  rotate -5*y
  translate <-1.0, 0.0, -1.2>
}

#declare Stylo_Laser_Bleu = union
{
  merge
  {
    cylinder
    {
      <0.0, -0.2, 0.0>
      <0.0, 1.0, 0.0>
      0.15
    }
    cone
    {
      <0.0, 1.0, 0.0>, 0.15
      <0.0, 1.5, 0.0>, 0.01
    }
    texture
    {
      pigment { color rgbt <1.0, 1.0, 1.0, 0.75> }
      finish { reflection 0.3 }
    }
    halo
    {
      glowing
      cylindrical_mapping
      linear
      turbulence 1.5
      frequency 10.0
      color_map
      {
        [0.0 color rgbf <0.0, 0.0, 1.5, 1.0> ]
        [1.0 color rgbf <0.0, 1.0, 0.0, 0.0> ]
      }
      samples 20
      scale <0.2, 1.5, 0.2>
    }
    hollow
    rotate -90*z
    translate 0.15*y
  }
  cone
  {
    <-0.1, 0.2, 0.0>, 0.02
    <1.5, 0.2, 0.0>, 0.01
    texture
    {
      pigment { Blue }
      finish { reflection 0.2 }
    }
  }
  difference
  {
    union
    {
      cylinder
      {
        <0.0, 0.2, 0.0>
        <0.1, 0.2, 0.0>
        0.2
      }
      cylinder
      {
        <0.8, 0.2, 0.0>
        <0.9, 0.2, 0.0>
        0.2
      }
    }
    cylinder
    {
      <-0.2, 0.2, 0.0>
      <1.0, 0.2, 0.0>
      0.15
    }
    texture { T_Silver_5C }
  }
  rotate -6*y
  translate <-1.0, 0.0, -1.2>
}

#declare Console = union
{
  text
  {
    ttf "cyrvetic.ttf"
    ":::::::::::FTAGlobal-DataBase-History"
    0.01, 0
    scale <0.2, 0.2, 1.0>
    rotate 90*x
    translate <0.2, 0.0, 0.9>
    texture { pigment { rgb <0.0, 0.0, 2.0> } finish { ambient 0.7 } }
    no_shadow
  }
  text
  {
    ttf "cyrvetic.ttf"
    ":::::::::::Please Refer To Related Topics:"
    0.01, 0
    scale <0.2, 0.2, 1.0>
    rotate 90*x
    translate <0.2, 0.0, 0.7>
    texture { pigment { rgb <0.0, 0.0, 2.0> } finish { ambient 0.7 } }
    no_shadow
  }
  text
  {
    ttf "cyrvetic.ttf"
    ":::::::::::(156-Bw-7894) Fire(1), Stone(2)"
    0.01, 0
    scale <0.2, 0.2, 1.0>
    rotate 90*x
    translate <0.2, 0.0, 0.5>
    texture { pigment { rgb <0.0, 0.0, 2.0> } finish { ambient 0.7 } }
    no_shadow
  }
  difference
  {
    box
    {
      <0.0, 0.0, 0.0>
      <4.0, 0.3, 3.0>
    }
    box
    {
      <-1.0, -3.0, -1.0>
      <5.0, 3.0, 0.0>
      rotate 45*x
      translate 0.15*y
    }
    box
    {
      <0.0, -3.0, -1.0>
      <1.0, 3.0, 4.0>
      rotate 45*z
      translate <4.0, 0.15, 0.0>
    }
    //pigment { Red }
    texture
    {
      pigment { rgbf <1.0, 1.0, 1.2, 0.8> }
      finish
      {
        ambient 0.5
        diffuse 0.0
        reflection 0.35
        refraction 1.0
        ior 1.33
        specular 1.0
        roughness 0.001
      }
    }
  }
  rotate -25*x
  rotate -45*y
  translate <-5.0, 1.8, -1.0>
}

#declare Carte_Histoire = union
{
  difference
  {
    box
    {
      <0.0, 0.0, 0.0>
      <2.0, 0.1, 1.0>
      texture { T_Silver_5C }
      //pigment { Gray }
    }
    union
    {
      box
      {
        <0.2, 0.05, 0.2>
        <3.0, 0.2, 0.3>
      }
      box
      {
        <0.2, 0.05, 0.4>
        <0.3, 0.2, 2.0>
      }
      box
      {
        <0.4, 0.05, 0.4>
        <0.5, 0.2, 2.0>
      }
      texture { T_Gold_5C }
      //pigment { Yellow }
    }
  }
  text
  {
    ttf "timrom.ttf"
    "Hist. I"
    0.05, 0
    scale <0.5, 0.8, 0.2>
    rotate 90*x
    translate <0.6, 0.12, 0.4>
    pigment { Gray }
  }
}

#declare Lecteur = union
{
  difference
  {
    box
    {
      <0.0, -0.1, 4.5>
      <3.0, 0.3, 3.0>
    }
    box
    {
      <0.2, 1.0, 4.3>
      <2.8, 0.28, 4.4>
    }
    box
    {
      <0.2, 1.0, 3.1>
      <2.8, 0.28, 3.2>
    }
    box
    {
      <-1.0, 0.075, 2.0>
      <0.025, 0.125, 5.0>
    }
    box
    {
      <-0.5, 0.075, 2.0>
      <3.5, 0.125, 3.025>
    }
    box
    {
      <0.8, 0.0, 4.25>
      <2.8, 0.4, 3.25>
    }
    box
    {
      <0.2, 0.2, 4.25>
      <0.6, 0.4, 3.25>
    }
    texture
    {
      T_Silver_5A
      finish
      {
        crand 0.05
        metallic on
      }
    }
  }
  box
  {
    <0.2, 0.27, 4.25>
    <0.6, 0.29, 3.25>
    texture
    {
      pigment { rgbf <0.5, 0.2, 1.0, 0.8> }
      finish
      {
        ambient 0.5
        diffuse 0.0
        reflection 0.35
        refraction 1.0
        ior 1.33
        specular 1.0
        roughness 0.001
      }
    }
  }
  box
  {
    <0.8, 0.27, 4.25>
    <2.8, 0.29, 3.25>
    texture
    {
      pigment { rgbf <0.5, 1.0, 1.0, 0.8> }
      finish
      {
        ambient 0.5
        diffuse 0.0
        reflection 0.35
        refraction 1.0
        ior 1.33
        specular 1.0
        roughness 0.001
      }
    }
  }
  light_source
  {
    <0.4, 0.25, 3.75>
    color rgb <3.0, 2.0, 2.0>
  }
}


/********************************************************/

object { Livre translate <-2.0, 0.0, -0.5> rotate 20*y }
object { Sol }
object { Table translate <-2.0, 0.0, -0.5> rotate 20*y }
object { Carte_Maths rotate 15*y translate <-3.5, 0.0, 3.5> rotate 20*y no_shadow }
object { Carte_Bio rotate -5*y translate 1.7*x translate 0.15*y translate <-3.5, 0.0, 3.5> rotate 20*y }
object { Carte_Art rotate 25*y translate 2.5*x translate <-3.5, 0.0, 3.5> rotate 20*y }
object { Stylo_Laser_Rouge translate <-2.0, 0.0, -0.5> rotate 20*y }
object { Stylo_Laser_Bleu translate <-2.5, 0.0, -0.1> rotate 20*y }
object { Console rotate 20*y }
object { Carte_Histoire translate <2.3, 0.0, 3.25> rotate 20*y }
object { Lecteur translate <1.5, 0.0, 0.0> rotate 20*y }
