
// Persistence of Vision Ray Tracer Scene Description File
// File: grotte.pov
// Vers: 3
// Auth: Franck ANGELLA, angella@goelette.tsi.u-bordeaux.fr


#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"

camera
{
  location  <0.0 , 0.5 , 0.0>
  look_at   <0.0 , 0.0 , 10.0>
}

light_source
{
  <-5.0, 1.0, 1.0>
  color rgb <0.8 ,0.8 ,1.0>
  spotlight
  point_at <-2.0, -0.5, 5.0>
  radius 60
  tightness 10
  falloff 80
}

light_source
{
  <0.0, 2.0, 1.0>
  color rgb <1.0 ,0.8 ,0.8>
  spotlight
  point_at <-2.0, -0.5, 2.0>
  radius 60
  tightness 10
  falloff 70
  shadowless
}

/*light_source
{
  <-5.0, 1.0, -1.0>
  color red 1.0  green 1.0  blue 1.0
}*/

/*light_source
{
  <0.0, 1.0, -0.5>
  color red 0.6  green 0.5  blue 0.5
  shadowless
}*/


//background { color red 0.1 green 0.3 blue 0.8 }

#declare Sol_Grotte = height_field
{
  gif "grotte.ghf"
  texture
  {
    pigment
    {
      image_map
      {
        gif "mammouts.gif"
        interpolate 2
      }
      scale 2.0
      translate 1.0*x
      rotate x*90
    }
/*    finish
    {
      ambient 0.5
    }*/
  }
//  pigment { color Blue }
  translate <-0.5, 0.0, 0.0>
  scale <20.0, 1.0, 20.0>
  translate -2.0*y
}

#declare Pan_Grotte = height_field
{
  gif "grotte.ghf"
  pigment
  {
    image_map
    {
      gif "mammouts.gif"
      interpolate 2
    }
    rotate x*90
    translate <-0.5, 0.0, -0.5>
    scale 0.4
    translate 0.2*x
  }
  // pigment { color Red }
  translate <-0.5, 0.0, 0.0>
  scale <20.0, 3.0, 20.0>
  rotate -90*x
  rotate 5*y
  translate 9*z
  translate -1*y
}


#declare Plafond_Grotte = height_field
{
  gif "grotte.ghf"
  pigment
  {
    image_map
    {
      gif "mammouts.gif"
      interpolate 2
    }
    rotate x*90
  }
//  pigment { color Green }
  translate <-0.5, 0.0, 0.0>
  scale <20.0, 3.0, 20.0>
  rotate 180*z
  translate 4.0*y
}

#declare Bloc_2 = superellipsoid
{
  <0.3, 0.3>
  texture
  {
//    pigment { Red }
    T_Stone42
    normal { crackle 1.5 }
    normal { granite 1.0 }
    finish { reflection 0.0 phong 0.0 }
  }
}

#declare Bloc_3 = superellipsoid
{
  <0.3, 0.3>
  texture
  {
//    pigment { Red }
    T_Stone37
    normal { crackle 1.5 }
    normal { granite 1.0 }
    finish { reflection 0.0 phong 0.0 }
  }
}

#declare Table = union
{
  object { Bloc_3 scale <3.0, 0.4, 1.3> translate 1.5*y }
  object { Bloc_2 scale <0.3, 1.0, 1.0> translate 0.5*y translate -2.0*x }
  object { Bloc_2 scale <0.3, 1.0, 1.0> translate 0.5*y translate 2.0*x }
  translate 0.5*y
}

#declare Tabouret = union
{
  object { Bloc_3 scale <3.0, 0.4, 1.3> translate 1.5*y }
  object { Bloc_2 scale <0.3, 1.0, 1.0> translate 0.5*y translate -2.0*x }
  object { Bloc_2 scale <0.3, 1.0, 1.0> translate 0.5*y translate 2.0*x }
  translate 0.5*y
  scale 0.5
  translate -0.20*y
}

#declare Place = union
{
  object { Table }
  object { Tabouret translate -4.0*z }
  translate 2.975*z
}

#declare Silex = difference
{
  sphere
  {
    <0.0, 0.0, 0.0> 1.0
    scale <1.0, 2.0, 0.5>
    texture { T_Stone1 finish { reflection 0.0 phong 0.0 } normal { crackle 3.0 scale 2.0 } }
  }
  union
  {
    sphere { <0.0, 2.0, -3.0> 3.0 }
    sphere { <1.0, 2.0, -4.0> 4.0 }
    sphere { <-1.0, 2.0, -4.0> 4.0 }
    sphere { <0.0, 2.0, 3.0> 3.0 }
    sphere { <1.0, 2.0, 4.0> 4.0 }
    sphere { <-1.0, 2.0, 4.0> 4.0 }
    texture { T_Stone16 scale 2.0 normal { dents 3.0 scale 0.5 } }
  }
}

#declare Brindille = cylinder
{
  <-1.5, 0.0, 0.0>
  <1.5, 0.0, 0.0>
  0.2
  texture { T_Wood4 }
}

#declare Flamme = light_source
{
    <0.0, 0.5, 0.0>
    color rgb <1.5, 0.9, 0.9>
    fade_distance 1.0
    fade_power 2.0
    shadowless
    looks_like
    {
      cone
      {
        <0.0, -0.5, 0.0> 1.0
        <0.0, 0.6, 0.0> 0.5
        pigment { color rgbt <1.0, 1.0, 1.0, 1.0> }
        halo
        {
          emitting
          planar_mapping
          linear
          turbulence 1.2
          frequency 2.0
          color_map
          {
            [0.0 color rgbt <1.0, 0.0, 0.0, 1.0> ]
            [1.0 color rgbt <1.0, 1.0, 0.0, 0.0> ]
          }
          samples 10
          scale <0.5, 0.9, 0.5>
        }
        hollow
        scale <0.2, 1.0, 0.2>
      }
    }
}

#declare Tableau = difference
{
  superellipsoid
  {
    <0.3, 0.3>
  }
  box
  {
    <0.0, -5.0, -2.0>
    <5.0, 5.0, 2.0>
    rotate 40*z
    rotate 5*y
    translate <0.7, 0.7, 0.0>
  }
  box
  {
    <0.0, -5.0, -2.0>
    <5.0, 5.0, 2.0>
    rotate 30*z
    rotate 2*y
    translate <0.7, 0.7, 0.0>
  }
  texture
  {
    pigment
    {
      image_map
      {
        gif "dino3.gif"
        interpolate 2
      }
      scale 2.0
      translate <-1.0, -1.0, 0.0>
    }
  }
  scale <3.0, 4.0, 0.7>
  translate 4.0*y
}


/****************************************************************************************/

object { Sol_Grotte }
object { Plafond_Grotte }
object { Pan_Grotte }
//plane { z 9.0 pigment { Green } }
object { Place scale 0.3 translate -0.285*y rotate 10*y translate <-4.0, -1.0, 5.0> }
object { Place scale 0.3 translate -0.285*y rotate 15*y translate <-2.0, -1.0, 5.0> }
object { Place scale 0.3 translate -0.285*y rotate 20*y translate <0.0, -1.0, 5.0> }
object { Place scale 0.3 translate -0.285*y rotate 10*y translate <-4.0, -1.0, 2.0> }
object { Place scale 0.3 translate -0.285*y rotate 15*y translate <-2.0, -1.0, 2.0> }
object { Place scale 0.3 translate -0.285*y rotate 20*y translate <0.0, -1.0, 2.0> }
object { Silex scale 0.1 rotate <-90.0, -30.0, 0.0> translate <0.0, -0.38, 2.5> }
object { Brindille scale 0.1 rotate <0.0, 45.0, 0.0> translate <0.5, -0.41, 2.3> }
object { Brindille scale 0.1 rotate <0.0, 70.0, 0.0> translate <0.4, -0.41, 2.3> }
object { Brindille scale 0.1 rotate <0.0, 15.0, 0.0> translate <0.45, -0.41, 2.3> }
object { Flamme scale 0.3 translate <0.425, -0.41, 2.3> }
object { Tableau scale 0.3 rotate 10*y rotate 10*x translate <-1.8, -1.0, 6.5> }
