#ifdef(Apple1_Inc_Temp)
// do nothing
#else
#declare Apple1_Inc_Temp=version
#version 3.0

// This POV-Ray include file defines an apple
// to be placed in the school scene.  It uses
// a lathe object based on a tracing of a real
// apple.  The stem of the apple is a section
// of torus with a minor radius of about 0.08
// and a major radius of about 3.5, the stem
// is a bozo of brown and black.
//  
// The texture for the apple is a very gently
// spotted pattern of tiny dark red spots
// on the red apple, plus a transparent overlayer
// of even tinier yellow spots, handled with
// a pigment map to make more of the yellow spots
// appear nearer the top of the apple.  The overall 
// finish for the texture is a fairly smooth 
// highly specular finish with no reflectivity.
//

// the apple shape, a surface of revolution using
// the POV-Ray lathe object.
#declare asr = AppleStemRadius/3

#declare AppleBasicShape = lathe {
	cubic_spline
	20
	<asr + 0, 1.0>,
	<asr + 0, 0.6>,
	<asr + 0,	0.46>,
	<asr + 0.125,	0.25>,
	<asr + 0.25,	0.051>,
	<asr + 0.5,	-0.03>,
	<asr + 0.75,	0.052>,
	<asr + 1.0,	0.25>,
	<asr + 1.25,	0.55>,
	<asr + 1.5,	1.0>,
	// <asr + 1.63,	1.45>,
	<asr + 1.643,	1.75>,
	//<asr + 1.63,	2.05>,
	<asr + 1.475,	2.6>,
	<asr + 1.25,	2.911>,
	<asr + 1.0,	3.03>,
	<asr + 0.75,	2.95>,
	<asr + 0.5,	2.88>,
	<asr + 0.25,	2.74>,
	<asr + 0.0,	2.51 >,
	<asr + 0.0, 2.4>,
	<asr + 0.0, 2.0>
	sturm
	// hollow
}
#declare AppleShapeHeight = 3.0


#declare BasicStemPrecursor = torus { AppleStemCurveRadius, AppleStemRadius }

#declare BasicStemShape = intersection {
	object { BasicStemPrecursor 
		 rotate <90,0,0> 
		 translate <AppleStemCurveRadius,0,0>
	}
	cylinder { <0,0,-1>, <0,0,1>, AppleStemSizeRadius }
	box { <-1,0,-1>,<AppleStemSizeRadius,AppleStemSizeRadius,1> }
}

#declare AppleStemTexture = texture {
	pigment {
		gradient y
		color_map {
			[0.0 color Khaki]
			[0.67 color DarkBrown]
			[1.0 color VeryDarkBrown]
		}
		scale <1,1.75,1>
		rotate <0,0,-25>
	}
	finish {
		ambient BasicAmbient diffuse BasicDiffuse
		phong 0.3 phong_size 20
	}
}

	

#declare StemShape = object {
	BasicStemShape
	texture { AppleStemTexture }
	scale <1, 1.1, 1>
	translate <0,2.5,0>
}

// apple texture
#declare AppleDarkRed = color rgb<0.52,0.25,0.21>
#declare AppleMediumRed=color rgb<0.53,0.27,0.22>
#declare AppleLightRed = color rgb<0.54,0.29,0.23>

#declare AppleBasicRedPigment = pigment {
	bozo 
	color_map {
		[0.0 0.67 color AppleMediumRed color AppleMediumRed ]
		[0.67 0.8 color AppleMediumRed color AppleLightRed ]
		[0.8 0.9 color AppleLightRed color AppleLightRed]
		[0.9 1.0 color AppleLightRed color AppleMediumRed]
	}
	turbulence 0.38
	octaves 2
	scale <0.041,0.093,0.041>
	rotate <10,20,30>
}

#declare WhiteYellow = color rgb<0.96,0.99,0.51>
#declare AppleSpotsPigment = pigment {
	granite color_map { 
		[0.0 0.83 color Clear color Clear]
		[0.75 0.80 color Clear color Khaki]
		[0.80 1.0  color Khaki color WhiteYellow]
	}
	scale 0.35
}

#declare AppleOverPigment = pigment {
	gradient y
	pigment_map {
		[0.0 color Clear]
		[0.1 color Clear]
		[0.54 AppleSpotsPigment]
		[1.0 AppleSpotsPigment]
	}
	scale <1,AppleShapeHeight,1>
}

#declare AppleSkinFinish = finish {
	ambient BasicAmbient diffuse (BasicDiffuse * 0.95)
	specular 0.7 roughness 0.014
	brilliance 0.1
}

#declare AppleFinalTexture = texture {
	pigment { AppleBasicRedPigment }
	finish { AppleSkinFinish }
}
texture {
	pigment { AppleOverPigment }
	finish { ambient BasicAmbient diffuse BasicDiffuse+0.1 }
}


// the entire apple!
#declare WholeApple = union {
	object { AppleBasicShape texture { AppleFinalTexture } }
	object { StemShape }
}



#version Apple1_Inc_Temp
#end
